/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.trace.instrument.AOP;

public class JedisClientProxy
implements InvocationHandler {
    private final Object jc;
    private final AOP aop;

    public JedisClientProxy(Object jc, AOP aop) {
        this.jc = jc;
        this.aop = aop;
    }

    public static Object createProxy(Object target, Class<?> clazz, AOP aop) {
        if (target == null) {
            throw new NullPointerException();
        }
        if (aop == null) {
            throw new NullPointerException("Aop is null for " + target.getClass().getName());
        }
        Object _proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new JedisClientProxy(target, aop));
        return _proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        this.aop.before(this.jc, method, args);
        try {
            result = method.invoke(this.jc, args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)e;
                throw invocationTargetException.getTargetException();
            }
            throw e;
        }
        this.aop.after(this.jc, method, args, result);
        return result;
    }

    public static Object getOriginalObject(Object proxy) {
        if (proxy instanceof JedisClientProxy) {
            JedisClientProxy t = (JedisClientProxy)proxy;
            return t.jc;
        }
        return proxy;
    }
}

