/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.Resources;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import kd.bos.redis.JedisClientProxy;
import kd.bos.redis.RedisGovern;
import kd.bos.redis.RedisTracker;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0BuilderImpl;
import kd.bos.redis.pool.router.Dispatcher;
import kd.bos.redis.pool.router.DispatcherFactory;
import kd.bos.redis.wrapper.MultiJedisClient;
import kd.bos.redis.wrapper.Wrapper;
import kd.bos.trace.instrument.AOP;
import kd.bos.trace.instrument.TraceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisFactory {
    private static final Logger logger = LoggerFactory.getLogger(RedisFactory.class);
    private static final Map<Object, Object> resourceWraps = new ConcurrentHashMap<Object, Object>(2);
    private static ConcurrentHashMap<String, Pool0<?>> poolMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, JedisClient> jedisFakeMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, JedisClient> multiJedisMap = new ConcurrentHashMap();

    private static Object getJedisClient(String url, boolean original) {
        if (Instance.isLightWeightDeploy()) {
            return RedisFactory.getJedisFakeClient(url);
        }
        if (url != null && url.contains("||")) {
            return RedisFactory.getMultiJedisClient(url, original);
        }
        RedisGovern.entry(url);
        Pool0 pool = poolMap.computeIfAbsent(url, key -> {
            try {
                return Pool0BuilderImpl.getPool(Encrypters.decode((String)key));
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{Resources.getString((String)"bos-redis", (String)"RedisFactory_1", (Object[])new Object[0])});
            }
        });
        try {
            Object resource = pool.getResource();
            if (Boolean.getBoolean("redis.client.multithreadaccess.trace")) {
                int size = resourceWraps.size();
                if (size > 1000) {
                    logger.warn("resourceWraps size over 1000:" + size);
                    resourceWraps.clear();
                }
                Object _resource = resourceWraps.computeIfAbsent(resource, k -> TraceProxy.createProxy((Object)resource, resource.getClass(), (AOP)new AOP(){
                    long curThreadId;
                    Map accessThreads = new ConcurrentHashMap(2);
                    {
                        this.curThreadId = Thread.currentThread().getId();
                    }

                    public void after(Object arg0, Method arg1, Object[] arg2, Object arg3) {
                    }

                    public void before(Object arg0, Method method, Object[] arg2) {
                        if (!Boolean.getBoolean("redis.client.multithreadaccess.trace")) {
                            return;
                        }
                        if (method.getName().equalsIgnoreCase("close")) {
                            this.accessThreads.remove(this.curThreadId);
                        } else {
                            this.accessThreads.computeIfAbsent(this.curThreadId, k -> RedisFactory.getThreadTrace());
                            if (this.accessThreads.size() > 1) {
                                long tag = System.currentTimeMillis();
                                this.accessThreads.forEach((k, v) -> {
                                    StringBuilder errorString = new StringBuilder("[");
                                    errorString.append(tag).append("]jedisclient accessed by mulitThread ").append(k).append(",stack is:").append((String)v);
                                    logger.error(errorString.toString());
                                });
                                throw new KDException(BosErrorCode.redisRead, new Object[]{"mulit access jedisclient error"});
                            }
                        }
                    }
                }));
                _resource = TraceProxy.createProxy((Object)_resource, resource.getClass(), (AOP)new AOP(){
                    boolean isClosed = false;

                    public void after(Object arg0, Method arg1, Object[] arg2, Object arg3) {
                    }

                    public void before(Object arg0, Method method, Object[] arg2) {
                        if (!Boolean.getBoolean("redis.client.multithreadaccess.trace")) {
                            return;
                        }
                        if (this.isClosed) {
                            throw new KDException(BosErrorCode.redisRead, new Object[]{"jedisclient has closed and can't access it"});
                        }
                        if (method.getName().equalsIgnoreCase("close")) {
                            this.isClosed = true;
                        }
                    }
                });
                return original ? _resource : RedisTracker.track(Wrapper.wrap(_resource, url));
            }
            return original ? resource : RedisTracker.track(Wrapper.wrap(resource, url));
        }
        catch (Exception e) {
            Throwable sub;
            String msg = null;
            for (sub = e; sub != null && sub.getCause() != null; sub = sub.getCause()) {
            }
            if (sub != null) {
                msg = "Get JedisClient error: " + sub.getMessage() + ",trackMessage:" + RedisTracker.getTrackMessage();
            }
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg});
        }
    }

    private static JedisClient getJedisFakeClient(String url) {
        JedisClient jedisfake = jedisFakeMap.computeIfAbsent(url, key -> {
            try {
                Constructor<?> constructor = Class.forName("kd.bos.fake.redis.JedisClientFake").getConstructor(String.class);
                return (JedisClient)constructor.newInstance(url);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{Resources.getString((String)"bos-redis", (String)"RedisFactory_0", (Object[])new Object[0])});
            }
        });
        return jedisfake;
    }

    private static Object getMultiJedisClient(String url, boolean original) {
        String[] parts = url.split("\\|\\|");
        if (original) {
            return RedisFactory.getJedisClient(parts[0], true);
        }
        return multiJedisMap.computeIfAbsent(url, key -> {
            ArrayList<String> urls = new ArrayList<String>(parts.length);
            Collections.addAll(urls, parts);
            Dispatcher dispatcher = DispatcherFactory.build(urls);
            return new MultiJedisClient(dispatcher);
        });
    }

    private static String getThreadTrace() {
        StringWriter sw = new StringWriter();
        new Exception("redis Stack trace,ThreadName:" + Thread.currentThread().getName()).printStackTrace(new PrintWriter(sw));
        String threadStack = sw.toString();
        return threadStack;
    }

    public static JedisClient getJedisClient(String url) {
        if (Boolean.getBoolean("redis.client.eval.enable")) {
            return (JedisClient)RedisFactory.getJedisClient(url, false);
        }
        Object client = JedisClientProxy.createProxy(RedisFactory.getJedisClient(url, false), JedisClient.class, new AOP(){

            public void before(Object proxy, Method method, Object[] args) {
                if (!"eval".equals(method.getName())) {
                    return;
                }
                Object param = null;
                if (args.length >= 2) {
                    param = args[1];
                }
                if (param instanceof Integer && (Integer)param > 1) {
                    throw new KDException(BosErrorCode.redisWrite, new Object[]{"JedisClient do not support the method of eval for multiple keys"});
                }
            }

            public void after(Object proxy, Method method, Object[] args, Object result) {
            }
        });
        return (JedisClient)client;
    }

    public static Object $getJedisClientOriginal(String url) {
        return RedisFactory.getJedisClient(url, true);
    }
}

