/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis;

import java.util.HashSet;
import java.util.Set;
import kd.bos.util.Pair;

public class RedisProtocols {
    public static final String PROTOCOL_DELIMITER = ":";
    public static final String REDIS_STANDALONE = "redis";
    public static final String REDIS_SHARD = "shard";
    public static final String REDIS_SENTINEL = "sentinel";
    public static final String REDIS_CLUSTER = "cluster";
    public static final String XCACHE_HOSTING = "xcache_hosting";
    public static final String XCACHE_MSERVICE = "xcache_mservice";
    public static final Set<String> PROTOCOLS = new HashSet<String>();

    public static boolean isXCache(String url) {
        Pair<String, String> protocolAndUrl = RedisProtocols.getProtocolAndUrl(url);
        return XCACHE_MSERVICE.equals(protocolAndUrl.getKey()) || XCACHE_HOSTING.equals(protocolAndUrl.getKey());
    }

    public static Pair<String, String> getProtocolAndUrl(String url) {
        String poolUrl;
        if (url == null) {
            return new Pair((Object)REDIS_STANDALONE, null);
        }
        int i = url.indexOf(PROTOCOL_DELIMITER);
        String protocol2 = i > 0 ? url.substring(0, i).toLowerCase().trim() : null;
        String string = poolUrl = i >= 0 ? url.substring(i + 1) : url;
        if (!PROTOCOLS.contains(protocol2)) {
            protocol2 = REDIS_STANDALONE;
            poolUrl = url;
        }
        return new Pair((Object)protocol2, (Object)poolUrl);
    }

    static {
        PROTOCOLS.add(REDIS_STANDALONE);
        PROTOCOLS.add(REDIS_SHARD);
        PROTOCOLS.add(REDIS_SENTINEL);
        PROTOCOLS.add(REDIS_CLUSTER);
        PROTOCOLS.add(XCACHE_HOSTING);
        PROTOCOLS.add(XCACHE_MSERVICE);
    }
}

