/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.redis.JedisClientProxy;

public class RedisTracker
implements InvocationHandler {
    private static final Map<Object, RedisTracker> proxyMap = new ConcurrentHashMap<Object, RedisTracker>();
    private final long tsStart;
    private final Thread thread;
    private final String threadStack;
    private final Object jc;
    private final List<String> unclosedInvokes = new LinkedList<String>();

    public static Object track(Object jc) {
        if (Boolean.parseBoolean(System.getProperty("redis.track.enable", "false"))) {
            RedisTracker tracker = new RedisTracker(jc);
            proxyMap.put(jc, tracker);
            return tracker.createProxy();
        }
        return jc;
    }

    public static Object getOriginalObject(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            InvocationHandler jc = Proxy.getInvocationHandler(proxy);
            Object _proxy = JedisClientProxy.getOriginalObject(jc);
            if (_proxy instanceof RedisTracker) {
                RedisTracker t = (RedisTracker)_proxy;
                return t.jc;
            }
            if (Proxy.isProxyClass(_proxy.getClass())) {
                RedisTracker t = (RedisTracker)Proxy.getInvocationHandler(_proxy);
                return t.jc;
            }
            return _proxy;
        }
        return proxy;
    }

    public static String getTrackMessage() {
        return "[" + proxyMap.size() + "]" + new HashMap<Object, RedisTracker>(proxyMap).toString();
    }

    private RedisTracker(Object jc) {
        this.jc = jc;
        this.thread = Thread.currentThread();
        StringWriter sw = new StringWriter();
        new Exception("Stack trace").printStackTrace(new PrintWriter(sw));
        this.threadStack = sw.toString();
        this.tsStart = System.currentTimeMillis();
    }

    private Object createProxy() {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.jc.getClass().getInterfaces(), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("close".equals(name)) {
            proxyMap.remove(this.jc);
            this.unclosedInvokes.clear();
        } else {
            this.unclosedInvokes.add(name + (args == null ? "" : "#" + Arrays.deepToString(args)));
        }
        return method.invoke(this.jc, args);
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.thread).append(" get redis client @").append(sdf.format(this.tsStart)).append(" ").append(this.jc);
        sb.append(" not closed yet,\n").append(this.threadStack).append(", invokes(").append(this.unclosedInvokes.size()).append("):\n");
        sb.append(this.unclosedInvokes);
        return sb.toString();
    }
}

