/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.custom;

import java.util.HashMap;
import java.util.Map;
import kd.bos.redis.JedisClient;
import kd.bos.redis.custom.tong.TongClusterJedisClient;
import kd.bos.redis.custom.tong.TongCommonJedisClient;
import kd.bos.redis.custom.tong.TongShardedJedisClient;
import kd.bos.redis.wrapper.ClusterJedisClient;
import kd.bos.redis.wrapper.CommonJedisClient;
import kd.bos.redis.wrapper.ShardedJedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.ShardedJedis;

public class VendorWrapper {
    private static final Logger log = LoggerFactory.getLogger(VendorWrapper.class);
    private static final String VENDOR = "vendor";
    private static final String TONG = "tong";
    private static final Map<String, Class> commonJedisClientMap = new HashMap<String, Class>();
    private static final Map<String, Class> ClusterJedisClientMap = new HashMap<String, Class>();
    private static final Map<String, Class> ShardedJedisClientMap = new HashMap<String, Class>();

    public static JedisClient wrap(Object jedis, String url, String vendor) {
        JedisClient jedisClient;
        if (jedis instanceof Jedis) {
            jedisClient = VendorWrapper.getCommonJedisClient((Jedis)jedis, vendor);
        } else if (jedis instanceof ShardedJedis) {
            jedisClient = VendorWrapper.getShardedJedisClient((ShardedJedis)jedis, vendor);
        } else if (jedis instanceof JedisCluster) {
            jedisClient = VendorWrapper.getClusterJedisClient((JedisCluster)jedis, vendor);
        } else {
            throw new RuntimeException("Not implements: " + jedis.getClass().getName());
        }
        return jedisClient;
    }

    private static CommonJedisClient getCommonJedisClient(Jedis jedis, String vendor) {
        Class cl = commonJedisClientMap.get(vendor);
        if (cl != null) {
            try {
                return (CommonJedisClient)cl.getConstructor(Jedis.class).newInstance(jedis);
            }
            catch (Exception e) {
                log.warn("Error when create instance of Jedis", (Throwable)e);
            }
        }
        return new CommonJedisClient(jedis);
    }

    private static ClusterJedisClient getClusterJedisClient(JedisCluster jedis, String vendor) {
        Class cl = ClusterJedisClientMap.get(vendor);
        if (cl != null) {
            try {
                return (ClusterJedisClient)cl.getConstructor(JedisCluster.class).newInstance(jedis);
            }
            catch (Exception e) {
                log.warn("Error when create instance of JedisCluster", (Throwable)e);
            }
        }
        return new ClusterJedisClient(jedis);
    }

    private static ShardedJedisClient getShardedJedisClient(ShardedJedis jedis, String vendor) {
        Class cl = ShardedJedisClientMap.get(vendor);
        if (cl != null) {
            try {
                return (ShardedJedisClient)cl.getConstructor(ShardedJedis.class).newInstance(jedis);
            }
            catch (Exception e) {
                log.warn("Error when create instance of ShardedJedis", (Throwable)e);
            }
        }
        return new ShardedJedisClient(jedis);
    }

    static {
        commonJedisClientMap.put(TONG, TongCommonJedisClient.class);
        ClusterJedisClientMap.put(TONG, TongClusterJedisClient.class);
        ShardedJedisClientMap.put(TONG, TongShardedJedisClient.class);
    }
}

