/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.custom.tong;

import kd.bos.redis.custom.tong.TongConfig;
import kd.bos.redis.wrapper.CommonJedisClient;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Protocol;

public class TongCommonJedisClient
extends CommonJedisClient {
    private Jedis jedis;

    public TongCommonJedisClient(Jedis jedis) {
        super(jedis);
        this.jedis = jedis;
    }

    @Override
    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua.getBytes(), Protocol.toByteArray((int)1), (byte[][])new byte[][]{key, value, pivot, Protocol.toByteArray((int)where.ordinal())});
        }
        return super.rpush(key, new byte[][]{value});
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua.getBytes(), Protocol.toByteArray((int)1), (byte[][])new byte[][]{key, value, pivot, Protocol.toByteArray((int)where.ordinal())});
        }
        return super.rpush(key, new byte[][]{value});
    }

    @Override
    public Long linsert(String key, ListPosition where, String pivot, String value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua, 1, new String[]{key, value, pivot, where.ordinal() + ""});
        }
        return super.rpush(key, value);
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua, 1, new String[]{key, value, pivot, where.ordinal() + ""});
        }
        return super.rpush(key, value);
    }
}

