/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.custom.tong;

import java.util.Arrays;
import java.util.Collections;
import kd.bos.redis.custom.tong.TongConfig;
import kd.bos.redis.wrapper.ShardedJedisClient;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ShardedJedis;

public class TongShardedJedisClient
extends ShardedJedisClient {
    private ShardedJedis jedis;

    public TongShardedJedisClient(ShardedJedis jedis) {
        super(jedis);
        this.jedis = jedis;
    }

    @Override
    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua.getBytes(), Protocol.toByteArray((int)1), key, value, pivot, Protocol.toByteArray((int)where.ordinal()));
        }
        return super.rpush(key, new byte[][]{value});
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua.getBytes(), Protocol.toByteArray((int)1), key, value, pivot, Protocol.toByteArray((int)where.ordinal()));
        }
        return super.rpush(key, new byte[][]{value});
    }

    @Override
    public Long linsert(String key, ListPosition where, String pivot, String value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua, Collections.singletonList(key), Arrays.asList(value, pivot, where.ordinal() + ""));
        }
        return super.rpush(key, value);
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        if (TongConfig.enableEval()) {
            return (Long)this.jedis.eval(TongConfig.linsert_lua, Collections.singletonList(key), Arrays.asList(value, pivot, where.ordinal() + ""));
        }
        return super.rpush(key, value);
    }
}

