/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool;

import kd.bos.metric.MetricSystem;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolConfigGeneral {
    private static final Logger logger = LoggerFactory.getLogger(JedisPoolConfigGeneral.class);
    private static final int default_maxTotal = 50;
    private static final boolean default_testWhileIdle = true;
    private static final long default_minEvictableIdleTimeMillis = 30000L;
    private static final int default_numTestsPerEvictionRun = -1;
    private static final int default_maxIdle = 10;
    private static final int default_minIdle = 5;
    private static final int default_maxWaitMillis = 5000;
    private static final boolean default_testOnBorrow = false;
    private static final boolean default_testOnReturn = false;
    private static final long default_timeBetweenEvictionRunsMillis = 30000L;
    private static final boolean default_fairness = false;
    private static final boolean default_lifo = true;
    private static final boolean default_testOnCreate = false;
    private static final long default_softMinEvictableIdleTimeMillis = -1L;
    private static final boolean default_blockWhenExhausted = true;
    private static final String default_evictionPolicyClassName = "org.apache.commons.pool2.impl.DefaultEvictionPolicy";
    private static final String POOL_MAX_TOTAL = "redis.pool.maxTotal";

    public JedisPoolConfig getPoolConfig() {
        int maxTotal = ConfigurationUtil.getInteger((String)POOL_MAX_TOTAL, (Integer)50);
        boolean testWhileIdle = ConfigurationUtil.getBoolean((String)"redis.pool.testWhileIdle", (Boolean)true);
        long minEvictableIdleTimeMillis = ConfigurationUtil.getLong((String)"redis.pool.minEvictableIdleTimeMillis", (Long)30000L);
        int numTestsPerEvictionRun = ConfigurationUtil.getInteger((String)"redis.pool.numTestsPerEvictionRun", (Integer)-1);
        int maxIdle = ConfigurationUtil.getInteger((String)"redis.pool.maxIdle", (Integer)10);
        int minIdle = ConfigurationUtil.getInteger((String)"redis.pool.minIdle", (Integer)5);
        int maxWaitMillis = ConfigurationUtil.getInteger((String)"redis.pool.maxWaitMillis", (Integer)5000);
        boolean testOnBorrow = ConfigurationUtil.getBoolean((String)"redis.pool.testOnBorrow", (Boolean)false);
        boolean testOnReturn = ConfigurationUtil.getBoolean((String)"redis.pool.testOnReturn", (Boolean)false);
        long timeBetweenEvictionRunsMillis = ConfigurationUtil.getLong((String)"redis.pool.timeBetweenEvictionRunsMillis", (Long)30000L);
        boolean fairness = ConfigurationUtil.getBoolean((String)"redis.pool.fairness", (Boolean)false);
        boolean lifo = ConfigurationUtil.getBoolean((String)"redis.pool.lifo", (Boolean)true);
        boolean testOnCreate = ConfigurationUtil.getBoolean((String)"redis.pool.testOnCreate", (Boolean)false);
        long softMinEvictableIdleTimeMillis = ConfigurationUtil.getLong((String)"redis.pool.softMinEvictableIdleTimeMillis", (Long)-1L);
        boolean blockWhenExhausted = ConfigurationUtil.getBoolean((String)"redis.pool.blockWhenExhausted", (Boolean)true);
        String evictionPolicyClassName = ConfigurationUtil.getString((String)"redis.pool.evictionPolicyClassName", (String)default_evictionPolicyClassName);
        JedisPoolConfig config = new JedisPoolConfig();
        config.setTestWhileIdle(testWhileIdle);
        config.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        config.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        config.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        config.setMaxTotal(maxTotal);
        config.setMaxIdle(maxIdle);
        config.setMinIdle(minIdle);
        config.setMaxWaitMillis((long)maxWaitMillis);
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnReturn(testOnReturn);
        config.setTestOnCreate(testOnCreate);
        config.setBlockWhenExhausted(blockWhenExhausted);
        config.setEvictionPolicyClassName(evictionPolicyClassName);
        config.setFairness(fairness);
        config.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
        config.setLifo(lifo);
        return config;
    }

    public GenericObjectPoolConfig getGenericObjectPoolConfig() {
        int maxTotal = ConfigurationUtil.getInteger((String)POOL_MAX_TOTAL, (Integer)50);
        boolean testWhileIdle = ConfigurationUtil.getBoolean((String)"redis.pool.testWhileIdle", (Boolean)true);
        long minEvictableIdleTimeMillis = ConfigurationUtil.getLong((String)"redis.pool.minEvictableIdleTimeMillis", (Long)30000L);
        int numTestsPerEvictionRun = ConfigurationUtil.getInteger((String)"redis.pool.numTestsPerEvictionRun", (Integer)-1);
        int maxIdle = ConfigurationUtil.getInteger((String)"redis.pool.maxIdle", (Integer)10);
        int minIdle = ConfigurationUtil.getInteger((String)"redis.pool.minIdle", (Integer)5);
        int maxWaitMillis = ConfigurationUtil.getInteger((String)"redis.pool.maxWaitMillis", (Integer)5000);
        boolean testOnBorrow = ConfigurationUtil.getBoolean((String)"redis.pool.testOnBorrow", (Boolean)false);
        boolean testOnReturn = ConfigurationUtil.getBoolean((String)"redis.pool.testOnReturn", (Boolean)false);
        long timeBetweenEvictionRunsMillis = ConfigurationUtil.getLong((String)"redis.pool.timeBetweenEvictionRunsMillis", (Long)30000L);
        boolean fairness = ConfigurationUtil.getBoolean((String)"redis.pool.fairness", (Boolean)false);
        boolean lifo = ConfigurationUtil.getBoolean((String)"redis.pool.lifo", (Boolean)true);
        boolean testOnCreate = ConfigurationUtil.getBoolean((String)"redis.pool.testOnCreate", (Boolean)false);
        long softMinEvictableIdleTimeMillis = ConfigurationUtil.getLong((String)"redis.pool.softMinEvictableIdleTimeMillis", (Long)-1L);
        boolean blockWhenExhausted = ConfigurationUtil.getBoolean((String)"redis.pool.blockWhenExhausted", (Boolean)true);
        String evictionPolicyClassName = ConfigurationUtil.getString((String)"redis.pool.evictionPolicyClassName", (String)default_evictionPolicyClassName);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setTestWhileIdle(testWhileIdle);
        config.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        config.setMaxTotal(maxTotal);
        config.setMaxIdle(maxIdle);
        config.setMinIdle(minIdle);
        config.setMaxWaitMillis((long)maxWaitMillis);
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnReturn(testOnReturn);
        config.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        config.setTestOnCreate(testOnCreate);
        config.setBlockWhenExhausted(blockWhenExhausted);
        config.setEvictionPolicyClassName(evictionPolicyClassName);
        config.setFairness(fairness);
        config.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
        config.setLifo(lifo);
        return config;
    }

    static {
        try {
            MetricSystem.registerGauge((String)"kd.metrics.redis.pool.maxTotal", () -> ConfigurationUtil.getInteger((String)POOL_MAX_TOTAL, (Integer)50));
        }
        catch (Exception e) {
            logger.error("static block init exception", (Throwable)e);
        }
    }
}

