/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.XCacheMServiceHostFetcher;
import kd.bos.redis.pool.builder.XCacheHostingBuilder;
import kd.bos.redis.pool.builder.bean.RedisInfo;
import kd.bos.redis.xcache.XCacheJedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.Pool;

public class XCacheMServicePool
implements Pool0<XCacheJedisClient> {
    private static final Logger log = LoggerFactory.getLogger(XCacheMServicePool.class);
    private static final XCacheMServiceHostFetcher hostFetcher;
    private static final String MODULE = "xcache-client.mservice";
    private static final ThreadFactory threadFactory;
    private volatile String hostUrl;
    private volatile Pool<Jedis> pool;

    public XCacheMServicePool(String url, int connectionTimeout, int soTimeout) {
        RedisInfo redisInfo;
        try {
            redisInfo = XCacheHostingBuilder.parseUrl(url);
        }
        catch (InvalidURIException e) {
            throw new InvalidURIException(String.format("Invalid xcache mservice url, excepted[group:port] but was : [%s]", url));
        }
        String groupName = redisInfo.getHostAndPorts().iterator().next().getHost();
        this.createOrFlushPool(url, groupName, connectionTimeout, soTimeout);
        Executors.newSingleThreadScheduledExecutor(threadFactory).scheduleAtFixedRate(() -> this.createOrFlushPool(url, groupName, connectionTimeout, soTimeout), 3L, 3L, TimeUnit.SECONDS);
    }

    private void createOrFlushPool(String url, String groupName, int connectionTimeout, int soTimeout) {
        String masterHost = XCacheMServicePool.getMasterHost(groupName);
        if (masterHost == null || masterHost.trim().isEmpty()) {
            return;
        }
        String newHostUrl = url.replace(groupName, masterHost);
        if (Objects.equals(newHostUrl, this.hostUrl)) {
            return;
        }
        log.info(String.format("XCache mservice host set to %s", masterHost));
        Pool<Jedis> oldPool = this.pool;
        this.pool = XCacheHostingBuilder.createXCachePool(MODULE, newHostUrl, connectionTimeout, soTimeout);
        this.hostUrl = newHostUrl;
        if (log.isDebugEnabled()) {
            log.debug(String.format("XCache mservice pool created; pool[%s], host:[%s]", this.pool, this.hostUrl));
        }
        if (oldPool != null) {
            oldPool.destroy();
        }
    }

    private static String getMasterHost(String groupName) {
        return hostFetcher.getHost(groupName);
    }

    @Override
    public XCacheJedisClient getResource() {
        Pool<Jedis> p = this.pool;
        if (p != null) {
            return new XCacheJedisClient(p.getResource());
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Thread: %s XCache mservice not available; pool[%s], host:[%s]", Thread.currentThread().getName(), this.pool, this.hostUrl));
        }
        throw new JedisConnectionException(String.format("XCache mservice not available, host:[%s]", this.hostUrl));
    }

    static {
        try {
            hostFetcher = (XCacheMServiceHostFetcher)Class.forName("kd.bos.xcache.starter.elect.ElectorClient").newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new JedisException(String.format("Error when init XCacheMServiceHostFetcher implement: %s", e.getMessage()), (Throwable)e);
        }
        threadFactory = new NamedDaemonThreadFactory("xcache-client-mservice-pool-checker-");
    }

    static class NamedDaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedDaemonThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public synchronized Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }
}

