/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import java.util.HashSet;
import java.util.Set;
import kd.bos.redis.pool.JedisPoolConfigGeneral;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0Builder;
import kd.bos.redis.pool.SinglePool0;
import kd.bos.redis.pool.builder.AbstractPoolBuilder;
import kd.bos.redis.pool.builder.PoolMetric;
import kd.bos.redis.pool.builder.RedisInfoParser;
import kd.bos.redis.pool.builder.bean.RedisInfo;
import kd.bos.redis.wrapper.JedisClusterExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

public class ClusterBuilder
extends AbstractPoolBuilder<JedisCluster>
implements Pool0Builder<JedisCluster> {
    private static final Logger logger = LoggerFactory.getLogger(ClusterBuilder.class);

    @Override
    public Pool0<JedisCluster> build(String url, boolean ssl) {
        RedisInfo redisInfo = RedisInfoParser.parseUrl(url);
        Set<HostAndPort> hosts = this.parseServer(redisInfo);
        JedisPoolConfig config = new JedisPoolConfigGeneral().getPoolConfig();
        JedisCluster jedis = this.createInstance(config, hosts, redisInfo.getPassword());
        this.attachMetric(jedis, config);
        return new SinglePool0<JedisCluster>(jedis);
    }

    private JedisCluster createInstance(JedisPoolConfig config, Set<HostAndPort> hosts, String password) {
        return new JedisClusterExt(hosts, this.connectionTimeout(), this.soTimeout(), 5, password, config);
    }

    private void attachMetric(JedisCluster jedis, JedisPoolConfig config) {
        jedis.getClusterNodes().forEach((k, x) -> {
            try {
                HostAndPort hostAndPort = HostAndPort.from((String)k);
                PoolMetric.setPool((Pool)x, hostAndPort.getHost() + "-" + hostAndPort.getPort(), config.getMaxTotal());
            }
            catch (Exception e) {
                logger.warn("ClusterBuilder.attachMetric exception: " + k, (Throwable)e);
            }
        });
    }

    private Set<HostAndPort> parseServer(RedisInfo redisInfo) {
        HashSet<HostAndPort> hosts = new HashSet<HostAndPort>();
        redisInfo.getHostAndPorts().forEach(hostAndPort -> {
            HostAndPort hp = new HostAndPort(hostAndPort.getHost(), hostAndPort.getPort());
            hosts.add(hp);
        });
        return hosts;
    }
}

