/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import java.util.HashMap;
import java.util.Map;
import kd.bos.metric.MetricSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.util.Pool;

public class PoolMetric {
    private static final Logger logger = LoggerFactory.getLogger(PoolMetric.class);
    private static Map<String, Pool> pools = new HashMap<String, Pool>();

    public static synchronized void setPool(Pool p, String url, int maxTotal) {
        PoolMetric.setPool(p, url, maxTotal, "redis");
    }

    public static synchronized void setPool(Pool p, String url, int maxTotal, String module) {
        if (pools.put(url, p) == null) {
            try {
                int i = url.indexOf(47);
                String name = i == -1 ? url : url.substring(0, i);
                MetricSystem.registerGauge((String)PoolMetric.getMetricName(module, "numActive", name), () -> p == null ? 0 : p.getNumActive());
                MetricSystem.registerGauge((String)PoolMetric.getMetricName(module, "numIdle", name), () -> p == null ? 0 : p.getNumIdle());
                MetricSystem.registerGauge((String)PoolMetric.getMetricName(module, "max", name), () -> maxTotal);
            }
            catch (Exception e) {
                logger.error("setPool exception", (Throwable)e);
            }
        }
    }

    private static String getMetricName(String subSystem, String metric, String name) {
        return String.format("%s.%s.pool.%s.%s", "kd.metrics", subSystem, metric, name);
    }
}

