/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.pool.builder.bean.HostAndPort;
import kd.bos.redis.pool.builder.bean.RedisInfo;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisInfoParser {
    private static final Logger logger = LoggerFactory.getLogger(RedisInfoParser.class);
    private static final String PASS = "password";

    public static RedisInfo parseUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            throw new NullPointerException("redis url can not be null!");
        }
        url = RedisInfoParser.dropTypePrefix(url);
        url = RedisInfoParser.dropSSLPrefix(url);
        RedisInfo redisInfo = new RedisInfo();
        int index = url.indexOf(47);
        String[] parts = null;
        parts = index != -1 ? new String[]{url.substring(0, index), url.substring(index + 1)} : new String[]{url};
        if (parts.length == 2) {
            String part1 = parts[1];
            if (part1.startsWith("?") && part1.contains("=")) {
                part1 = part1.substring(1);
                Properties e = RedisInfoParser.parseParm(part1);
                redisInfo.setProperties(e);
                if (e != null && StringUtils.isNotEmpty((String)e.getProperty(PASS))) {
                    redisInfo.setPassword(Encrypters.decode((String)e.getProperty(PASS)));
                }
            } else {
                String password = parts[1];
                redisInfo.setPassword(Encrypters.decode((String)password));
            }
        }
        String server = parts[0];
        redisInfo.setHostAndPorts(RedisInfoParser.parseServer(server));
        return redisInfo;
    }

    private static String dropTypePrefix(String url) {
        String poolUrl = url.toLowerCase(Locale.ENGLISH).startsWith("redis:") ? url.substring("redis:".length()) : (url.toLowerCase(Locale.ENGLISH).startsWith("shard:") ? url.substring("shard:".length()) : (url.toLowerCase(Locale.ENGLISH).startsWith("sentinel:") ? url.substring("sentinel:".length()) : (url.toLowerCase(Locale.ENGLISH).startsWith("cluster:") ? url.substring("cluster:".length()) : url)));
        return poolUrl;
    }

    private static String dropSSLPrefix(String poolUrl) {
        boolean ssl = poolUrl.toLowerCase(Locale.ENGLISH).startsWith("ssl:");
        poolUrl = ssl ? poolUrl.substring(4) : poolUrl;
        return poolUrl;
    }

    private static Properties parseParm(String part1) {
        String[] params = null;
        params = part1.contains("&") ? part1.split("&") : new String[]{part1};
        Properties prop = new Properties();
        for (String p : params) {
            if (!p.contains("=")) continue;
            int index = p.indexOf("=");
            String key = p.substring(0, index);
            String value = p.substring(index + 1);
            prop.put(key, value);
        }
        return prop;
    }

    private static Set<HostAndPort> parseServer(String server) {
        HashSet<HostAndPort> hostAndPorts = new HashSet<HostAndPort>();
        String[] parts = server.split(";|,");
        try {
            for (int i = 0; i < parts.length; ++i) {
                String host = parts[i].trim();
                String[] hap = RedisInfoParser.parseIpPort(host);
                if (hap.length != 2) {
                    logger.error("wrong redis config:" + host);
                    continue;
                }
                hostAndPorts.add(new HostAndPort(hap[0], Integer.parseInt(hap[1].trim())));
            }
            return hostAndPorts;
        }
        catch (Exception t) {
            logger.error("error parse redis server:" + server, (Throwable)t);
            throw new KDException((Throwable)t, BosErrorCode.configRedisConfig, new Object[]{"error parse redis server:" + server});
        }
    }

    private static String[] parseIpPort(String address) {
        String[] arg = new String[2];
        int v6i = address.lastIndexOf("]");
        if (address.startsWith("[") && v6i > 0) {
            String ipv6Url = address;
            arg[0] = ipv6Url.substring(1, address.lastIndexOf("]"));
            arg[1] = ipv6Url.substring(v6i + 2);
        } else {
            arg = address.split(":");
        }
        return arg;
    }
}

