/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.redis.pool.JedisPool0;
import kd.bos.redis.pool.JedisPoolConfigGeneral;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0Builder;
import kd.bos.redis.pool.builder.AbstractPoolBuilder;
import kd.bos.redis.pool.builder.PoolMetric;
import kd.bos.redis.pool.builder.RedisInfoParser;
import kd.bos.redis.pool.builder.bean.HostAndPort;
import kd.bos.redis.pool.builder.bean.RedisInfo;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.util.Pool;

public class ShardBuilder
extends AbstractPoolBuilder<ShardedJedis>
implements Pool0Builder<ShardedJedis> {
    private static final Logger logger = LoggerFactory.getLogger(ShardBuilder.class);

    @Override
    public Pool0<ShardedJedis> build(String url, boolean ssl) {
        RedisInfo redisInfo = RedisInfoParser.parseUrl(url);
        List<JedisShardInfo> infos = this.parseServer(redisInfo.getHostAndPorts(), redisInfo.getPassword(), ssl);
        GenericObjectPoolConfig config = new JedisPoolConfigGeneral().getGenericObjectPoolConfig();
        ShardedJedisPool pool = new ShardedJedisPool(config, infos);
        String metricUrl = url.replaceAll(":", "-");
        PoolMetric.setPool((Pool)pool, metricUrl, config.getMaxTotal());
        return new JedisPool0<ShardedJedis>((Pool<ShardedJedis>)pool);
    }

    private List<JedisShardInfo> parseServer(Set<HostAndPort> hostAndPorts, String password, boolean ssl) {
        ArrayList<JedisShardInfo> list = new ArrayList<JedisShardInfo>();
        hostAndPorts.forEach(hostAndPort -> {
            JedisShardInfo info = new JedisShardInfo(hostAndPort.getHost(), hostAndPort.getPort(), ssl);
            info.setPassword(password);
            info.setConnectionTimeout(this.connectionTimeout());
            info.setSoTimeout(this.soTimeout());
            list.add(info);
        });
        return list;
    }
}

