/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.builder;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kd.bos.redis.pool.JedisPool0;
import kd.bos.redis.pool.JedisPoolConfigGeneral;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0Builder;
import kd.bos.redis.pool.builder.AbstractPoolBuilder;
import kd.bos.redis.pool.builder.PoolMetric;
import kd.bos.redis.pool.builder.RedisInfoParser;
import kd.bos.redis.pool.builder.bean.HostAndPort;
import kd.bos.redis.pool.builder.bean.RedisInfo;
import kd.bos.util.FileUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

public class StandaloneBuilder
extends AbstractPoolBuilder<Jedis>
implements Pool0Builder<Jedis> {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneBuilder.class);

    @Override
    public Pool0<Jedis> build(String url, boolean ssl) {
        SSLSocketFactory sslSocketFactory;
        RedisInfo redisInfo = RedisInfoParser.parseUrl(url);
        String host = null;
        int port = 6379;
        Iterator<HostAndPort> it = redisInfo.getHostAndPorts().iterator();
        if (it.hasNext()) {
            HostAndPort hostAndPort = it.next();
            host = hostAndPort.getHost();
            port = hostAndPort.getPort();
        }
        String password = redisInfo.getPassword();
        JedisPoolConfig config = new JedisPoolConfigGeneral().getPoolConfig();
        try {
            sslSocketFactory = ssl ? StandaloneBuilder.createTrustStoreSslSocketFactory() : null;
        }
        catch (Exception e) {
            sslSocketFactory = null;
            logger.warn("redis {}  not use ssl cert ,only on ssl", (Object)url, (Object)e);
        }
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, host, port, this.connectionTimeout(), this.soTimeout(), password, 0, null, ssl, sslSocketFactory, null, null);
        String metricUrl = url.replaceAll(":", "-");
        PoolMetric.setPool((Pool)pool, metricUrl, config.getMaxTotal());
        return new JedisPool0<Jedis>((Pool<Jedis>)pool);
    }

    private static SSLSocketFactory createTrustStoreSslSocketFactory() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        String trustStorePath = FileUtils.checkFileUrl((String)System.getProperty("redis.serversForCache.ssl.trustStore"));
        String trustStoreType = FileUtils.checkFileUrl((String)System.getProperty("redis.serversForCache.ssl.trustStoreType"));
        KeyStore trustStore = KeyStore.getInstance(trustStoreType);
        try (FileInputStream inputStream = new FileInputStream(trustStorePath);){
            trustStore.load(inputStream, null);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, trustManagers, new SecureRandom());
        return sslContext.getSocketFactory();
    }
}

