/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.pool.router;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.pool.router.Dispatcher;

public class HashDispatcher
implements Dispatcher {
    private List<String> realNodes;

    public HashDispatcher(List<String> realNodes) {
        if (realNodes == null || realNodes.isEmpty()) {
            throw new KDException(BosErrorCode.jedisException, new Object[]{"HashDispatcher init error: The server list can not be empty"});
        }
        this.realNodes = Collections.unmodifiableList(realNodes);
    }

    @Override
    public String getNode(byte[] key) {
        int hashKey = Arrays.hashCode(key);
        if (hashKey < 0) {
            hashKey = Math.abs(hashKey);
        }
        int index = hashKey % this.realNodes.size();
        return this.realNodes.get(index);
    }

    @Override
    public List<String> getRealNodes() {
        return this.realNodes;
    }
}

