/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.wrapper;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import kd.bos.redis.JedisClient;

public class CloseableJedisClientManager {
    private static final String JEDISCLIENT_CLOSEABLE = "jedisclient.closeable";
    private static ThreadLocal<CloseableJedisClients> local = new ThreadLocal<CloseableJedisClients>(){

        @Override
        protected CloseableJedisClients initialValue() {
            return new CloseableJedisClients();
        }
    };

    protected static void put(JedisClient jedisClient) {
        if (CloseableJedisClientManager.isCloseable()) {
            local.get().put(jedisClient);
        }
    }

    protected static void remove(JedisClient jedisClient) {
        if (CloseableJedisClientManager.isCloseable()) {
            local.get().remove(jedisClient);
        }
    }

    private static boolean isCloseable() {
        return "true".equals(System.getProperty(JEDISCLIENT_CLOSEABLE, "true"));
    }

    private static class CloseableJedisClients
    implements Closeable {
        private Set<JedisClient> jedisClients = new HashSet<JedisClient>();

        private CloseableJedisClients() {
        }

        @Override
        public void close() throws IOException {
            for (JedisClient jedisClient : this.jedisClients) {
                if (jedisClient == null) continue;
                jedisClient.close();
            }
        }

        public void put(JedisClient jedisClient) {
            this.jedisClients.add(jedisClient);
        }

        public void remove(JedisClient jedisClient) {
            this.jedisClients.remove(jedisClient);
        }
    }
}

