/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.redis.pool.router.Dispatcher;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.StreamPendingSummary;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.StrAlgoLCSParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.util.SafeEncoder;
import redis.clients.jedis.util.Slowlog;

public class MultiJedisClient
implements JedisClient {
    private Dispatcher dispatcher;

    public MultiJedisClient(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    private void checkNullKey(Object key) {
        if (key == null) {
            throw new KDException(BosErrorCode.jedisException, new Object[]{"MultiJedisClient route error: The key can not be null"});
        }
    }

    private JedisClient route(String key) {
        this.checkNullKey(key);
        String node = this.dispatcher.getNode(SafeEncoder.encode((String)key));
        return RedisFactory.getJedisClient(node);
    }

    private JedisClient route(byte[] key) {
        this.checkNullKey(key);
        String node = this.dispatcher.getNode(key);
        return RedisFactory.getJedisClient(node);
    }

    @Override
    public Set<String> keys(String pattern) {
        List<String> nodes = this.dispatcher.getRealNodes();
        HashSet<String> set = new HashSet<String>();
        for (String node : nodes) {
            JedisClient jedisClient = RedisFactory.getJedisClient(node);
            Throwable throwable = null;
            try {
                set.addAll(jedisClient.keys(pattern));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jedisClient == null) continue;
                if (throwable != null) {
                    try {
                        jedisClient.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jedisClient.close();
            }
        }
        return set;
    }

    public String routeNode(String key) {
        this.checkNullKey(key);
        return this.dispatcher.getNode(SafeEncoder.encode((String)key));
    }

    public Map<String, JedisClient> getAllJedisClient() {
        List<String> nodes = this.dispatcher.getRealNodes();
        HashMap<String, JedisClient> map = new HashMap<String, JedisClient>(nodes.size());
        for (String node : nodes) {
            map.put(node, RedisFactory.getJedisClient(node));
        }
        return map;
    }

    @Override
    public void close() {
    }

    @Override
    public void select(int db) {
        throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
    }

    @Override
    public List<Map> getRedisInfo() {
        ArrayList<Map> infoList = new ArrayList<Map>();
        List<String> realNodes = this.dispatcher.getRealNodes();
        for (String node : realNodes) {
            JedisClient client = RedisFactory.getJedisClient(node);
            Throwable throwable = null;
            try {
                infoList.addAll(client.getRedisInfo());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
            }
        }
        return infoList;
    }

    @Override
    public List<Slowlog> getLogs(long entries) {
        ArrayList<Slowlog> slowLogs = new ArrayList<Slowlog>();
        List<String> realNodes = this.dispatcher.getRealNodes();
        for (String node : realNodes) {
            JedisClient client = RedisFactory.getJedisClient(node);
            Throwable throwable = null;
            try {
                slowLogs.addAll(client.getLogs(entries));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
            }
        }
        return slowLogs;
    }

    @Override
    public Long dbSize() {
        Long ret = 0L;
        List<String> realNodes = this.dispatcher.getRealNodes();
        for (String node : realNodes) {
            JedisClient client = RedisFactory.getJedisClient(node);
            Throwable throwable = null;
            try {
                ret = ret + client.dbSize();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
            }
        }
        return ret;
    }

    @Override
    public Object eval(String script, String key, List<String> args) {
        try (JedisClient jedisClient = this.route(key);){
            Object object = jedisClient.eval(script, key, args);
            return object;
        }
    }

    @Override
    public Object eval(String script, int keyCount, String ... params) {
        if (params != null && params.length != 0) {
            String node = this.dispatcher.getNode(SafeEncoder.encode((String)params[0]));
            if (params.length > 1) {
                for (int i = 1; i < keyCount; ++i) {
                    String nextNode = this.dispatcher.getNode(SafeEncoder.encode((String)params[i]));
                    if (node.equals(nextNode)) continue;
                    throw new KDException(BosErrorCode.jedisException, new Object[]{"No way to dispatch this command to Multi Redis Cluster because keys have different slots."});
                }
            }
            try (JedisClient jedisClient = this.route(script);){
                Object object = jedisClient.eval(script, keyCount, params);
                return object;
            }
        }
        throw new KDException(BosErrorCode.jedisException, new Object[]{"No way to dispatch this command to Multi Redis Cluster."});
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.linsert(key, where, pivot, value);
            return l;
        }
    }

    @Override
    public String set(String key, String value, String nxxx, String expx, long time) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.set(key, value, nxxx, expx, time);
            return string;
        }
    }

    @Override
    public String set(String key, String value, String nxxx) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.set(key, value, nxxx);
            return string;
        }
    }

    @Override
    public List<String> blpop(String key) {
        try (JedisClient jedisClient = this.route(key);){
            List<String> list = jedisClient.blpop(key);
            return list;
        }
    }

    @Override
    public List<String> brpop(String key) {
        try (JedisClient jedisClient = this.route(key);){
            List<String> list = jedisClient.brpop(key);
            return list;
        }
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult<Map.Entry<String, String>> scanResult = jedisClient.hscan(key, cursor);
            return scanResult;
        }
    }

    @Override
    public ScanResult<String> sscan(String key, int cursor) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult<String> scanResult = jedisClient.sscan(key, cursor);
            return scanResult;
        }
    }

    @Override
    public ScanResult<Tuple> zscan(String key, int cursor) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult<Tuple> scanResult = jedisClient.zscan(key, cursor);
            return scanResult;
        }
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.linsert(key, where, pivot, value);
            return l;
        }
    }

    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.set(key, value, nxxx, expx, time);
            return string;
        }
    }

    @Override
    public String set(byte[] var1, byte[] var2, byte[] var3) {
        try (JedisClient jedisClient = this.route(var1);){
            String string = jedisClient.set(var1, var2, var3);
            return string;
        }
    }

    @Override
    public List<byte[]> blpop(byte[] var1) {
        try (JedisClient jedisClient = this.route(var1);){
            List<byte[]> list = jedisClient.blpop(var1);
            return list;
        }
    }

    @Override
    public List<byte[]> brpop(byte[] var1) {
        try (JedisClient jedisClient = this.route(var1);){
            List<byte[]> list = jedisClient.brpop(var1);
            return list;
        }
    }

    public String set(byte[] key, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.set(key, value);
            return string;
        }
    }

    public String set(byte[] key, byte[] value, SetParams setParams) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.set(key, value, setParams);
            return string;
        }
    }

    public byte[] get(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.get(key);
            return byArray;
        }
    }

    public byte[] getDel(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            byte[] byArray = jedisClient.getDel(bytes);
            return byArray;
        }
    }

    public byte[] getEx(byte[] bytes, GetExParams getExParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            byte[] byArray = jedisClient.getEx(bytes, getExParams);
            return byArray;
        }
    }

    public Boolean exists(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.exists(key);
            return bl;
        }
    }

    public Long persist(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.persist(key);
            return l;
        }
    }

    public String type(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.type(key);
            return string;
        }
    }

    public byte[] dump(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.dump(key);
            return byArray;
        }
    }

    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.restore(key, ttl, serializedValue);
            return string;
        }
    }

    public String restore(byte[] bytes, long l, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            String string = jedisClient.restore(bytes, l, bytes1);
            return string;
        }
    }

    public String restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.restoreReplace(key, ttl, serializedValue);
            return string;
        }
    }

    public String restoreReplace(byte[] bytes, long l, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            String string = jedisClient.restoreReplace(bytes, l, bytes1);
            return string;
        }
    }

    public String restore(byte[] bytes, long l, byte[] bytes1, RestoreParams restoreParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            String string = jedisClient.restore(bytes, l, bytes1, restoreParams);
            return string;
        }
    }

    public Long expire(byte[] key, int seconds) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.expire(key, seconds);
            return l;
        }
    }

    public Long expire(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l2 = jedisClient.expire(bytes, l);
            return l2;
        }
    }

    public Long pexpire(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l2 = jedisClient.pexpire(bytes, l);
            return l2;
        }
    }

    public Long expireAt(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l2 = jedisClient.expireAt(bytes, l);
            return l2;
        }
    }

    public Long pexpireAt(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l2 = jedisClient.pexpireAt(bytes, l);
            return l2;
        }
    }

    public Long ttl(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.ttl(key);
            return l;
        }
    }

    public Long pttl(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.pttl(bytes);
            return l;
        }
    }

    public Long touch(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.touch(bytes);
            return l;
        }
    }

    public Boolean setbit(byte[] bytes, long l, boolean b) {
        try (JedisClient jedisClient = this.route(bytes);){
            Boolean bl = jedisClient.setbit(bytes, l, b);
            return bl;
        }
    }

    public Boolean setbit(byte[] bytes, long l, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            Boolean bl = jedisClient.setbit(bytes, l, bytes1);
            return bl;
        }
    }

    public Boolean getbit(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Boolean bl = jedisClient.getbit(bytes, l);
            return bl;
        }
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.setrange(key, offset, value);
            return l;
        }
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.getrange(key, startOffset, endOffset);
            return byArray;
        }
    }

    public byte[] getSet(byte[] key, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.getSet(key, value);
            return byArray;
        }
    }

    public Long setnx(byte[] key, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.setnx(key, value);
            return l;
        }
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.setex(key, seconds, value);
            return string;
        }
    }

    public String setex(byte[] bytes, long l, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            String string = jedisClient.setex(bytes, l, bytes1);
            return string;
        }
    }

    public String psetex(byte[] bytes, long l, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            String string = jedisClient.psetex(bytes, l, bytes1);
            return string;
        }
    }

    public Long decrBy(byte[] key, long integer) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.decrBy(key, integer);
            return l;
        }
    }

    public Long decr(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.decr(key);
            return l;
        }
    }

    public Long incrBy(byte[] key, long integer) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.incrBy(key, integer);
            return l;
        }
    }

    public Double incrByFloat(byte[] key, double value) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.incrByFloat(key, value);
            return d;
        }
    }

    public Long incr(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.incr(key);
            return l;
        }
    }

    public Long append(byte[] key, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.append(key, value);
            return l;
        }
    }

    public byte[] substr(byte[] key, int start, int end) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.substr(key, start, end);
            return byArray;
        }
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hset(key, field, value);
            return l;
        }
    }

    public Long hset(byte[] bytes, Map<byte[], byte[]> map) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.hset(bytes, map);
            return l;
        }
    }

    public byte[] hget(byte[] key, byte[] field) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.hget(key, field);
            return byArray;
        }
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hsetnx(key, field, value);
            return l;
        }
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.hmset(key, hash);
            return string;
        }
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.hmget(key, fields);
            return list;
        }
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hincrBy(key, field, value);
            return l;
        }
    }

    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.hincrByFloat(key, field, value);
            return d;
        }
    }

    public Boolean hexists(byte[] key, byte[] field) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.hexists(key, field);
            return bl;
        }
    }

    public Long hdel(byte[] key, byte[] ... field) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hdel(key, field);
            return l;
        }
    }

    public Long hlen(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hlen(key);
            return l;
        }
    }

    public Set<byte[]> hkeys(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.hkeys(key);
            return set;
        }
    }

    public List<byte[]> hvals(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.hvals(key);
            return list;
        }
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Map map = jedisClient.hgetAll(key);
            return map;
        }
    }

    public byte[] hrandfield(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.hrandfield(key);
            return byArray;
        }
    }

    public List<byte[]> hrandfield(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.hrandfield(bytes, l);
            return list;
        }
    }

    public Map<byte[], byte[]> hrandfieldWithValues(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Map map = jedisClient.hrandfieldWithValues(bytes, l);
            return map;
        }
    }

    public Long rpush(byte[] key, byte[] ... args) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.rpush(key, args);
            return l;
        }
    }

    public Long lpush(byte[] key, byte[] ... args) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.lpush(key, args);
            return l;
        }
    }

    public Long llen(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.llen(key);
            return l;
        }
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.lrange(key, start, end);
            return list;
        }
    }

    public String ltrim(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.ltrim(key, start, end);
            return string;
        }
    }

    public byte[] lindex(byte[] key, long index) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.lindex(key, index);
            return byArray;
        }
    }

    public String lset(byte[] key, long index, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.lset(key, index, value);
            return string;
        }
    }

    public Long lrem(byte[] key, long count, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.lrem(key, count, value);
            return l;
        }
    }

    public byte[] lpop(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.lpop(key);
            return byArray;
        }
    }

    public List<byte[]> lpop(byte[] key, int i) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.lpop(key, i);
            return list;
        }
    }

    public Long lpos(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.lpos(bytes, bytes1);
            return l;
        }
    }

    public Long lpos(byte[] bytes, byte[] bytes1, LPosParams lPosParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.lpos(bytes, bytes1, lPosParams);
            return l;
        }
    }

    public List<Long> lpos(byte[] bytes, byte[] bytes1, LPosParams lPosParams, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.lpos(bytes, bytes1, lPosParams, l);
            return list;
        }
    }

    public byte[] rpop(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.rpop(key);
            return byArray;
        }
    }

    public List<byte[]> rpop(byte[] bytes, int i) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.rpop(bytes, i);
            return list;
        }
    }

    public Long sadd(byte[] key, byte[] ... member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.sadd(key, member);
            return l;
        }
    }

    public Set<byte[]> smembers(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.smembers(key);
            return set;
        }
    }

    public Long srem(byte[] key, byte[] ... member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.srem(key, member);
            return l;
        }
    }

    public byte[] spop(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.spop(key);
            return byArray;
        }
    }

    public Set<byte[]> spop(byte[] key, long count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.spop(key, count);
            return set;
        }
    }

    public Long scard(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.scard(key);
            return l;
        }
    }

    public Boolean sismember(byte[] key, byte[] member) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.sismember(key, member);
            return bl;
        }
    }

    public List<Boolean> smismember(byte[] bytes, byte[] ... bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.smismember(bytes, bytes1);
            return list;
        }
    }

    public byte[] srandmember(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.srandmember(key);
            return byArray;
        }
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.srandmember(key, count);
            return list;
        }
    }

    public Long strlen(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.strlen(key);
            return l;
        }
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zadd(key, score, member);
            return l;
        }
    }

    public Long zadd(byte[] bytes, double v, byte[] bytes1, ZAddParams zAddParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.zadd(bytes, v, bytes1, zAddParams);
            return l;
        }
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zadd(key, scoreMembers);
            return l;
        }
    }

    public Long zadd(byte[] key, Map<byte[], Double> map, ZAddParams zAddParams) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zadd(key, map, zAddParams);
            return l;
        }
    }

    public Double zaddIncr(byte[] bytes, double v, byte[] bytes1, ZAddParams zAddParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            Double d = jedisClient.zaddIncr(bytes, v, bytes1, zAddParams);
            return d;
        }
    }

    public Set<byte[]> zrange(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrange(key, start, end);
            return set;
        }
    }

    public Long zrem(byte[] key, byte[] ... member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zrem(key, member);
            return l;
        }
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.zincrby(key, score, member);
            return d;
        }
    }

    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams zIncrByParams) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.zincrby(key, score, member, zIncrByParams);
            return d;
        }
    }

    public Long zrank(byte[] key, byte[] member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zrank(key, member);
            return l;
        }
    }

    public Long zrevrank(byte[] key, byte[] member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zrevrank(key, member);
            return l;
        }
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrange(key, start, end);
            return set;
        }
    }

    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeWithScores(key, start, end);
            return set;
        }
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeWithScores(key, start, end);
            return set;
        }
    }

    public byte[] zrandmember(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.zrandmember(key);
            return byArray;
        }
    }

    public Set<byte[]> zrandmember(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Set set = jedisClient.zrandmember(bytes, l);
            return set;
        }
    }

    public Set<Tuple> zrandmemberWithScores(byte[] bytes, long l) {
        try (JedisClient jedisClient = this.route(bytes);){
            Set set = jedisClient.zrandmemberWithScores(bytes, l);
            return set;
        }
    }

    public Long zcard(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zcard(key);
            return l;
        }
    }

    public Double zscore(byte[] key, byte[] member) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.zscore(key, member);
            return d;
        }
    }

    public List<Double> zmscore(byte[] bytes, byte[] ... bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.zmscore(bytes, bytes1);
            return list;
        }
    }

    public Tuple zpopmax(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Tuple tuple = jedisClient.zpopmax(key);
            return tuple;
        }
    }

    public Set<Tuple> zpopmax(byte[] bytes, int i) {
        try (JedisClient jedisClient = this.route(bytes);){
            Set set = jedisClient.zpopmax(bytes, i);
            return set;
        }
    }

    public Tuple zpopmin(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Tuple tuple = jedisClient.zpopmin(key);
            return tuple;
        }
    }

    public Set<Tuple> zpopmin(byte[] bytes, int i) {
        try (JedisClient jedisClient = this.route(bytes);){
            Set set = jedisClient.zpopmin(bytes, i);
            return set;
        }
    }

    public List<byte[]> sort(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.sort(key);
            return list;
        }
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParams) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.sort(key, sortingParams);
            return list;
        }
    }

    public Long zcount(byte[] key, double min, double max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zcount(key, min, max);
            return l;
        }
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zcount(key, min, max);
            return l;
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max);
            return set;
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max);
            return set;
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, max, min);
            return set;
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScore(key, max, min);
            return set;
        }
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    public Long zremrangeByRank(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByRank(key, start, end);
            return l;
        }
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByScore(key, start, end);
            return l;
        }
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByScore(key, start, end);
            return l;
        }
    }

    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zlexcount(key, min, max);
            return l;
        }
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByLex(key, min, max);
            return set;
        }
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByLex(key, min, max, offset, count);
            return set;
        }
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByLex(key, max, min);
            return set;
        }
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
    }

    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByLex(key, min, max);
            return l;
        }
    }

    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.linsert(key, where, pivot, value);
            return l;
        }
    }

    public Long lpushx(byte[] key, byte[] ... arg) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.lpushx(key, arg);
            return l;
        }
    }

    public Long rpushx(byte[] key, byte[] ... arg) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.rpushx(key, arg);
            return l;
        }
    }

    public Long del(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.del(key);
            return l;
        }
    }

    public Long unlink(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.unlink(key);
            return l;
        }
    }

    public byte[] echo(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.echo(key);
            return byArray;
        }
    }

    public Long move(byte[] key, int dbIndex) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.move(key, dbIndex);
            return l;
        }
    }

    public Long bitcount(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.bitcount(key);
            return l;
        }
    }

    public Long bitcount(byte[] key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.bitcount(key, start, end);
            return l;
        }
    }

    public Long pfadd(byte[] key, byte[] ... elements) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.pfadd(key, elements);
            return l;
        }
    }

    public long pfcount(byte[] key) {
        try (JedisClient jedisClient = this.route(key);){
            long l = jedisClient.pfcount(key);
            return l;
        }
    }

    public Long geoadd(byte[] bytes, double v, double v1, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.geoadd(bytes, v, v1, bytes1);
            return l;
        }
    }

    public Long geoadd(byte[] bytes, Map<byte[], GeoCoordinate> map) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.geoadd(bytes, map);
            return l;
        }
    }

    public Long geoadd(byte[] bytes, GeoAddParams geoAddParams, Map<byte[], GeoCoordinate> map) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.geoadd(bytes, geoAddParams, map);
            return l;
        }
    }

    public Double geodist(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        try (JedisClient jedisClient = this.route(bytes);){
            Double d = jedisClient.geodist(bytes, bytes1, bytes2);
            return d;
        }
    }

    public Double geodist(byte[] bytes, byte[] bytes1, byte[] bytes2, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(bytes);){
            Double d = jedisClient.geodist(bytes, bytes1, bytes2, geoUnit);
            return d;
        }
    }

    public List<byte[]> geohash(byte[] bytes, byte[] ... bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.geohash(bytes, bytes1);
            return list;
        }
    }

    public List<GeoCoordinate> geopos(byte[] bytes, byte[] ... bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.geopos(bytes, bytes1);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadius(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadius(bytes, v, v1, v2, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadiusReadonly(bytes, v, v1, v2, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadius(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadius(bytes, v, v1, v2, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadiusReadonly(bytes, v, v1, v2, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadiusByMember(bytes, bytes1, v, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadiusByMemberReadonly(bytes, bytes1, v, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadiusByMember(bytes, bytes1, v, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.georadiusByMemberReadonly(bytes, bytes1, v, geoUnit);
            return list;
        }
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            ScanResult scanResult = jedisClient.hscan(bytes, bytes1);
            return scanResult;
        }
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] bytes, byte[] bytes1, ScanParams scanParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            ScanResult scanResult = jedisClient.hscan(bytes, bytes1, scanParams);
            return scanResult;
        }
    }

    public ScanResult<byte[]> sscan(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            ScanResult scanResult = jedisClient.sscan(bytes, bytes1);
            return scanResult;
        }
    }

    public ScanResult<byte[]> sscan(byte[] bytes, byte[] bytes1, ScanParams scanParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            ScanResult scanResult = jedisClient.sscan(bytes, bytes1, scanParams);
            return scanResult;
        }
    }

    public ScanResult<Tuple> zscan(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            ScanResult scanResult = jedisClient.zscan(bytes, bytes1);
            return scanResult;
        }
    }

    public ScanResult<Tuple> zscan(byte[] bytes, byte[] bytes1, ScanParams scanParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            ScanResult scanResult = jedisClient.zscan(bytes, bytes1, scanParams);
            return scanResult;
        }
    }

    public List<Long> bitfield(byte[] bytes, byte[] ... bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.bitfield(bytes, bytes1);
            return list;
        }
    }

    public List<Long> bitfieldReadonly(byte[] bytes, byte[] ... bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.bitfieldReadonly(bytes, bytes1);
            return list;
        }
    }

    public Long hstrlen(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.hstrlen(bytes, bytes1);
            return l;
        }
    }

    public byte[] xadd(byte[] bytes, byte[] bytes1, Map<byte[], byte[]> map, long l, boolean b) {
        try (JedisClient jedisClient = this.route(bytes);){
            byte[] byArray = jedisClient.xadd(bytes, bytes1, map, l, b);
            return byArray;
        }
    }

    public byte[] xadd(byte[] bytes, Map<byte[], byte[]> map, XAddParams xAddParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            byte[] byArray = jedisClient.xadd(bytes, map, xAddParams);
            return byArray;
        }
    }

    public Long xlen(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.xlen(bytes);
            return l;
        }
    }

    public List<byte[]> xrange(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xrange(bytes, bytes1, bytes2);
            return list;
        }
    }

    public List<byte[]> xrange(byte[] key, byte[] start, byte[] end, long count) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.xrange(key, start, end, count);
            return list;
        }
    }

    public List<byte[]> xrange(byte[] bytes, byte[] bytes1, byte[] bytes2, int i) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xrange(bytes, bytes1, bytes2, i);
            return list;
        }
    }

    public List<byte[]> xrevrange(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xrevrange(bytes, bytes1, bytes2);
            return list;
        }
    }

    public List<byte[]> xrevrange(byte[] bytes, byte[] bytes1, byte[] bytes2, int i) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xrevrange(bytes, bytes1, bytes2, i);
            return list;
        }
    }

    public Long xack(byte[] bytes, byte[] bytes1, byte[] ... bytes2) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.xack(bytes, bytes1, bytes2);
            return l;
        }
    }

    public String xgroupCreate(byte[] bytes, byte[] bytes1, byte[] bytes2, boolean b) {
        try (JedisClient jedisClient = this.route(bytes);){
            String string = jedisClient.xgroupCreate(bytes, bytes1, bytes2, b);
            return string;
        }
    }

    public String xgroupSetID(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        try (JedisClient jedisClient = this.route(bytes);){
            String string = jedisClient.xgroupSetID(bytes, bytes1, bytes2);
            return string;
        }
    }

    public Long xgroupDestroy(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.xgroupDestroy(bytes, bytes1);
            return l;
        }
    }

    public Long xgroupDelConsumer(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.xgroupDelConsumer(bytes, bytes1, bytes2);
            return l;
        }
    }

    public Long xdel(byte[] bytes, byte[] ... bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.xdel(bytes, bytes1);
            return l;
        }
    }

    public Long xtrim(byte[] bytes, long l, boolean b) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l2 = jedisClient.xtrim(bytes, l, b);
            return l2;
        }
    }

    public Long xtrim(byte[] bytes, XTrimParams xTrimParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            Long l = jedisClient.xtrim(bytes, xTrimParams);
            return l;
        }
    }

    public Object xpending(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            Object object = jedisClient.xpending(bytes, bytes1);
            return object;
        }
    }

    public List<Object> xpending(byte[] bytes, byte[] bytes1, byte[] bytes2, byte[] bytes3, int i, byte[] bytes4) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xpending(bytes, bytes1, bytes2, bytes3, i, bytes4);
            return list;
        }
    }

    public List<Object> xpending(byte[] bytes, byte[] bytes1, XPendingParams xPendingParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xpending(bytes, bytes1, xPendingParams);
            return list;
        }
    }

    public List<byte[]> xclaim(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, long l1, int i, boolean b, byte[] ... bytes3) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xclaim(bytes, bytes1, bytes2, l, l1, i, b, bytes3);
            return list;
        }
    }

    public List<byte[]> xclaim(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, XClaimParams xClaimParams, byte[] ... bytes3) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xclaim(bytes, bytes1, bytes2, l, xClaimParams, bytes3);
            return list;
        }
    }

    public List<byte[]> xclaimJustId(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, XClaimParams xClaimParams, byte[] ... bytes3) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xclaimJustId(bytes, bytes1, bytes2, l, xClaimParams, bytes3);
            return list;
        }
    }

    public List<Object> xautoclaim(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, byte[] bytes3, XAutoClaimParams xAutoClaimParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xautoclaim(bytes, bytes1, bytes2, l, bytes3, xAutoClaimParams);
            return list;
        }
    }

    public List<Object> xautoclaimJustId(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, byte[] bytes3, XAutoClaimParams xAutoClaimParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xautoclaimJustId(bytes, bytes1, bytes2, l, bytes3, xAutoClaimParams);
            return list;
        }
    }

    public StreamInfo xinfoStream(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            StreamInfo streamInfo = jedisClient.xinfoStream(bytes);
            return streamInfo;
        }
    }

    public Object xinfoStreamBinary(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            Object object = jedisClient.xinfoStreamBinary(bytes);
            return object;
        }
    }

    public List<StreamGroupInfo> xinfoGroup(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xinfoGroup(bytes);
            return list;
        }
    }

    public List<Object> xinfoGroupBinary(byte[] bytes) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xinfoGroupBinary(bytes);
            return list;
        }
    }

    public List<StreamConsumersInfo> xinfoConsumers(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xinfoConsumers(bytes, bytes1);
            return list;
        }
    }

    public List<Object> xinfoConsumersBinary(byte[] bytes, byte[] bytes1) {
        try (JedisClient jedisClient = this.route(bytes);){
            List list = jedisClient.xinfoConsumersBinary(bytes, bytes1);
            return list;
        }
    }

    public LCSMatchResult strAlgoLCSStrings(byte[] bytes, byte[] bytes1, StrAlgoLCSParams strAlgoLCSParams) {
        try (JedisClient jedisClient = this.route(bytes);){
            LCSMatchResult lCSMatchResult = jedisClient.strAlgoLCSStrings(bytes, bytes1, strAlgoLCSParams);
            return lCSMatchResult;
        }
    }

    public String set(String key, String value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.set(key, value);
            return string;
        }
    }

    public String set(String key, String value, SetParams setParams) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.set(key, value, setParams);
            return string;
        }
    }

    public String get(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.get(key);
            return string;
        }
    }

    public String getDel(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.getDel(key);
            return string;
        }
    }

    public String getEx(String key, GetExParams getExParams) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.getEx(key, getExParams);
            return string;
        }
    }

    public Boolean exists(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.exists(key);
            return bl;
        }
    }

    public Long persist(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.persist(key);
            return l;
        }
    }

    public String type(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.type(key);
            return string;
        }
    }

    public byte[] dump(String key) {
        try (JedisClient jedisClient = this.route(key);){
            byte[] byArray = jedisClient.dump(key);
            return byArray;
        }
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.restore(key, ttl, serializedValue);
            return string;
        }
    }

    public String restore(String key, long l, byte[] bytes) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.restore(key, l, bytes);
            return string;
        }
    }

    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.restoreReplace(key, ttl, serializedValue);
            return string;
        }
    }

    public String restoreReplace(String key, long l, byte[] bytes) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.restoreReplace(key, l, bytes);
            return string;
        }
    }

    public String restore(String key, long l, byte[] bytes, RestoreParams restoreParams) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.restore(key, l, bytes, restoreParams);
            return string;
        }
    }

    public Long expire(String key, int seconds) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.expire(key, seconds);
            return l;
        }
    }

    public Long expire(String key, long seconds) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.expire(key, seconds);
            return l;
        }
    }

    public Long pexpire(String key, long milliseconds) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.pexpire(key, milliseconds);
            return l;
        }
    }

    public Long expireAt(String key, long unixTime) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.expireAt(key, unixTime);
            return l;
        }
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
    }

    public Long ttl(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.ttl(key);
            return l;
        }
    }

    public Long pttl(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.pttl(key);
            return l;
        }
    }

    public Long touch(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.touch(key);
            return l;
        }
    }

    public Boolean setbit(String key, long offset, boolean value) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.setbit(key, offset, value);
            return bl;
        }
    }

    public Boolean setbit(String key, long offset, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.setbit(key, offset, value);
            return bl;
        }
    }

    public Boolean getbit(String key, long offset) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.getbit(key, offset);
            return bl;
        }
    }

    public Long setrange(String key, long offset, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.setrange(key, offset, value);
            return l;
        }
    }

    public String getrange(String key, long startOffset, long endOffset) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.getrange(key, startOffset, endOffset);
            return string;
        }
    }

    public String getSet(String key, String value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.getSet(key, value);
            return string;
        }
    }

    public Long setnx(String key, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.setnx(key, value);
            return l;
        }
    }

    public String setex(String key, int seconds, String value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.setex(key, seconds, value);
            return string;
        }
    }

    public String setex(String key, long seconds, String value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.setex(key, seconds, value);
            return string;
        }
    }

    public String psetex(String key, long seconds, String value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.psetex(key, seconds, value);
            return string;
        }
    }

    public Long decrBy(String key, long integer) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.decrBy(key, integer);
            return l;
        }
    }

    public Long decr(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.decr(key);
            return l;
        }
    }

    public Long incrBy(String key, long integer) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.incrBy(key, integer);
            return l;
        }
    }

    public Double incrByFloat(String key, double value) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.incrByFloat(key, value);
            return d;
        }
    }

    public Long incr(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.incr(key);
            return l;
        }
    }

    public Long append(String key, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.append(key, value);
            return l;
        }
    }

    public String substr(String key, int start, int end) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.substr(key, start, end);
            return string;
        }
    }

    public Long hset(String key, String field, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hset(key, field, value);
            return l;
        }
    }

    public Long hset(String key, Map<String, String> map) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hset(key, map);
            return l;
        }
    }

    public String hget(String key, String field) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.hget(key, field);
            return string;
        }
    }

    public Long hsetnx(String key, String field, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hsetnx(key, field, value);
            return l;
        }
    }

    public String hmset(String key, Map<String, String> hash) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.hmset(key, hash);
            return string;
        }
    }

    public List<String> hmget(String key, String ... fields) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.hmget(key, fields);
            return list;
        }
    }

    public Long hincrBy(String key, String field, long value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hincrBy(key, field, value);
            return l;
        }
    }

    public Double hincrByFloat(String key, String s1, double v) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.hincrByFloat(key, s1, v);
            return d;
        }
    }

    public Boolean hexists(String key, String field) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.hexists(key, field);
            return bl;
        }
    }

    public Long hdel(String key, String ... field) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hdel(key, field);
            return l;
        }
    }

    public Long hlen(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.hlen(key);
            return l;
        }
    }

    public Set<String> hkeys(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.hkeys(key);
            return set;
        }
    }

    public List<String> hvals(String key) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.hvals(key);
            return list;
        }
    }

    public Map<String, String> hgetAll(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Map map = jedisClient.hgetAll(key);
            return map;
        }
    }

    public String hrandfield(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.hrandfield(key);
            return string;
        }
    }

    public List<String> hrandfield(String key, long l) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.hrandfield(key, l);
            return list;
        }
    }

    public Map<String, String> hrandfieldWithValues(String key, long l) {
        try (JedisClient jedisClient = this.route(key);){
            Map map = jedisClient.hrandfieldWithValues(key, l);
            return map;
        }
    }

    public Long rpush(String key, String ... strings) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.rpush(key, strings);
            return l;
        }
    }

    public Long lpush(String key, String ... strings) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.lpush(key, strings);
            return l;
        }
    }

    public Long llen(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.llen(key);
            return l;
        }
    }

    public List<String> lrange(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.lrange(key, start, end);
            return list;
        }
    }

    public String ltrim(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.ltrim(key, start, end);
            return string;
        }
    }

    public String lindex(String key, long index) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.lindex(key, index);
            return string;
        }
    }

    public String lset(String key, long index, String value) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.lset(key, index, value);
            return string;
        }
    }

    public Long lrem(String key, long count, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.lrem(key, count, value);
            return l;
        }
    }

    public String lpop(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.lpop(key);
            return string;
        }
    }

    public List<String> lpop(String key, int i) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.lpop(key, i);
            return list;
        }
    }

    public Long lpos(String s, String s1) {
        try (JedisClient jedisClient = this.route(s);){
            Long l = jedisClient.lpos(s, s1);
            return l;
        }
    }

    public Long lpos(String s, String s1, LPosParams lPosParams) {
        try (JedisClient jedisClient = this.route(s);){
            Long l = jedisClient.lpos(s, s1, lPosParams);
            return l;
        }
    }

    public List<Long> lpos(String s, String s1, LPosParams lPosParams, long l) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.lpos(s, s1, lPosParams, l);
            return list;
        }
    }

    public String rpop(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.rpop(key);
            return string;
        }
    }

    public List<String> rpop(String key, int i) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.rpop(key, i);
            return list;
        }
    }

    public Long sadd(String key, String ... member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.sadd(key, member);
            return l;
        }
    }

    public Set<String> smembers(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.smembers(key);
            return set;
        }
    }

    public Long srem(String key, String ... member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.srem(key, member);
            return l;
        }
    }

    public String spop(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.spop(key);
            return string;
        }
    }

    public Set<String> spop(String key, long count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.spop(key, count);
            return set;
        }
    }

    public Long scard(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.scard(key);
            return l;
        }
    }

    public Boolean sismember(String key, String member) {
        try (JedisClient jedisClient = this.route(key);){
            Boolean bl = jedisClient.sismember(key, member);
            return bl;
        }
    }

    public List<Boolean> smismember(String key, String ... members) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.smismember(key, members);
            return list;
        }
    }

    public String srandmember(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.srandmember(key);
            return string;
        }
    }

    public List<String> srandmember(String key, int count) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.srandmember(key, count);
            return list;
        }
    }

    public Long strlen(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.strlen(key);
            return l;
        }
    }

    public Long zadd(String key, double score, String member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zadd(key, score, member);
            return l;
        }
    }

    public Long zadd(String key, double value, String member, ZAddParams zAddParams) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zadd(key, value, member, zAddParams);
            return l;
        }
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zadd(key, scoreMembers);
            return l;
        }
    }

    public Long zadd(String key, Map<String, Double> map, ZAddParams zAddParams) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zadd(key, map, zAddParams);
            return l;
        }
    }

    public Double zaddIncr(String key, double v, String s1, ZAddParams zAddParams) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.zaddIncr(key, v, s1, zAddParams);
            return d;
        }
    }

    public Set<String> zrange(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrange(key, start, end);
            return set;
        }
    }

    public Long zrem(String key, String ... member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zrem(key, member);
            return l;
        }
    }

    public Double zincrby(String key, double score, String member) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.zincrby(key, score, member);
            return d;
        }
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams zIncrByParams) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.zincrby(key, score, member, zIncrByParams);
            return d;
        }
    }

    public Long zrank(String key, String member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zrank(key, member);
            return l;
        }
    }

    public Long zrevrank(String key, String member) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zrevrank(key, member);
            return l;
        }
    }

    public Set<String> zrevrange(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrange(key, start, end);
            return set;
        }
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeWithScores(key, start, end);
            return set;
        }
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeWithScores(key, start, end);
            return set;
        }
    }

    public String zrandmember(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.zrandmember(key);
            return string;
        }
    }

    public Set<String> zrandmember(String key, long index) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrandmember(key, index);
            return set;
        }
    }

    public Set<Tuple> zrandmemberWithScores(String key, long index) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrandmemberWithScores(key, index);
            return set;
        }
    }

    public Long zcard(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zcard(key);
            return l;
        }
    }

    public Double zscore(String key, String member) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.zscore(key, member);
            return d;
        }
    }

    public List<Double> zmscore(String key, String ... strings) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.zmscore(key, strings);
            return list;
        }
    }

    public Tuple zpopmax(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Tuple tuple = jedisClient.zpopmax(key);
            return tuple;
        }
    }

    public Set<Tuple> zpopmax(String key, int i) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zpopmax(key, i);
            return set;
        }
    }

    public Tuple zpopmin(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Tuple tuple = jedisClient.zpopmin(key);
            return tuple;
        }
    }

    public Set<Tuple> zpopmin(String key, int i) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zpopmin(key, i);
            return set;
        }
    }

    public List<String> sort(String key) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.sort(key);
            return list;
        }
    }

    public List<String> sort(String key, SortingParams sortingParams) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.sort(key, sortingParams);
            return list;
        }
    }

    public Long zcount(String key, double min, double max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zcount(key, min, max);
            return l;
        }
    }

    public Long zcount(String key, String min, String max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zcount(key, min, max);
            return l;
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max);
            return set;
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max);
            return set;
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScore(key, max, min);
            return set;
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    public Long zremrangeByRank(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByRank(key, start, end);
            return l;
        }
    }

    public Long zremrangeByScore(String key, double start, double end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByScore(key, start, end);
            return l;
        }
    }

    public Long zremrangeByScore(String key, String start, String end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByScore(key, start, end);
            return l;
        }
    }

    public Long zlexcount(String key, String min, String max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zlexcount(key, min, max);
            return l;
        }
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByLex(key, min, max);
            return set;
        }
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrangeByLex(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByLex(key, max, min);
            return set;
        }
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        try (JedisClient jedisClient = this.route(key);){
            Set set = jedisClient.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
    }

    public Long zremrangeByLex(String key, String min, String max) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.zremrangeByLex(key, min, max);
            return l;
        }
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.linsert(key, where, pivot, value);
            return l;
        }
    }

    public Long lpushx(String key, String ... string) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.lpushx(key, string);
            return l;
        }
    }

    public Long rpushx(String key, String ... string) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.rpushx(key, string);
            return l;
        }
    }

    public List<String> blpop(int timeout, String key) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.blpop(timeout, key);
            return list;
        }
    }

    public KeyedListElement blpop(double v, String key) {
        try (JedisClient jedisClient = this.route(key);){
            KeyedListElement keyedListElement = jedisClient.blpop(v, key);
            return keyedListElement;
        }
    }

    public List<String> brpop(int timeout, String key) {
        try (JedisClient jedisClient = this.route(key);){
            List list = jedisClient.brpop(timeout, key);
            return list;
        }
    }

    public KeyedListElement brpop(double v, String key) {
        try (JedisClient jedisClient = this.route(key);){
            KeyedListElement keyedListElement = jedisClient.brpop(v, key);
            return keyedListElement;
        }
    }

    public Long del(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.del(key);
            return l;
        }
    }

    public Long unlink(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.unlink(key);
            return l;
        }
    }

    public String echo(String key) {
        try (JedisClient jedisClient = this.route(key);){
            String string = jedisClient.echo(key);
            return string;
        }
    }

    public Long move(String key, int dbIndex) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.move(key, dbIndex);
            return l;
        }
    }

    public Long bitcount(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.bitcount(key);
            return l;
        }
    }

    public Long bitcount(String key, long start, long end) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.bitcount(key, start, end);
            return l;
        }
    }

    public Long bitpos(String key, boolean b) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.bitpos(key, b);
            return l;
        }
    }

    public Long bitpos(String key, boolean b, BitPosParams bitPosParams) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.bitpos(key, b, bitPosParams);
            return l;
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String value) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult scanResult = jedisClient.hscan(key, value);
            return scanResult;
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String value, ScanParams scanParams) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult scanResult = jedisClient.hscan(key, value, scanParams);
            return scanResult;
        }
    }

    public ScanResult<String> sscan(String key, String cursor) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult scanResult = jedisClient.sscan(key, cursor);
            return scanResult;
        }
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult scanResult = jedisClient.zscan(key, cursor);
            return scanResult;
        }
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams scanParams) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult scanResult = jedisClient.zscan(key, cursor, scanParams);
            return scanResult;
        }
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams scanParams) {
        try (JedisClient jedisClient = this.route(key);){
            ScanResult scanResult = jedisClient.sscan(key, cursor, scanParams);
            return scanResult;
        }
    }

    public Long pfadd(String key, String ... elements) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.pfadd(key, elements);
            return l;
        }
    }

    public long pfcount(String key) {
        try (JedisClient jedisClient = this.route(key);){
            long l = jedisClient.pfcount(key);
            return l;
        }
    }

    public Long geoadd(String key, double v, double v1, String s1) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.geoadd(key, v, v1, s1);
            return l;
        }
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> map) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.geoadd(key, map);
            return l;
        }
    }

    public Long geoadd(String key, GeoAddParams geoAddParams, Map<String, GeoCoordinate> map) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.geoadd(key, geoAddParams, map);
            return l;
        }
    }

    public Double geodist(String key, String s1, String s2) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.geodist(key, s1, s2);
            return d;
        }
    }

    public Double geodist(String key, String s1, String s2, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(key);){
            Double d = jedisClient.geodist(key, s1, s2, geoUnit);
            return d;
        }
    }

    public List<String> geohash(String s, String ... strings) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.geohash(s, strings);
            return list;
        }
    }

    public List<GeoCoordinate> geopos(String s, String ... strings) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.geopos(s, strings);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadius(String s, double v, double v1, double v2, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadius(s, v, v1, v2, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusReadonly(String s, double v, double v1, double v2, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadiusReadonly(s, v, v1, v2, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadius(String s, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadius(s, v, v1, v2, geoUnit, geoRadiusParam);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusReadonly(String s, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadiusReadonly(s, v, v1, v2, geoUnit, geoRadiusParam);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(String s, String s1, double v, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadiusByMember(s, s1, v, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String s, String s1, double v, GeoUnit geoUnit) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadiusByMemberReadonly(s, s1, v, geoUnit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(String s, String s1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadiusByMember(s, s1, v, geoUnit, geoRadiusParam);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String s, String s1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.georadiusByMemberReadonly(s, s1, v, geoUnit, geoRadiusParam);
            return list;
        }
    }

    public List<Long> bitfield(String s, String ... strings) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.bitfield(s, strings);
            return list;
        }
    }

    public List<Long> bitfieldReadonly(String s, String ... strings) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.bitfieldReadonly(s, strings);
            return list;
        }
    }

    public Long hstrlen(String s, String s1) {
        try (JedisClient jedisClient = this.route(s);){
            Long l = jedisClient.hstrlen(s, s1);
            return l;
        }
    }

    public StreamEntryID xadd(String s, StreamEntryID streamEntryID, Map<String, String> map) {
        try (JedisClient jedisClient = this.route(s);){
            StreamEntryID streamEntryID2 = jedisClient.xadd(s, streamEntryID, map);
            return streamEntryID2;
        }
    }

    public StreamEntryID xadd(String s, StreamEntryID streamEntryID, Map<String, String> map, long l, boolean b) {
        try (JedisClient jedisClient = this.route(s);){
            StreamEntryID streamEntryID2 = jedisClient.xadd(s, streamEntryID, map, l, b);
            return streamEntryID2;
        }
    }

    public StreamEntryID xadd(String s, Map<String, String> map, XAddParams xAddParams) {
        try (JedisClient jedisClient = this.route(s);){
            StreamEntryID streamEntryID = jedisClient.xadd(s, map, xAddParams);
            return streamEntryID;
        }
    }

    public Long xlen(String key) {
        try (JedisClient jedisClient = this.route(key);){
            Long l = jedisClient.xlen(key);
            return l;
        }
    }

    public List<StreamEntry> xrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xrange(s, streamEntryID, streamEntryID1);
            return list;
        }
    }

    public List<StreamEntry> xrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xrange(s, streamEntryID, streamEntryID1, i);
            return list;
        }
    }

    public List<StreamEntry> xrevrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xrevrange(s, streamEntryID, streamEntryID1);
            return list;
        }
    }

    public List<StreamEntry> xrevrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xrevrange(s, streamEntryID, streamEntryID1, i);
            return list;
        }
    }

    public long xack(String s, String s1, StreamEntryID ... streamEntryIDS) {
        try (JedisClient jedisClient = this.route(s);){
            long l = jedisClient.xack(s, s1, streamEntryIDS);
            return l;
        }
    }

    public String xgroupCreate(String s, String s1, StreamEntryID streamEntryID, boolean b) {
        try (JedisClient jedisClient = this.route(s);){
            String string = jedisClient.xgroupCreate(s, s1, streamEntryID, b);
            return string;
        }
    }

    public String xgroupSetID(String s, String s1, StreamEntryID streamEntryID) {
        try (JedisClient jedisClient = this.route(s);){
            String string = jedisClient.xgroupSetID(s, s1, streamEntryID);
            return string;
        }
    }

    public long xgroupDestroy(String s, String s1) {
        try (JedisClient jedisClient = this.route(s);){
            long l = jedisClient.xgroupDestroy(s, s1);
            return l;
        }
    }

    public Long xgroupDelConsumer(String s, String s1, String s2) {
        try (JedisClient jedisClient = this.route(s);){
            Long l = jedisClient.xgroupDelConsumer(s, s1, s2);
            return l;
        }
    }

    public StreamPendingSummary xpending(String s, String s1) {
        try (JedisClient jedisClient = this.route(s);){
            StreamPendingSummary streamPendingSummary = jedisClient.xpending(s, s1);
            return streamPendingSummary;
        }
    }

    public List<StreamPendingEntry> xpending(String s, String s1, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i, String s2) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xpending(s, s1, streamEntryID, streamEntryID1, i, s2);
            return list;
        }
    }

    public List<StreamPendingEntry> xpending(String s, String s1, XPendingParams xPendingParams) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xpending(s, s1, xPendingParams);
            return list;
        }
    }

    public long xdel(String s, StreamEntryID ... streamEntryIDS) {
        try (JedisClient jedisClient = this.route(s);){
            long l = jedisClient.xdel(s, streamEntryIDS);
            return l;
        }
    }

    public long xtrim(String s, long l, boolean b) {
        try (JedisClient jedisClient = this.route(s);){
            long l2 = jedisClient.xtrim(s, l, b);
            return l2;
        }
    }

    public long xtrim(String s, XTrimParams xTrimParams) {
        try (JedisClient jedisClient = this.route(s);){
            long l = jedisClient.xtrim(s, xTrimParams);
            return l;
        }
    }

    public List<StreamEntry> xclaim(String s, String s1, String s2, long l, long l1, int i, boolean b, StreamEntryID ... streamEntryIDS) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xclaim(s, s1, s2, l, l1, i, b, streamEntryIDS);
            return list;
        }
    }

    public List<StreamEntry> xclaim(String s, String s1, String s2, long l, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDS) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xclaim(s, s1, s2, l, xClaimParams, streamEntryIDS);
            return list;
        }
    }

    public List<StreamEntryID> xclaimJustId(String s, String s1, String s2, long l, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDS) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xclaimJustId(s, s1, s2, l, xClaimParams, streamEntryIDS);
            return list;
        }
    }

    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String s, String s1, String s2, long l, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        try (JedisClient jedisClient = this.route(s);){
            Map.Entry entry = jedisClient.xautoclaim(s, s1, s2, l, streamEntryID, xAutoClaimParams);
            return entry;
        }
    }

    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String s, String s1, String s2, long l, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        try (JedisClient jedisClient = this.route(s);){
            Map.Entry entry = jedisClient.xautoclaimJustId(s, s1, s2, l, streamEntryID, xAutoClaimParams);
            return entry;
        }
    }

    public StreamInfo xinfoStream(String s) {
        try (JedisClient jedisClient = this.route(s);){
            StreamInfo streamInfo = jedisClient.xinfoStream(s);
            return streamInfo;
        }
    }

    public List<StreamGroupInfo> xinfoGroup(String s) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xinfoGroup(s);
            return list;
        }
    }

    public List<StreamConsumersInfo> xinfoConsumers(String s, String s1) {
        try (JedisClient jedisClient = this.route(s);){
            List list = jedisClient.xinfoConsumers(s, s1);
            return list;
        }
    }

    public LCSMatchResult strAlgoLCSStrings(String s, String s1, StrAlgoLCSParams strAlgoLCSParams) {
        try (JedisClient jedisClient = this.route(s);){
            LCSMatchResult lCSMatchResult = jedisClient.strAlgoLCSStrings(s, s1, strAlgoLCSParams);
            return lCSMatchResult;
        }
    }
}

