/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.wrapper;

import kd.bos.redis.JedisClient;
import kd.bos.redis.custom.VendorWrapper;
import kd.bos.redis.wrapper.CloseableJedisClientManager;
import kd.bos.redis.wrapper.ClusterJedisClient;
import kd.bos.redis.wrapper.CommonJedisClient;
import kd.bos.redis.wrapper.ShardedJedisClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.ShardedJedis;

public class Wrapper {
    private static String redisVendor = System.getProperty("redis.vendor");

    public static JedisClient wrap(Object jedis, String url) {
        if (jedis instanceof JedisClient) {
            CloseableJedisClientManager.put((JedisClient)jedis);
            return (JedisClient)jedis;
        }
        JedisClient jedisClient = null;
        if (redisVendor != null) {
            jedisClient = VendorWrapper.wrap(jedis, url, redisVendor);
            CloseableJedisClientManager.put(jedisClient);
        } else {
            jedisClient = Wrapper.wrap(jedis);
        }
        return jedisClient;
    }

    public static JedisClient wrap(Object jedis) {
        JedisClient jedisClient = null;
        if (jedis instanceof Jedis) {
            jedisClient = new CommonJedisClient((Jedis)jedis);
        } else if (jedis instanceof ShardedJedis) {
            jedisClient = new ShardedJedisClient((ShardedJedis)jedis);
        } else if (jedis instanceof JedisCluster) {
            jedisClient = new ClusterJedisClient((JedisCluster)jedis);
        } else if (jedis instanceof JedisClient) {
            jedisClient = (JedisClient)jedis;
        } else {
            throw new RuntimeException("Not implements: " + jedis.getClass().getName());
        }
        CloseableJedisClientManager.put(jedisClient);
        return jedisClient;
    }

    public static JedisClient wrap(ShardedJedis jedis) {
        ShardedJedisClient jedisClient = new ShardedJedisClient(jedis);
        CloseableJedisClientManager.put(jedisClient);
        return jedisClient;
    }

    public static JedisClient wrap(Jedis jedis) {
        CommonJedisClient jedisClient = new CommonJedisClient(jedis);
        CloseableJedisClientManager.put(jedisClient);
        return jedisClient;
    }
}

