/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.xcache;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kd.bos.redis.JedisClient;
import kd.bos.redis.wrapper.CommonJedisClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class XCacheJedisClient
extends CommonJedisClient
implements JedisClient {
    public XCacheJedisClient(Jedis jedis) {
        super(jedis);
    }

    @Override
    public Object sendExtendCommand(ProtocolCommand cmd, byte[] ... args) {
        if (!this.allowedCommand(cmd)) {
            throw new UnsupportedOperationException(String.format("XCache not allowed to execute this command: [%s]", cmd == null ? "null" : new String(cmd.getRaw(), StandardCharsets.UTF_8)));
        }
        return this.jedis.sendCommand(cmd, args);
    }

    protected boolean allowedCommand(ProtocolCommand cmd) {
        if (cmd == null) {
            return false;
        }
        for (Command each : Command.values()) {
            if (!Arrays.equals(each.getRaw(), cmd.getRaw())) continue;
            return true;
        }
        return false;
    }

    public static enum Command implements ProtocolCommand
    {
        SCANDATA;

        private final byte[] raw = SafeEncoder.encode((String)this.name());

        public byte[] getRaw() {
            return this.raw;
        }
    }
}

