/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.redis.xcache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.util.SafeEncoder;

public class XCacheScanParams {
    private final Map<PARAM, byte[]> params = new EnumMap<PARAM, byte[]>(PARAM.class);
    public static final String SCAN_POINTER_START = String.valueOf(0);

    public XCacheScanParams match(String pattern) {
        this.params.put(PARAM.MATCH, SafeEncoder.encode((String)pattern));
        return this;
    }

    public XCacheScanParams count(Integer count) {
        this.params.put(PARAM.COUNT, Protocol.toByteArray((int)count));
        return this;
    }

    public XCacheScanParams type(String type) {
        this.params.put(PARAM.TYPE, SafeEncoder.encode((String)type));
        return this;
    }

    public XCacheScanParams memory(String memory) {
        this.params.put(PARAM.MEMORY, SafeEncoder.encode((String)memory));
        return this;
    }

    public Collection<byte[]> getParams() {
        ArrayList<byte[]> paramsList = new ArrayList<byte[]>(this.params.size());
        for (Map.Entry<PARAM, byte[]> param : this.params.entrySet()) {
            paramsList.add(param.getKey().getRaw());
            paramsList.add(param.getValue());
        }
        return Collections.unmodifiableCollection(paramsList);
    }

    private static enum PARAM implements Rawable
    {
        MATCH,
        COUNT,
        TYPE,
        MEMORY;

        private final byte[] raw = SafeEncoder.encode((String)this.name().toLowerCase(Locale.ENGLISH));

        public byte[] getRaw() {
            return this.raw;
        }
    }
}

