/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.args.ClientPauseMode;
import redis.clients.jedis.args.ClientType;
import redis.clients.jedis.args.FlushMode;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.args.SaveMode;
import redis.clients.jedis.args.UnblockType;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.params.ClientKillParams;
import redis.clients.jedis.params.FailoverParams;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.StrAlgoLCSParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.SafeEncoder;

@Deprecated
public class BinaryClient
extends Connection {
    private boolean isInMulti;
    @Deprecated
    private String user;
    @Deprecated
    private String password;
    private int db;
    private boolean isInWatch;

    public BinaryClient() {
    }

    @Deprecated
    public BinaryClient(String host) {
        super(host);
    }

    public BinaryClient(String host, int port) {
        super(host, port);
    }

    @Deprecated
    public BinaryClient(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    @Deprecated
    public BinaryClient(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public BinaryClient(HostAndPort hostPort, JedisClientConfig clientConfig) {
        super(hostPort, clientConfig);
    }

    public BinaryClient(JedisSocketFactory jedisSocketFactory) {
        super(jedisSocketFactory);
    }

    public boolean isInMulti() {
        return this.isInMulti;
    }

    public boolean isInWatch() {
        return this.isInWatch;
    }

    private byte[][] joinParameters(byte[] first, byte[][] rest) {
        byte[][] result = new byte[rest.length + 1][];
        result[0] = first;
        System.arraycopy(rest, 0, result, 1, rest.length);
        return result;
    }

    private byte[][] joinParameters(byte[] first, byte[] second, byte[][] rest) {
        byte[][] result = new byte[rest.length + 2][];
        result[0] = first;
        result[1] = second;
        System.arraycopy(rest, 0, result, 2, rest.length);
        return result;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDb(int db) {
        this.db = db;
    }

    public int getDB() {
        return this.db;
    }

    public void connect() {
        if (!this.isConnected()) {
            super.connect();
            if (this.user != null) {
                this.auth(this.user, this.password);
                this.getStatusCodeReply();
            } else if (this.password != null) {
                this.auth(this.password);
                this.getStatusCodeReply();
            }
            if (this.db > 0) {
                this.select(this.db);
                this.getStatusCodeReply();
            }
        }
    }

    public void disconnect() {
        this.db = 0;
        super.disconnect();
    }

    public void close() {
        this.db = 0;
        super.close();
    }

    public void resetState() {
        if (this.isInWatch()) {
            this.unwatch();
            this.getStatusCodeReply();
        }
    }

    public void copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        if (replace) {
            this.sendCommand((ProtocolCommand)Protocol.Command.COPY, new byte[][]{srcKey, dstKey, Protocol.Keyword.REPLACE.getRaw()});
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.COPY, new byte[][]{srcKey, dstKey});
        }
    }

    public void copy(byte[] srcKey, byte[] dstKey, int db, boolean replace) {
        if (replace) {
            this.sendCommand((ProtocolCommand)Protocol.Command.COPY, new byte[][]{srcKey, dstKey, Protocol.Keyword.DB.getRaw(), Protocol.toByteArray((int)db), Protocol.Keyword.REPLACE.getRaw()});
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.COPY, new byte[][]{srcKey, dstKey, Protocol.Keyword.DB.getRaw(), Protocol.toByteArray((int)db)});
        }
    }

    public void ping() {
        this.sendCommand((ProtocolCommand)Protocol.Command.PING);
    }

    public void ping(byte[] message) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PING, new byte[][]{message});
    }

    public void set(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SET, new byte[][]{key, value});
    }

    public void set(byte[] key, byte[] value, SetParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SET, params.getByteParams((byte[][])new byte[][]{key, value}));
    }

    public void get(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GET, new byte[][]{key});
    }

    public void getDel(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETDEL, new byte[][]{key});
    }

    public void getEx(byte[] key, GetExParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETEX, params.getByteParams(key, (byte[][])new byte[0][]));
    }

    public void quit() {
        this.db = 0;
        this.sendCommand((ProtocolCommand)Protocol.Command.QUIT);
    }

    public void exists(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXISTS, keys);
    }

    public void del(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DEL, keys);
    }

    public void unlink(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.UNLINK, keys);
    }

    public void type(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TYPE, new byte[][]{key});
    }

    public void flushDB() {
        this.sendCommand((ProtocolCommand)Protocol.Command.FLUSHDB);
    }

    public void flushDB(FlushMode flushMode) {
        this.sendCommand((ProtocolCommand)Protocol.Command.FLUSHDB, new byte[][]{flushMode.getRaw()});
    }

    public void keys(byte[] pattern) {
        this.sendCommand((ProtocolCommand)Protocol.Command.KEYS, new byte[][]{pattern});
    }

    public void randomKey() {
        this.sendCommand((ProtocolCommand)Protocol.Command.RANDOMKEY);
    }

    public void rename(byte[] oldkey, byte[] newkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RENAME, new byte[][]{oldkey, newkey});
    }

    public void renamenx(byte[] oldkey, byte[] newkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RENAMENX, new byte[][]{oldkey, newkey});
    }

    public void dbSize() {
        this.sendCommand((ProtocolCommand)Protocol.Command.DBSIZE);
    }

    @Deprecated
    public void expire(byte[] key, int seconds) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXPIRE, new byte[][]{key, Protocol.toByteArray((int)seconds)});
    }

    public void expire(byte[] key, long seconds) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXPIRE, new byte[][]{key, Protocol.toByteArray((long)seconds)});
    }

    public void expireAt(byte[] key, long unixTime) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXPIREAT, new byte[][]{key, Protocol.toByteArray((long)unixTime)});
    }

    public void ttl(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TTL, new byte[][]{key});
    }

    public void touch(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.TOUCH, keys);
    }

    public void select(int index) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray((int)index)});
    }

    public void swapDB(int index1, int index2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SWAPDB, new byte[][]{Protocol.toByteArray((int)index1), Protocol.toByteArray((int)index2)});
    }

    public void move(byte[] key, int dbIndex) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MOVE, new byte[][]{key, Protocol.toByteArray((int)dbIndex)});
    }

    public void flushAll() {
        this.sendCommand((ProtocolCommand)Protocol.Command.FLUSHALL);
    }

    public void flushAll(FlushMode flushMode) {
        this.sendCommand((ProtocolCommand)Protocol.Command.FLUSHALL, new byte[][]{flushMode.getRaw()});
    }

    public void getSet(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETSET, new byte[][]{key, value});
    }

    public void mget(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MGET, keys);
    }

    public void setnx(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETNX, new byte[][]{key, value});
    }

    @Deprecated
    public void setex(byte[] key, int seconds, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETEX, new byte[][]{key, Protocol.toByteArray((int)seconds), value});
    }

    public void setex(byte[] key, long seconds, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETEX, new byte[][]{key, Protocol.toByteArray((long)seconds), value});
    }

    public void mset(byte[] ... keysvalues) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MSET, keysvalues);
    }

    public void msetnx(byte[] ... keysvalues) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MSETNX, keysvalues);
    }

    public void decrBy(byte[] key, long decrement) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DECRBY, new byte[][]{key, Protocol.toByteArray((long)decrement)});
    }

    public void decr(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DECR, new byte[][]{key});
    }

    public void incrBy(byte[] key, long increment) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCRBY, new byte[][]{key, Protocol.toByteArray((long)increment)});
    }

    public void incrByFloat(byte[] key, double increment) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCRBYFLOAT, new byte[][]{key, Protocol.toByteArray((double)increment)});
    }

    public void incr(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INCR, new byte[][]{key});
    }

    public void append(byte[] key, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.APPEND, new byte[][]{key, value});
    }

    public void substr(byte[] key, int start, int end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUBSTR, new byte[][]{key, Protocol.toByteArray((int)start), Protocol.toByteArray((int)end)});
    }

    public void hset(byte[] key, byte[] field, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSET, new byte[][]{key, field, value});
    }

    public void hset(byte[] key, Map<byte[], byte[]> hash) {
        byte[][] params = new byte[1 + hash.size() * 2][];
        int index = 0;
        params[index++] = key;
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params[index++] = entry.getKey();
            params[index++] = entry.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.HSET, params);
    }

    public void hget(byte[] key, byte[] field) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HGET, new byte[][]{key, field});
    }

    public void hsetnx(byte[] key, byte[] field, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSETNX, new byte[][]{key, field, value});
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(hash.size());
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.HMSET, (byte[][])params.toArray((T[])new byte[params.size()][]));
    }

    public void hmget(byte[] key, byte[] ... fields) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HMGET, this.joinParameters(key, fields));
    }

    public void hincrBy(byte[] key, byte[] field, long value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HINCRBY, new byte[][]{key, field, Protocol.toByteArray((long)value)});
    }

    public void hexists(byte[] key, byte[] field) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HEXISTS, new byte[][]{key, field});
    }

    public void hdel(byte[] key, byte[] ... fields) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HDEL, this.joinParameters(key, fields));
    }

    public void hlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HLEN, new byte[][]{key});
    }

    public void hkeys(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HKEYS, new byte[][]{key});
    }

    public void hvals(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HVALS, new byte[][]{key});
    }

    public void hgetAll(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HGETALL, new byte[][]{key});
    }

    public void hrandfield(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HRANDFIELD, new byte[][]{key});
    }

    public void hrandfield(byte[] key, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HRANDFIELD, new byte[][]{key, Protocol.toByteArray((long)count)});
    }

    public void hrandfieldWithValues(byte[] key, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HRANDFIELD, new byte[][]{key, Protocol.toByteArray((long)count), Protocol.Keyword.WITHVALUES.getRaw()});
    }

    public void rpush(byte[] key, byte[] ... strings) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPUSH, this.joinParameters(key, strings));
    }

    public void lpush(byte[] key, byte[] ... strings) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPUSH, this.joinParameters(key, strings));
    }

    public void llen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LLEN, new byte[][]{key});
    }

    public void lrange(byte[] key, long start, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LRANGE, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop)});
    }

    public void ltrim(byte[] key, long start, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LTRIM, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop)});
    }

    public void lindex(byte[] key, long index) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LINDEX, new byte[][]{key, Protocol.toByteArray((long)index)});
    }

    public void lset(byte[] key, long index, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LSET, new byte[][]{key, Protocol.toByteArray((long)index), value});
    }

    public void lrem(byte[] key, long count, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LREM, new byte[][]{key, Protocol.toByteArray((long)count), value});
    }

    public void lpop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPOP, new byte[][]{key});
    }

    public void lpop(byte[] key, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPOP, new byte[][]{key, Protocol.toByteArray((int)count)});
    }

    public void lpos(byte[] key, byte[] element) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPOS, new byte[][]{key, element});
    }

    public void lpos(byte[] key, byte[] element, LPosParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPOS, this.joinParameters(key, element, params.getByteParams()));
    }

    public void lpos(byte[] key, byte[] element, LPosParams params, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPOS, this.joinParameters(key, element, params.getByteParams((byte[][])new byte[][]{Protocol.Keyword.COUNT.getRaw(), Protocol.toByteArray((long)count)})));
    }

    public void rpop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPOP, new byte[][]{key});
    }

    public void rpop(byte[] key, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPOP, new byte[][]{key, Protocol.toByteArray((int)count)});
    }

    public void rpoplpush(byte[] srckey, byte[] dstkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPOPLPUSH, new byte[][]{srckey, dstkey});
    }

    public void sadd(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SADD, this.joinParameters(key, members));
    }

    public void smembers(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SMEMBERS, new byte[][]{key});
    }

    public void srem(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SREM, this.joinParameters(key, members));
    }

    public void spop(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SPOP, new byte[][]{key});
    }

    public void spop(byte[] key, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SPOP, new byte[][]{key, Protocol.toByteArray((long)count)});
    }

    public void smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SMOVE, new byte[][]{srckey, dstkey, member});
    }

    public void scard(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCARD, new byte[][]{key});
    }

    public void sismember(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SISMEMBER, new byte[][]{key, member});
    }

    public void smismember(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SMISMEMBER, this.joinParameters(key, members));
    }

    public void sinter(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SINTER, keys);
    }

    public void sinterstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SINTERSTORE, this.joinParameters(dstkey, keys));
    }

    public void sunion(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUNION, keys);
    }

    public void sunionstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUNIONSTORE, this.joinParameters(dstkey, keys));
    }

    public void sdiff(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SDIFF, keys);
    }

    public void sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SDIFFSTORE, this.joinParameters(dstkey, keys));
    }

    public void srandmember(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SRANDMEMBER, new byte[][]{key});
    }

    public void zadd(byte[] key, double score, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, new byte[][]{key, Protocol.toByteArray((double)score), member});
    }

    public void zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params.getByteParams(key, (byte[][])new byte[][]{Protocol.toByteArray((double)score), member}));
    }

    public void zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(scoreMembers.size() * 2 + 1);
        args.add(key);
        args.addAll(this.convertScoreMembersToByteArrays(scoreMembers));
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, argsArray);
    }

    public void zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        ArrayList<byte[]> args = this.convertScoreMembersToByteArrays(scoreMembers);
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params.getByteParams(key, (byte[][])argsArray));
    }

    public void zdiff(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZDIFF, this.joinParameters(Protocol.toByteArray((int)keys.length), keys));
    }

    public void zdiffWithScores(byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(keys.length + 2);
        args.add(Protocol.toByteArray((int)keys.length));
        Collections.addAll(args, keys);
        args.add(Protocol.Keyword.WITHSCORES.getRaw());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZDIFF, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zaddIncr(byte[] key, double score, byte[] member, ZAddParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params.getByteParams(key, (byte[][])new byte[][]{Protocol.Command.INCR.getRaw(), Protocol.toByteArray((double)score), member}));
    }

    public void zdiffStore(byte[] dstkey, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZDIFFSTORE, this.joinParameters(dstkey, Protocol.toByteArray((int)keys.length), keys));
    }

    public void zrange(byte[] key, long start, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGE, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop)});
    }

    public void zrem(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREM, this.joinParameters(key, members));
    }

    public void zincrby(byte[] key, double increment, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINCRBY, new byte[][]{key, Protocol.toByteArray((double)increment), member});
    }

    public void zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZADD, params.getByteParams(key, (byte[][])new byte[][]{Protocol.toByteArray((double)increment), member}));
    }

    public void zrank(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANK, new byte[][]{key, member});
    }

    public void zrevrank(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANK, new byte[][]{key, member});
    }

    public void zrevrange(byte[] key, long start, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGE, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop)});
    }

    public void zrangeWithScores(byte[] key, long start, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGE, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrevrangeWithScores(byte[] key, long start, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGE, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrandmember(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANDMEMBER, new byte[][]{key});
    }

    public void zrandmember(byte[] key, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANDMEMBER, new byte[][]{key, Protocol.toByteArray((long)count)});
    }

    public void zrandmemberWithScores(byte[] key, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANDMEMBER, new byte[][]{key, Protocol.toByteArray((long)count), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zcard(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCARD, new byte[][]{key});
    }

    public void zscore(byte[] key, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZSCORE, new byte[][]{key, member});
    }

    public void zmscore(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZMSCORE, this.joinParameters(key, members));
    }

    public void zpopmax(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZPOPMAX, new byte[][]{key});
    }

    public void zpopmax(byte[] key, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZPOPMAX, new byte[][]{key, Protocol.toByteArray((int)count)});
    }

    public void zpopmin(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZPOPMIN, new byte[][]{key});
    }

    public void zpopmin(byte[] key, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZPOPMIN, new byte[][]{key, Protocol.toByteArray((long)count)});
    }

    public void multi() {
        this.sendCommand((ProtocolCommand)Protocol.Command.MULTI);
        this.isInMulti = true;
    }

    public void discard() {
        this.sendCommand((ProtocolCommand)Protocol.Command.DISCARD);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void exec() {
        this.sendCommand((ProtocolCommand)Protocol.Command.EXEC);
        this.isInMulti = false;
        this.isInWatch = false;
    }

    public void watch(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.WATCH, keys);
        this.isInWatch = true;
    }

    public void unwatch() {
        this.sendCommand((ProtocolCommand)Protocol.Command.UNWATCH);
        this.isInWatch = false;
    }

    public void sort(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, new byte[][]{key});
    }

    public void sort(byte[] key, SortingParams sortingParameters) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.addAll(sortingParameters.getParams());
        args.add(Protocol.Keyword.STORE.getRaw());
        args.add(dstkey);
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sort(byte[] key, byte[] dstkey) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SORT, new byte[][]{key, Protocol.Keyword.STORE.getRaw(), dstkey});
    }

    public void lmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LMOVE, new byte[][]{srcKey, dstKey, from.getRaw(), to.getRaw()});
    }

    public void blmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to, double timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BLMOVE, new byte[][]{srcKey, dstKey, from.getRaw(), to.getRaw(), Protocol.toByteArray((double)timeout)});
    }

    public void blpop(byte[][] args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BLPOP, args);
    }

    public void blpop(int timeout, byte[] ... keys) {
        this.blpop(BinaryClient.getKeysAndTimeout(timeout, keys));
    }

    public void blpop(double timeout, byte[] ... keys) {
        this.blpop(BinaryClient.getKeysAndTimeout(timeout, keys));
    }

    public void brpop(byte[][] args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BRPOP, args);
    }

    public void brpop(int timeout, byte[] ... keys) {
        this.brpop(BinaryClient.getKeysAndTimeout(timeout, keys));
    }

    public void brpop(double timeout, byte[] ... keys) {
        this.brpop(BinaryClient.getKeysAndTimeout(timeout, keys));
    }

    public void bzpopmax(double timeout, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BZPOPMAX, BinaryClient.getKeysAndTimeout(timeout, keys));
    }

    public void bzpopmin(double timeout, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BZPOPMIN, BinaryClient.getKeysAndTimeout(timeout, keys));
    }

    private static byte[][] getKeysAndTimeout(int timeout, byte[] ... keys) {
        int numKeys = keys.length;
        byte[][] args = new byte[numKeys + 1][];
        System.arraycopy(keys, 0, args, 0, numKeys);
        args[numKeys] = Protocol.toByteArray((int)timeout);
        return args;
    }

    private static byte[][] getKeysAndTimeout(double timeout, byte[] ... keys) {
        int numKeys = keys.length;
        byte[][] args = new byte[numKeys + 1][];
        System.arraycopy(keys, 0, args, 0, numKeys);
        args[numKeys] = Protocol.toByteArray((double)timeout);
        return args;
    }

    public void auth(String password) {
        this.setPassword(password);
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, new String[]{password});
    }

    public void auth(String user, String password) {
        this.setUser(user);
        this.setPassword(password);
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, new String[]{user, password});
    }

    public void subscribe(byte[] ... channels) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SUBSCRIBE, channels);
    }

    public void publish(byte[] channel, byte[] message) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUBLISH, new byte[][]{channel, message});
    }

    public void unsubscribe() {
        this.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE);
    }

    public void unsubscribe(byte[] ... channels) {
        this.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE, channels);
    }

    public void psubscribe(byte[] ... patterns) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PSUBSCRIBE, patterns);
    }

    public void punsubscribe() {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE);
    }

    public void punsubscribe(byte[] ... patterns) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE, patterns);
    }

    public void pubsub(byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, args);
    }

    public void zcount(byte[] key, double min, double max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCOUNT, new byte[][]{key, Protocol.toByteArray((double)min), Protocol.toByteArray((double)max)});
    }

    public void zcount(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZCOUNT, new byte[][]{key, min, max});
    }

    public void zrangeByScore(byte[] key, double min, double max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)min), Protocol.toByteArray((double)max)});
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, min, max});
    }

    public void zrevrangeByScore(byte[] key, double max, double min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)max), Protocol.toByteArray((double)min)});
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, max, min});
    }

    public void zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)min), Protocol.toByteArray((double)max), Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count)});
    }

    public void zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)max), Protocol.toByteArray((double)min), Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count)});
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)min), Protocol.toByteArray((double)max), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)max), Protocol.toByteArray((double)min), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)min), Protocol.toByteArray((double)max), Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)max), Protocol.toByteArray((double)min), Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, min, max, Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count)});
    }

    public void zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, max, min, Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count)});
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, min, max, Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, max, min, Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYSCORE, new byte[][]{key, min, max, Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYSCORE, new byte[][]{key, max, min, Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count), Protocol.Keyword.WITHSCORES.getRaw()});
    }

    public void zremrangeByRank(byte[] key, long start, long stop) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYRANK, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)stop)});
    }

    public void zremrangeByScore(byte[] key, double min, double max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYSCORE, new byte[][]{key, Protocol.toByteArray((double)min), Protocol.toByteArray((double)max)});
    }

    public void zremrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYSCORE, new byte[][]{key, min, max});
    }

    public void zunion(ZParams params, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNION, this.buildByteZParams(params, false, keys));
    }

    public void zunionWithScores(ZParams params, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNION, this.buildByteZParams(params, true, keys));
    }

    private byte[][] buildByteZParams(ZParams params, boolean withScores, byte[] ... keys) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((int)keys.length));
        Collections.addAll(args, keys);
        args.addAll(params.getParams());
        if (withScores) {
            args.add(Protocol.Keyword.WITHSCORES.getRaw());
        }
        return (byte[][])args.toArray((T[])new byte[args.size()][]);
    }

    public void zunionstore(byte[] dstkey, byte[] ... sets) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNIONSTORE, this.joinParameters(dstkey, Protocol.toByteArray((int)sets.length), sets));
    }

    public void zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray((int)sets.length));
        Collections.addAll(args, sets);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZUNIONSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zinter(ZParams params, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTER, this.buildByteZParams(params, false, keys));
    }

    public void zinterWithScores(ZParams params, byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTER, this.buildByteZParams(params, true, keys));
    }

    public void zinterstore(byte[] dstkey, byte[] ... sets) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTERSTORE, this.joinParameters(dstkey, Protocol.toByteArray((int)sets.length), sets));
    }

    public void zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(dstkey);
        args.add(Protocol.toByteArray((int)sets.length));
        Collections.addAll(args, sets);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZINTERSTORE, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zlexcount(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZLEXCOUNT, new byte[][]{key, min, max});
    }

    public void zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYLEX, new byte[][]{key, min, max});
    }

    public void zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZRANGEBYLEX, new byte[][]{key, min, max, Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count)});
    }

    public void zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYLEX, new byte[][]{key, max, min});
    }

    public void zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREVRANGEBYLEX, new byte[][]{key, max, min, Protocol.Keyword.LIMIT.getRaw(), Protocol.toByteArray((int)offset), Protocol.toByteArray((int)count)});
    }

    public void zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ZREMRANGEBYLEX, new byte[][]{key, min, max});
    }

    public void save() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SAVE);
    }

    public void bgsave() {
        this.sendCommand((ProtocolCommand)Protocol.Command.BGSAVE);
    }

    public void bgrewriteaof() {
        this.sendCommand((ProtocolCommand)Protocol.Command.BGREWRITEAOF);
    }

    public void lastsave() {
        this.sendCommand((ProtocolCommand)Protocol.Command.LASTSAVE);
    }

    public void shutdown() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SHUTDOWN);
    }

    public void shutdown(SaveMode saveMode) {
        if (saveMode == null) {
            this.sendCommand((ProtocolCommand)Protocol.Command.SHUTDOWN);
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.SHUTDOWN, new byte[][]{saveMode.getRaw()});
        }
    }

    public void info() {
        this.sendCommand((ProtocolCommand)Protocol.Command.INFO);
    }

    public void info(String section) {
        this.sendCommand((ProtocolCommand)Protocol.Command.INFO, new String[]{section});
    }

    public void monitor() {
        this.sendCommand((ProtocolCommand)Protocol.Command.MONITOR);
    }

    public void slaveof(String host, int port) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, new String[]{host, String.valueOf(port)});
    }

    public void slaveofNoOne() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, new byte[][]{Protocol.Keyword.NO.getRaw(), Protocol.Keyword.ONE.getRaw()});
    }

    public void role() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ROLE);
    }

    public void configGet(byte[] pattern) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.GET.getRaw(), pattern});
    }

    public void configSet(byte[] parameter, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.SET.getRaw(), parameter, value});
    }

    public void strlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.STRLEN, new byte[][]{key});
    }

    public void strAlgoLCSKeys(byte[] keyA, byte[] keyB, StrAlgoLCSParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.STRALGO, params.getByteParams(Protocol.Keyword.KEYS, keyA, keyB));
    }

    public void strAlgoLCSStrings(byte[] strA, byte[] strB, StrAlgoLCSParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.STRALGO, params.getByteParams(Protocol.Keyword.STRINGS, strA, strB));
    }

    @Deprecated
    public void sync() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SYNC);
    }

    public void lpushx(byte[] key, byte[] ... string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LPUSHX, this.joinParameters(key, string));
    }

    public void persist(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PERSIST, new byte[][]{key});
    }

    public void rpushx(byte[] key, byte[] ... string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RPUSHX, this.joinParameters(key, string));
    }

    public void echo(byte[] string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ECHO, new byte[][]{string});
    }

    public void linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.LINSERT, new byte[][]{key, where.raw, pivot, value});
    }

    @Deprecated
    public void debug(DebugParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DEBUG, params.getCommand());
    }

    public void brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BRPOPLPUSH, new byte[][]{source, destination, Protocol.toByteArray((int)timeout)});
    }

    public void configResetStat() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.RESETSTAT.getRaw()});
    }

    public void configRewrite() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, new byte[][]{Protocol.Keyword.REWRITE.getRaw()});
    }

    public void setbit(byte[] key, long offset, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETBIT, new byte[][]{key, Protocol.toByteArray((long)offset), value});
    }

    public void setbit(byte[] key, long offset, boolean value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETBIT, new byte[][]{key, Protocol.toByteArray((long)offset), Protocol.toByteArray((boolean)value)});
    }

    public void getbit(byte[] key, long offset) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETBIT, new byte[][]{key, Protocol.toByteArray((long)offset)});
    }

    public void bitpos(byte[] key, boolean value, BitPosParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(Protocol.toByteArray((boolean)value));
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.BITPOS, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void setrange(byte[] key, long offset, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SETRANGE, new byte[][]{key, Protocol.toByteArray((long)offset), value});
    }

    public void getrange(byte[] key, long startOffset, long endOffset) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GETRANGE, new byte[][]{key, Protocol.toByteArray((long)startOffset), Protocol.toByteArray((long)endOffset)});
    }

    public void eval(byte[] script, byte[] keyCount, byte[][] params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVAL, this.joinParameters(script, keyCount, params));
    }

    public void eval(byte[] script, int keyCount, byte[] ... params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVAL, this.joinParameters(script, Protocol.toByteArray((int)keyCount), params));
    }

    public void evalsha(byte[] sha1, byte[] keyCount, byte[] ... params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVALSHA, this.joinParameters(sha1, keyCount, params));
    }

    public void evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.EVALSHA, this.joinParameters(sha1, Protocol.toByteArray((int)keyCount), params));
    }

    public void scriptFlush() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.FLUSH.getRaw()});
    }

    public void scriptFlush(FlushMode flushMode) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.FLUSH.getRaw(), flushMode.getRaw()});
    }

    public void scriptExists(byte[] ... sha1) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, this.joinParameters(Protocol.Keyword.EXISTS.getRaw(), sha1));
    }

    public void scriptLoad(byte[] script) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.LOAD.getRaw(), script});
    }

    public void scriptKill() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, new byte[][]{Protocol.Keyword.KILL.getRaw()});
    }

    public void slowlogGet() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.GET.getRaw()});
    }

    public void slowlogGet(long entries) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.GET.getRaw(), Protocol.toByteArray((long)entries)});
    }

    public void slowlogReset() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.RESET.getRaw()});
    }

    public void slowlogLen() {
        this.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, new byte[][]{Protocol.Keyword.LEN.getRaw()});
    }

    public void objectRefcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, new byte[][]{Protocol.Keyword.REFCOUNT.getRaw(), key});
    }

    public void objectIdletime(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, new byte[][]{Protocol.Keyword.IDLETIME.getRaw(), key});
    }

    public void objectEncoding(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, new byte[][]{Protocol.Keyword.ENCODING.getRaw(), key});
    }

    public void objectHelp() {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, new byte[][]{Protocol.Keyword.HELP.getRaw()});
    }

    public void objectFreq(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, new byte[][]{Protocol.Keyword.FREQ.getRaw(), key});
    }

    public void bitcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITCOUNT, new byte[][]{key});
    }

    public void bitcount(byte[] key, long start, long end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITCOUNT, new byte[][]{key, Protocol.toByteArray((long)start), Protocol.toByteArray((long)end)});
    }

    public void bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITOP, this.joinParameters(op.raw, destKey, srcKeys));
    }

    public void sentinel(byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, args);
    }

    public void sentinel(Protocol.SentinelKeyword subcommand, byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, this.joinParameters(subcommand.getRaw(), args));
    }

    public void sentinel(Protocol.SentinelKeyword subcommand) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, new byte[][]{subcommand.getRaw()});
    }

    public void dump(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.DUMP, new byte[][]{key});
    }

    @Deprecated
    public void restore(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, new byte[][]{key, Protocol.toByteArray((int)ttl), serializedValue});
    }

    public void restore(byte[] key, long ttl, byte[] serializedValue) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, new byte[][]{key, Protocol.toByteArray((long)ttl), serializedValue});
    }

    @Deprecated
    public void restoreReplace(byte[] key, int ttl, byte[] serializedValue) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, new byte[][]{key, Protocol.toByteArray((int)ttl), serializedValue, Protocol.Keyword.REPLACE.getRaw()});
    }

    @Deprecated
    public void restoreReplace(byte[] key, long ttl, byte[] serializedValue) {
        this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, new byte[][]{key, Protocol.toByteArray((long)ttl), serializedValue, Protocol.Keyword.REPLACE.getRaw()});
    }

    public void restore(byte[] key, long ttl, byte[] serializedValue, RestoreParams params) {
        if (params == null) {
            this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, new byte[][]{key, Protocol.toByteArray((long)ttl), serializedValue});
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.RESTORE, params.getByteParams(key, (byte[][])new byte[][]{Protocol.toByteArray((long)ttl), serializedValue}));
        }
    }

    public void pexpire(byte[] key, long milliseconds) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PEXPIRE, new byte[][]{key, Protocol.toByteArray((long)milliseconds)});
    }

    public void pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PEXPIREAT, new byte[][]{key, Protocol.toByteArray((long)millisecondsTimestamp)});
    }

    public void pttl(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PTTL, new byte[][]{key});
    }

    public void psetex(byte[] key, long milliseconds, byte[] value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PSETEX, new byte[][]{key, Protocol.toByteArray((long)milliseconds), value});
    }

    public void srandmember(byte[] key, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SRANDMEMBER, new byte[][]{key, Protocol.toByteArray((int)count)});
    }

    public void memoryDoctor() {
        this.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, new byte[][]{Protocol.Keyword.DOCTOR.getRaw()});
    }

    public void memoryUsage(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, new byte[][]{Protocol.Keyword.USAGE.getRaw(), key});
    }

    public void memoryUsage(byte[] key, int samples) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, new byte[][]{Protocol.Keyword.USAGE.getRaw(), key, Protocol.Keyword.SAMPLES.getRaw(), Protocol.toByteArray((int)samples)});
    }

    public void failover(FailoverParams failoverParams) {
        if (failoverParams == null) {
            this.sendCommand((ProtocolCommand)Protocol.Command.FAILOVER);
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.FAILOVER, failoverParams.getByteParams());
        }
    }

    public void failoverAbort() {
        this.sendCommand((ProtocolCommand)Protocol.Command.FAILOVER, new byte[][]{Protocol.Keyword.ABORT.getRaw()});
    }

    public void clientKill(byte[] ipPort) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.KILL.getRaw(), ipPort});
    }

    public void clientKill(String ip, int port) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new String[]{Protocol.Keyword.KILL.name(), ip + ':' + port});
    }

    public void clientKill(ClientKillParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, this.joinParameters(Protocol.Keyword.KILL.getRaw(), params.getByteParams()));
    }

    public void clientGetname() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.GETNAME.getRaw()});
    }

    public void clientList() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.LIST.getRaw()});
    }

    public void clientList(ClientType type) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.LIST.getRaw(), Protocol.Keyword.TYPE.getRaw(), type.getRaw()});
    }

    public void clientList(long ... clientIds) {
        byte[][] params = new byte[2 + clientIds.length][];
        int index = 0;
        params[index++] = Protocol.Keyword.LIST.getRaw();
        params[index++] = Protocol.Keyword.ID.getRaw();
        for (long clientId : clientIds) {
            params[index++] = Protocol.toByteArray((long)clientId);
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, params);
    }

    public void clientInfo() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Command.INFO.getRaw()});
    }

    public void clientSetname(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.SETNAME.getRaw(), name});
    }

    public void clientPause(long timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.PAUSE.getRaw(), Protocol.toByteArray((long)timeout)});
    }

    public void clientId() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.ID.getRaw()});
    }

    public void clientUnblock(long clientId, UnblockType unblockType) {
        if (unblockType == null) {
            this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.UNBLOCK.getRaw(), Protocol.toByteArray((long)clientId)});
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.UNBLOCK.getRaw(), Protocol.toByteArray((long)clientId), unblockType.getRaw()});
        }
    }

    public void clientPause(long timeout, ClientPauseMode mode) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, new byte[][]{Protocol.Keyword.PAUSE.getRaw(), Protocol.toByteArray((long)timeout), mode.getRaw()});
    }

    public void time() {
        this.sendCommand((ProtocolCommand)Protocol.Command.TIME);
    }

    public void migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MIGRATE, new byte[][]{SafeEncoder.encode((String)host), Protocol.toByteArray((int)port), key, Protocol.toByteArray((int)destinationDb), Protocol.toByteArray((int)timeout)});
    }

    public void migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, byte[] ... keys) {
        byte[][] bparams = params.getByteParams();
        int len = 5 + bparams.length + 1 + keys.length;
        byte[][] args = new byte[len][];
        int i = 0;
        args[i++] = SafeEncoder.encode((String)host);
        args[i++] = Protocol.toByteArray((int)port);
        args[i++] = new byte[0];
        args[i++] = Protocol.toByteArray((int)destinationDB);
        args[i++] = Protocol.toByteArray((int)timeout);
        System.arraycopy(bparams, 0, args, i, bparams.length);
        i += bparams.length;
        args[i++] = Protocol.Keyword.KEYS.getRaw();
        System.arraycopy(keys, 0, args, i, keys.length);
        this.sendCommand((ProtocolCommand)Protocol.Command.MIGRATE, args);
    }

    public void hincrByFloat(byte[] key, byte[] field, double increment) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HINCRBYFLOAT, new byte[][]{key, field, Protocol.toByteArray((double)increment)});
    }

    public void scan(byte[] cursor, ScanParams params) {
        this.scan(cursor, params, null);
    }

    public void scan(byte[] cursor, ScanParams params, byte[] type) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(cursor);
        args.addAll(params.getParams());
        if (type != null) {
            args.add(Protocol.Keyword.TYPE.getRaw());
            args.add(type);
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.SCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void hscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.HSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void sscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.SSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void zscan(byte[] key, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(key);
        args.add(cursor);
        args.addAll(params.getParams());
        this.sendCommand((ProtocolCommand)Protocol.Command.ZSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    public void waitReplicas(int replicas, long timeout) {
        this.sendCommand((ProtocolCommand)Protocol.Command.WAIT, new byte[][]{Protocol.toByteArray((int)replicas), Protocol.toByteArray((long)timeout)});
    }

    public void cluster(byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, args);
    }

    public void cluster(Protocol.ClusterKeyword keyword, byte[] ... args) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, this.joinParameters(keyword.getRaw(), args));
    }

    public void asking() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ASKING);
    }

    public void pfadd(byte[] key, byte[] ... elements) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFADD, this.joinParameters(key, elements));
    }

    public void pfcount(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFCOUNT, new byte[][]{key});
    }

    public void pfcount(byte[] ... keys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFCOUNT, keys);
    }

    public void pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.sendCommand((ProtocolCommand)Protocol.Command.PFMERGE, this.joinParameters(destkey, sourcekeys));
    }

    public void readonly() {
        this.sendCommand((ProtocolCommand)Protocol.Command.READONLY);
    }

    public void readwrite() {
        this.sendCommand((ProtocolCommand)Protocol.Command.READWRITE);
    }

    public void geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOADD, new byte[][]{key, Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), member});
    }

    public void geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.geoadd(key, GeoAddParams.geoAddParams(), memberCoordinateMap);
    }

    public void geoadd(byte[] key, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(memberCoordinateMap.size() * 3);
        args.addAll(this.convertGeoCoordinateMapToByteArrays(memberCoordinateMap));
        byte[][] argsArray = new byte[args.size()][];
        args.toArray((T[])argsArray);
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOADD, params.getByteParams(key, (byte[][])argsArray));
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEODIST, new byte[][]{key, member1, member2});
    }

    public void geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEODIST, new byte[][]{key, member1, member2, unit.raw});
    }

    public void geohash(byte[] key, byte[] ... members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOHASH, this.joinParameters(key, members));
    }

    public void geopos(byte[] key, byte[][] members) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEOPOS, this.joinParameters(key, members));
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS, new byte[][]{key, Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.raw});
    }

    public void georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS_RO, new byte[][]{key, Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.raw});
    }

    public void georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS, param.getByteParams((byte[][])new byte[][]{key, Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.raw}));
    }

    public void georadiusStore(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS, param.getByteParams((byte[][])new byte[][]{key, Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.raw, storeParam.getOption(), storeParam.getKey()}));
    }

    public void georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUS_RO, param.getByteParams((byte[][])new byte[][]{key, Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.raw}));
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER, new byte[][]{key, member, Protocol.toByteArray((double)radius), unit.raw});
    }

    public void georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER_RO, new byte[][]{key, member, Protocol.toByteArray((double)radius), unit.raw});
    }

    public void georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER, param.getByteParams((byte[][])new byte[][]{key, member, Protocol.toByteArray((double)radius), unit.raw}));
    }

    public void georadiusByMemberStore(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER, param.getByteParams((byte[][])new byte[][]{key, member, Protocol.toByteArray((double)radius), unit.raw, storeParam.getOption(), storeParam.getKey()}));
    }

    public void georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.sendCommand((ProtocolCommand)Protocol.Command.GEORADIUSBYMEMBER_RO, param.getByteParams((byte[][])new byte[][]{key, member, Protocol.toByteArray((double)radius), unit.raw}));
    }

    public void moduleLoad(byte[] path) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, new byte[][]{Protocol.Keyword.LOAD.getRaw(), path});
    }

    public void moduleList() {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, new byte[][]{Protocol.Keyword.LIST.getRaw()});
    }

    public void moduleUnload(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.MODULE, new byte[][]{Protocol.Keyword.UNLOAD.getRaw(), name});
    }

    private ArrayList<byte[]> convertScoreMembersToByteArrays(Map<byte[], Double> scoreMembers) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(scoreMembers.size() * 2);
        for (Map.Entry<byte[], Double> entry : scoreMembers.entrySet()) {
            args.add(Protocol.toByteArray((double)entry.getValue()));
            args.add(entry.getKey());
        }
        return args;
    }

    public void aclWhoAmI() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.WHOAMI.getRaw()});
    }

    public void aclGenPass() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.GENPASS.getRaw()});
    }

    public void aclList() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.LIST.getRaw()});
    }

    public void aclUsers() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.USERS.getRaw()});
    }

    public void aclCat() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.CAT.getRaw()});
    }

    public void aclCat(byte[] category) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.CAT.getRaw(), category});
    }

    public void aclLog() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.LOG.getRaw()});
    }

    public void aclLog(int limit) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.LOG.getRaw(), Protocol.toByteArray((int)limit)});
    }

    public void aclLog(byte[] option) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.LOG.getRaw(), option});
    }

    public void aclLogReset() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.LOG.getRaw(), Protocol.Keyword.RESET.getRaw()});
    }

    public void aclSetUser(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.SETUSER.getRaw(), name});
    }

    public void aclGetUser(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.GETUSER.getRaw(), name});
    }

    public void aclSetUser(byte[] name, byte[][] parameters) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, this.joinParameters(Protocol.Keyword.SETUSER.getRaw(), name, parameters));
    }

    public void aclDelUser(byte[] name) {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.DELUSER.getRaw(), name});
    }

    public void aclLoad() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.LOAD.getRaw()});
    }

    public void aclSave() {
        this.sendCommand((ProtocolCommand)Protocol.Command.ACL, new byte[][]{Protocol.Keyword.SAVE.getRaw()});
    }

    private List<byte[]> convertGeoCoordinateMapToByteArrays(Map<byte[], GeoCoordinate> memberCoordinateMap) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(memberCoordinateMap.size() * 3);
        for (Map.Entry<byte[], GeoCoordinate> entry : memberCoordinateMap.entrySet()) {
            GeoCoordinate coordinate = entry.getValue();
            args.add(Protocol.toByteArray((double)coordinate.getLongitude()));
            args.add(Protocol.toByteArray((double)coordinate.getLatitude()));
            args.add(entry.getKey());
        }
        return args;
    }

    public void bitfield(byte[] key, byte[] ... value) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITFIELD, this.joinParameters(key, value));
    }

    public void bitfieldReadonly(byte[] key, byte[] ... arguments) {
        this.sendCommand((ProtocolCommand)Protocol.Command.BITFIELD_RO, this.joinParameters(key, arguments));
    }

    public void hstrlen(byte[] key, byte[] field) {
        this.sendCommand((ProtocolCommand)Protocol.Command.HSTRLEN, new byte[][]{key, field});
    }

    public void xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash, long maxLen, boolean approximateLength) {
        int maxLexArgs = 0;
        if (maxLen < Long.MAX_VALUE) {
            maxLexArgs = approximateLength ? 3 : 2;
        }
        byte[][] params = new byte[2 + maxLexArgs + hash.size() * 2][];
        int index = 0;
        params[index++] = key;
        if (maxLen < Long.MAX_VALUE) {
            params[index++] = Protocol.Keyword.MAXLEN.getRaw();
            if (approximateLength) {
                params[index++] = Protocol.BYTES_TILDE;
            }
            params[index++] = Protocol.toByteArray((long)maxLen);
        }
        params[index++] = id;
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params[index++] = entry.getKey();
            params[index++] = entry.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XADD, params);
    }

    public void xadd(byte[] key, Map<byte[], byte[]> hash, XAddParams xAddParams) {
        byte[][] params = new byte[hash.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
            params[index++] = entry.getKey();
            params[index++] = entry.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XADD, xAddParams.getByteParams(key, (byte[][])params));
    }

    public void xlen(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XLEN, new byte[][]{key});
    }

    public void xrange(byte[] key, byte[] start, byte[] end) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XRANGE, new byte[][]{key, start, end});
    }

    @Deprecated
    public void xrange(byte[] key, byte[] start, byte[] end, long count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XRANGE, new byte[][]{key, start, end, Protocol.Keyword.COUNT.getRaw(), Protocol.toByteArray((long)count)});
    }

    public void xrange(byte[] key, byte[] start, byte[] end, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XRANGE, new byte[][]{key, start, end, Protocol.Keyword.COUNT.getRaw(), Protocol.toByteArray((int)count)});
    }

    public void xrevrange(byte[] key, byte[] end, byte[] start) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XREVRANGE, new byte[][]{key, end, start});
    }

    public void xrevrange(byte[] key, byte[] end, byte[] start, int count) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XREVRANGE, new byte[][]{key, end, start, Protocol.Keyword.COUNT.getRaw(), Protocol.toByteArray((int)count)});
    }

    @Deprecated
    public void xread(int count, long block, Map<byte[], byte[]> streams) {
        byte[][] params = new byte[3 + streams.size() * 2 + (block > 0L ? 2 : 0)][];
        int streamsIndex = 0;
        params[streamsIndex++] = Protocol.Keyword.COUNT.getRaw();
        params[streamsIndex++] = Protocol.toByteArray((int)count);
        if (block > 0L) {
            params[streamsIndex++] = Protocol.Keyword.BLOCK.getRaw();
            params[streamsIndex++] = Protocol.toByteArray((long)block);
        }
        params[streamsIndex++] = Protocol.Keyword.STREAMS.getRaw();
        int idsIndex = streamsIndex + streams.size();
        for (Map.Entry<byte[], byte[]> entry : streams.entrySet()) {
            params[streamsIndex++] = entry.getKey();
            params[idsIndex++] = entry.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREAD, params);
    }

    public void xread(XReadParams params, Map.Entry<byte[], byte[]> ... streams) {
        byte[][] bparams = params.getByteParams();
        int paramLength = bparams.length;
        byte[][] args = new byte[paramLength + 1 + streams.length * 2][];
        System.arraycopy(bparams, 0, args, 0, paramLength);
        args[paramLength] = Protocol.Keyword.STREAMS.raw;
        int keyIndex = paramLength + 1;
        int idsIndex = keyIndex + streams.length;
        for (Map.Entry<byte[], byte[]> entry : streams) {
            args[keyIndex++] = entry.getKey();
            args[idsIndex++] = entry.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREAD, args);
    }

    public void xack(byte[] key, byte[] group, byte[] ... ids) {
        byte[][] params = new byte[2 + ids.length][];
        int index = 0;
        params[index++] = key;
        params[index++] = group;
        for (byte[] id : ids) {
            params[index++] = id;
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XACK, params);
    }

    public void xgroupCreate(byte[] key, byte[] groupname, byte[] id, boolean makeStream) {
        if (makeStream) {
            this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, new byte[][]{Protocol.Keyword.CREATE.getRaw(), key, groupname, id, Protocol.Keyword.MKSTREAM.getRaw()});
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, new byte[][]{Protocol.Keyword.CREATE.getRaw(), key, groupname, id});
        }
    }

    public void xgroupSetID(byte[] key, byte[] groupname, byte[] id) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, new byte[][]{Protocol.Keyword.SETID.getRaw(), key, groupname, id});
    }

    public void xgroupDestroy(byte[] key, byte[] groupname) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, new byte[][]{Protocol.Keyword.DESTROY.getRaw(), key, groupname});
    }

    public void xgroupDelConsumer(byte[] key, byte[] groupname, byte[] consumerName) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XGROUP, new byte[][]{Protocol.Keyword.DELCONSUMER.getRaw(), key, groupname, consumerName});
    }

    public void xdel(byte[] key, byte[] ... ids) {
        byte[][] params = new byte[1 + ids.length][];
        int index = 0;
        params[index++] = key;
        for (byte[] id : ids) {
            params[index++] = id;
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XDEL, params);
    }

    public void xtrim(byte[] key, long maxLen, boolean approximateLength) {
        if (approximateLength) {
            this.sendCommand((ProtocolCommand)Protocol.Command.XTRIM, new byte[][]{key, Protocol.Keyword.MAXLEN.getRaw(), Protocol.BYTES_TILDE, Protocol.toByteArray((long)maxLen)});
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.XTRIM, new byte[][]{key, Protocol.Keyword.MAXLEN.getRaw(), Protocol.toByteArray((long)maxLen)});
        }
    }

    public void xtrim(byte[] key, XTrimParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XTRIM, params.getByteParams(key, (byte[][])new byte[0][]));
    }

    @Deprecated
    public void xreadGroup(byte[] groupname, byte[] consumer, int count, long block, boolean noAck, Map<byte[], byte[]> streams) {
        int optional = 0;
        if (count > 0) {
            optional += 2;
        }
        if (block > 0L) {
            optional += 2;
        }
        if (noAck) {
            ++optional;
        }
        byte[][] params = new byte[4 + optional + streams.size() * 2][];
        int streamsIndex = 0;
        params[streamsIndex++] = Protocol.Keyword.GROUP.getRaw();
        params[streamsIndex++] = groupname;
        params[streamsIndex++] = consumer;
        if (count > 0) {
            params[streamsIndex++] = Protocol.Keyword.COUNT.getRaw();
            params[streamsIndex++] = Protocol.toByteArray((int)count);
        }
        if (block > 0L) {
            params[streamsIndex++] = Protocol.Keyword.BLOCK.getRaw();
            params[streamsIndex++] = Protocol.toByteArray((long)block);
        }
        if (noAck) {
            params[streamsIndex++] = Protocol.Keyword.NOACK.getRaw();
        }
        params[streamsIndex++] = Protocol.Keyword.STREAMS.getRaw();
        int idsIndex = streamsIndex + streams.size();
        for (Map.Entry<byte[], byte[]> entry : streams.entrySet()) {
            params[streamsIndex++] = entry.getKey();
            params[idsIndex++] = entry.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREADGROUP, params);
    }

    public void xreadGroup(byte[] groupname, byte[] consumer, XReadGroupParams params, Map.Entry<byte[], byte[]> ... streams) {
        byte[][] bparams = params.getByteParams();
        int paramLength = bparams.length;
        byte[][] args = new byte[3 + paramLength + 1 + streams.length * 2][];
        int index = 0;
        args[index++] = Protocol.Keyword.GROUP.raw;
        args[index++] = groupname;
        args[index++] = consumer;
        System.arraycopy(bparams, 0, args, index, paramLength);
        index += paramLength;
        args[index++] = Protocol.Keyword.STREAMS.raw;
        int keyIndex = index;
        int idsIndex = keyIndex + streams.length;
        for (Map.Entry<byte[], byte[]> entry : streams) {
            args[keyIndex++] = entry.getKey();
            args[idsIndex++] = entry.getValue();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XREADGROUP, args);
    }

    public void xpending(byte[] key, byte[] groupname) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XPENDING, new byte[][]{key, groupname});
    }

    public void xpending(byte[] key, byte[] groupname, byte[] start, byte[] end, int count, byte[] consumername) {
        if (consumername == null) {
            this.sendCommand((ProtocolCommand)Protocol.Command.XPENDING, new byte[][]{key, groupname, start, end, Protocol.toByteArray((int)count)});
        } else {
            this.sendCommand((ProtocolCommand)Protocol.Command.XPENDING, new byte[][]{key, groupname, start, end, Protocol.toByteArray((int)count), consumername});
        }
    }

    public void xpending(byte[] key, byte[] groupname, XPendingParams params) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XPENDING, this.joinParameters(key, groupname, params.getByteParams()));
    }

    public void xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, long newIdleTime, int retries, boolean force, byte[][] ids) {
        ArrayList<byte[]> arguments = new ArrayList<byte[]>(10 + ids.length);
        arguments.add(key);
        arguments.add(groupname);
        arguments.add(consumername);
        arguments.add(Protocol.toByteArray((long)minIdleTime));
        Collections.addAll(arguments, ids);
        if (newIdleTime > 0L) {
            arguments.add(Protocol.Keyword.IDLE.getRaw());
            arguments.add(Protocol.toByteArray((long)newIdleTime));
        }
        if (retries > 0) {
            arguments.add(Protocol.Keyword.RETRYCOUNT.getRaw());
            arguments.add(Protocol.toByteArray((int)retries));
        }
        if (force) {
            arguments.add(Protocol.Keyword.FORCE.getRaw());
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XCLAIM, (byte[][])arguments.toArray((T[])new byte[arguments.size()][]));
    }

    private void xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, XClaimParams params, byte[][] ids, boolean justId) {
        byte[][] bparams = params.getByteParams();
        int paramLength = bparams.length;
        int idsLength = ids.length;
        byte[][] args = new byte[4 + paramLength + idsLength + (justId ? 1 : 0)][];
        int index = 0;
        args[index++] = key;
        args[index++] = groupname;
        args[index++] = consumername;
        args[index++] = Protocol.toByteArray((long)minIdleTime);
        System.arraycopy(ids, 0, args, index, idsLength);
        System.arraycopy(bparams, 0, args, index += idsLength, paramLength);
        index += paramLength;
        if (justId) {
            args[index++] = Protocol.Keyword.JUSTID.getRaw();
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XCLAIM, args);
    }

    public void xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, XClaimParams params, byte[] ... ids) {
        this.xclaim(key, groupname, consumername, minIdleTime, params, ids, false);
    }

    public void xclaimJustId(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, XClaimParams params, byte[] ... ids) {
        this.xclaim(key, groupname, consumername, minIdleTime, params, ids, true);
    }

    public void xautoclaim(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        this.xautoclaim(key, groupName, consumerName, minIdleTime, start, params, false);
    }

    private void xautoclaim(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params, boolean justId) {
        ArrayList<byte[]> arguments = new ArrayList<byte[]>();
        arguments.add(key);
        arguments.add(groupName);
        arguments.add(consumerName);
        arguments.add(Protocol.toByteArray((long)minIdleTime));
        arguments.add(start);
        Collections.addAll(arguments, params.getByteParams());
        if (justId) {
            arguments.add(Protocol.Keyword.JUSTID.getRaw());
        }
        this.sendCommand((ProtocolCommand)Protocol.Command.XAUTOCLAIM, (byte[][])arguments.toArray((T[])new byte[arguments.size()][]));
    }

    public void xautoclaimJustId(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        this.xautoclaim(key, groupName, consumerName, minIdleTime, start, params, true);
    }

    public void xinfoStream(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XINFO, new byte[][]{Protocol.Keyword.STREAM.getRaw(), key});
    }

    public void xinfoGroup(byte[] key) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XINFO, new byte[][]{Protocol.Keyword.GROUPS.getRaw(), key});
    }

    public void xinfoConsumers(byte[] key, byte[] group) {
        this.sendCommand((ProtocolCommand)Protocol.Command.XINFO, new byte[][]{Protocol.Keyword.CONSUMERS.getRaw(), key, group});
    }

    public static enum LIST_POSITION {
        BEFORE,
        AFTER;

        public final byte[] raw = SafeEncoder.encode((String)this.name());
    }
}

