/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.log;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.util.StringUtils;

public class DateUtil {
    public static final String DEFAULT_DATE = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_YYYY_MM_DD = "yyyy-MM-dd";

    public static String utcDateToString(String utcDate, String formate) throws ParseException {
        SimpleDateFormat df1 = new SimpleDateFormat(formate);
        return df1.format(DateUtil.utcDateToDate(utcDate, formate));
    }

    public static String utcDateToString(String utcDate) throws ParseException {
        if (StringUtils.isEmpty((String)utcDate)) {
            return null;
        }
        return DateUtil.utcDateToString(utcDate, DEFAULT_DATE);
    }

    public static Date utcDateToDate(String utcDate) throws ParseException {
        if (StringUtils.isEmpty((String)utcDate)) {
            return null;
        }
        return DateUtil.utcDateToDate(utcDate, DEFAULT_DATE);
    }

    public static Date utcDateToDate(String utcDate, String formate) throws ParseException {
        SimpleDateFormat dff = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return dff.parse(utcDate);
    }

    public static Date addHours(Date date, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, hours);
        date = cal.getTime();
        return date;
    }

    public static long getTimeMillis(String time) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE);
            SimpleDateFormat dayFormat = new SimpleDateFormat(DATE_YYYY_MM_DD);
            Date curDate = dateFormat.parse(dayFormat.format(new Date()) + " " + time);
            return curDate.getTime();
        }
        catch (ParseException e) {
            ExceptionLogger.error(DateUtil.class, "getTimeMillis ParseException error", e);
            return 0L;
        }
    }

    public static Date getNowDayBegin() {
        return DateUtil.getDayBegin(new Date());
    }

    public static Date getDayBegin(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        date = cal.getTime();
        return date;
    }

    public static Date addDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        date = cal.getTime();
        return date;
    }

    public static void main(String[] args) {
        System.out.println(11);
    }
}

