/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.log;

import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.elasticsearch.factory.ElasticSearchFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class StoreageHelper {
    public static final String indexName = "dts_monitor_" + Instance.getClusterName().toLowerCase();
    public static final String esType = "doc";
    private static RestHighLevelClient client = null;
    private static boolean ES_CLIENT_IS_INIT = false;

    public static RestHighLevelClient getRestClient() {
        return client;
    }

    private static boolean check() {
        try {
            GetAliasesRequest request = new GetAliasesRequest();
            client.indices().getAlias(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        return true;
    }

    public static boolean isEsClientIsInit() {
        return ES_CLIENT_IS_INIT;
    }

    private static void initClient() {
        String region = System.getProperty("dts.monitor.es.region", "dtsmonitor");
        client = ElasticSearchFactory.getEsClient((String)region);
    }

    @Deprecated
    public static DestinationRuleConfig getDestinationConfig(String businessType, String region, String destinationType, String entityNumber) {
        DestinationTransRule rule = new DestinationTransRule();
        rule.setBusinessType(businessType);
        rule.setRegion(region);
        rule.setType(DestinationType.getType(destinationType));
        DestinationRuleConfig config = DestinationRuleConfig.get(entityNumber, rule);
        return config;
    }

    static {
        try {
            StoreageHelper.initClient();
            StoreageHelper.check();
            ES_CLIENT_IS_INIT = true;
        }
        catch (Exception e) {
            ExceptionLogger.error(StoreageHelper.class, "DtsStatusESReporter init client error,will not report", e);
            System.setProperty("dts.status.report.type", "empty");
        }
    }
}

