/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.log.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.log.DateUtil;
import kd.bos.dts.log.DtsStatusQuery;
import kd.bos.dts.log.Pair;
import kd.bos.dts.log.StoreageHelper;
import kd.bos.dts.log.query.PageInfo;
import kd.bos.dts.log.query.SyncStatistics;
import kd.bos.dts.log.query.SyncStatusInfo;
import kd.bos.dts.storage.es.ESQuery;
import kd.bos.util.StringUtils;
import org.elasticsearch.common.util.CollectionUtils;

public class DtsStatusQueryImpl
implements DtsStatusQuery {
    private static DtsStatusQuery instance = new DtsStatusQueryImpl();
    private static final String INSERTTAG = "insert..";
    private static final String UPDATETAG = "update..";
    private static final String DELETETAG = "delete..";
    private ESQuery client = ESQuery.create(StoreageHelper.getRestClient(), StoreageHelper.indexName, "doc");
    private static final String[] DTSARR_INIT_ONLINE = new String[]{"initconfig", "online"};
    private static final String[] DTSARR_ENTITY_BUSINESSTYPE_DESTINATION = new String[]{"entity_number", "businesstype", "destination_type"};
    private static final String[] DTSARR_ENTITY_DESTINATION_REGION_STATUS_TIMESTAP_DELAY = new String[]{"entity_number", "destination_type", "region", "dts_status", "dts_timestap", "dts_delay", "dts_exception", "businesstype"};
    private static final String[] DTSARR_ENTITY_DESTINATION_REGION_STATUS_TIMESTAP_EXCEPTION_BUSINESSTYPE_ACCOUNT = new String[]{"entity_number", "destination_type", "region", "dts_status", "dts_timestap", "dts_exception", "businesstype", "dts_account"};
    private static final String[] DTSARR_SENDER_RECIVER_BEGININIT_FINISHINIT = new String[]{"config_sended", "config_recived", "config_begin_init", "config_finish_init", "config_init_exception"};
    private static final String[] DTSARR_DATASYNCED = new String[]{"data_synced"};
    private static final String[] DTSARR_DATASENDED = new String[]{"data_sended"};
    private static final String[] DTSARR_ONLINE = new String[]{"online"};
    private static final String[] DTSARR_EXCEPTION_EXCEPTIONINIT = new String[]{"exception", "exception_init"};
    private static final String[] DTSARR_ACCOUNT = new String[]{"dts_account"};
    private static final String[] DTSARR_OPTYPE_ENTITY_DESTINATION_REGION = new String[]{"dts_optype", "entity_number", "destination_type", "region"};
    private static final String[] DTSARR_TIMESTAP_ACCOUNT = new String[]{"dts_timestap", "dts_account"};
    private static final String[] DTSARR_ACCOUNT_OPTYPE = new String[]{"dts_account", "dts_optype"};
    private static final String[] SYNC_LOG = new String[]{"dts_timestap", "businesstype", "dts_optype", "dts_logtype", "dts_status", "dts_count", "dts_exception", "destination_type", "entity_number"};

    public static DtsStatusQuery getInstance() {
        return instance;
    }

    private DtsStatusQueryImpl() {
    }

    @Override
    public List<Map<String, Object>> getConfigStatusList() {
        StringBuilder where = this.getQueryFilterWithAccount(DTSARR_INIT_ONLINE, null, null);
        return this.client.searchConditionAndAgg(where.toString(), "dts_timestap", DTSARR_ENTITY_BUSINESSTYPE_DESTINATION);
    }

    private String getAccountId() {
        return RequestContext.get().getAccountId();
    }

    @Override
    public List<Map<String, String>> getStatusInfo(DestinationRuleConfig ruleconfig) {
        String[] selectfields = DTSARR_ENTITY_DESTINATION_REGION_STATUS_TIMESTAP_DELAY;
        StringBuilder where = this.getQueryFilterWithAccount(null, DTSARR_SENDER_RECIVER_BEGININIT_FINISHINIT, ruleconfig);
        List<Map<String, String>> result = this.client.searchCondition(selectfields, null, null, null, where.toString(), 0, 1000, "dts_timestap", "asc");
        return result;
    }

    @Override
    public List<SyncStatistics> queryCounts(int[] times, DestinationRuleConfig ruleconfig) {
        ArrayList<SyncStatistics> syncs = new ArrayList<SyncStatistics>(4);
        for (int time : times) {
            SyncStatistics synced = this.queryCount(time, ruleconfig, DTSARR_DATASYNCED, DTSARR_ONLINE);
            double avgDelay = this.queryAvg(time, ruleconfig);
            synced.setAvgDelay(avgDelay);
            synced.setSyncedTotal(synced.getTotal());
            SyncStatistics sended = this.queryCount(time, ruleconfig, DTSARR_DATASENDED, DTSARR_ONLINE);
            synced.setSendedTotal(sended.getTotal());
            syncs.add(synced);
        }
        return syncs;
    }

    @Override
    public Map<String, String> queryLastStatusInfo(DestinationRuleConfig ruleconfig) {
        String[] selectfields = DTSARR_ENTITY_DESTINATION_REGION_STATUS_TIMESTAP_DELAY;
        StringBuilder where = this.getQueryFilterWithAccount(DTSARR_ONLINE, null, ruleconfig);
        List<Map<String, String>> result = this.client.searchCondition(selectfields, null, null, null, where.toString(), 0, 1, "dts_timestap", "desc");
        SyncStatistics syncStatistics = this.queryCount(60, ruleconfig, DTSARR_DATASYNCED, DTSARR_ONLINE);
        if (result.isEmpty()) {
            HashMap<String, String> mp = new HashMap<String, String>(1);
            mp.put("dts_count", String.valueOf(syncStatistics.getTotal()));
            mp.put("dts_status", "working");
            return mp;
        }
        Map<String, String> mp = result.get(0);
        mp.put("dts_count", String.valueOf(syncStatistics.getTotal()));
        mp.put("dts_status", "working");
        return mp;
    }

    @Override
    public List<Map<String, String>> queryStatusExceptionList() {
        String[] selectfields = DTSARR_ENTITY_DESTINATION_REGION_STATUS_TIMESTAP_EXCEPTION_BUSINESSTYPE_ACCOUNT;
        StringBuilder where = null;
        where = RequestContext.get() == null ? this.getQueryFilterNoAccount(DTSARR_EXCEPTION_EXCEPTIONINIT, null, null) : this.getQueryFilterWithAccount(DTSARR_EXCEPTION_EXCEPTIONINIT, null, null);
        List<Map<String, String>> maps = this.client.searchCondition(selectfields, where.toString(), 0, 1000);
        return maps;
    }

    @Override
    public List<Map<String, String>> queryCountsGroupByAccount(String accountId, Date fromDate, Date toDate) {
        ArrayList<Map<String, String>> retMap = new ArrayList<Map<String, String>>(4);
        String[] aggNames = DTSARR_ACCOUNT;
        StringBuilder where = this.getQueryFilter(accountId, null, DTSARR_DATASENDED, null);
        Map<String, Long> m1 = this.client.searchAgg(aggNames, "dts_count", fromDate, toDate, where.toString());
        where.setLength(0);
        where = this.getQueryFilter(accountId, null, DTSARR_DATASYNCED, null);
        Map<String, Long> m2 = this.client.searchAgg(aggNames, "dts_count", fromDate, toDate, where.toString());
        String[] selectFileds = DTSARR_TIMESTAP_ACCOUNT;
        String[] tpsAggs = DTSARR_ACCOUNT_OPTYPE;
        m1.forEach((k, v) -> {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("accountId", (String)k);
            map.put("syncedTotal", String.valueOf(m2.get(k)));
            map.put("sendedTotal", String.valueOf(v));
            StringBuilder queryFilter = this.getQueryFilter((String)k, null, null, null);
            List<Map<String, String>> maps = this.client.searchCondition(selectFileds, "dts_timestap", fromDate, toDate, queryFilter.toString(), 0, 1, "dts_timestap", "desc");
            if (maps != null && maps.size() > 0) {
                Map<String, String> timeMap = maps.get(0);
                map.put("timestamp", timeMap.get("dts_timestap"));
            }
            this.setStatusFilter(queryFilter, DTSARR_DATASYNCED);
            Map<String, Long> m3 = this.client.searchAgg(tpsAggs, "dts_count", fromDate, toDate, queryFilter.toString());
            m3.forEach((k1, v1) -> {
                if (k1.contains(INSERTTAG)) {
                    map.put("insert", v1.toString());
                } else if (k1.contains(UPDATETAG)) {
                    map.put("update", v1.toString());
                } else if (k1.contains(DELETETAG)) {
                    map.put("delete", v1.toString());
                }
            });
            retMap.add(map);
        });
        return retMap;
    }

    private void setConfigItemFilter(StringBuilder where, DestinationRuleConfig ruleconfig) {
        if (where.length() > 0) {
            where.append(" and ");
        }
        where.append("entity_number").append("='").append(ruleconfig.getEntityNumber()).append("'");
        where.append(" and ").append("destination_type").append("='").append(ruleconfig.getRule().getType().getName()).append("'");
        where.append(" and ").append("region").append("='").append(ruleconfig.getRule().getRegion()).append("'");
    }

    private void setStatusFilter(StringBuilder where, String[] statusStrs) {
        if (where.length() > 0) {
            where.append(" and ");
        }
        where.append("dts_status").append(" in ('");
        for (String status : statusStrs) {
            where.append(status).append("','");
        }
        where.setLength(where.length() - 2);
        where.append(")");
    }

    private void setLogTypeFilter(StringBuilder where, String[] logtypes) {
        if (where.length() > 0) {
            where.append(" and ");
        }
        where.append("dts_logtype").append(" in ('");
        for (String logtype : logtypes) {
            where.append(logtype).append("','");
        }
        where.setLength(where.length() - 2);
        where.append(")");
    }

    private void setAccountFilter(StringBuilder where, String accountId) {
        if (where.length() > 0) {
            where.append(" and ");
        }
        where.append("dts_account").append("='").append(StringUtils.isBlank((String)accountId) ? this.getAccountId() : accountId).append("'");
    }

    private void setEntityNumberFilter(StringBuilder where, String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        if (where.length() > 0) {
            where.append(" and ");
        }
        where.append("entity_number").append("='").append(entityNumber).append("'");
    }

    private void setBusinessTypeFilter(StringBuilder where, String businessType) {
        if (StringUtils.isEmpty((String)businessType)) {
            return;
        }
        if (where.length() > 0) {
            where.append(" and ");
        }
        where.append("businesstype").append("='").append(businessType).append("'");
    }

    private double queryAvg(int second, DestinationRuleConfig ruleconfig) {
        Pair<Date, Date> betweenTime = this.getBetweenTime(second);
        String[] aggNames = DTSARR_OPTYPE_ENTITY_DESTINATION_REGION;
        StringBuilder where = this.getQueryFilterWithAccount(DTSARR_ONLINE, null, ruleconfig);
        double avgDelay = this.client.searchAvg(aggNames, "dts_delay", betweenTime.getLeft(), betweenTime.getRight(), where.toString());
        return avgDelay;
    }

    private Pair<Date, Date> getBetweenTime(int second) {
        Date dateNow = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateNow);
        cal.add(13, -second);
        Date fromDate = cal.getTime();
        return new Pair<Date, Date>(DateUtil.addHours(fromDate, 8), DateUtil.addHours(dateNow, 8));
    }

    private StringBuilder getQueryFilterWithAccount(String[] logTypes, String[] statusStrs, DestinationRuleConfig ruleconfig) {
        return this.getQueryFilter(this.getAccountId(), logTypes, statusStrs, ruleconfig);
    }

    private StringBuilder getQueryFilterNoAccount(String[] logTypes, String[] statusStrs, DestinationRuleConfig ruleconfig) {
        return this.getQueryFilter(null, logTypes, statusStrs, ruleconfig);
    }

    private StringBuilder getQueryFilter(String accountId, String[] logTypes, String[] statusStrs, DestinationRuleConfig ruleconfig) {
        StringBuilder where = new StringBuilder();
        if (StringUtils.isNotEmpty((String)accountId)) {
            this.setAccountFilter(where, accountId);
        }
        if (!CollectionUtils.isEmpty((Object[])logTypes)) {
            this.setLogTypeFilter(where, logTypes);
        }
        if (ruleconfig != null) {
            this.setConfigItemFilter(where, ruleconfig);
        }
        if (!CollectionUtils.isEmpty((Object[])statusStrs)) {
            this.setStatusFilter(where, statusStrs);
        }
        return where;
    }

    private SyncStatistics queryCount(int second, DestinationRuleConfig ruleconfig, String[] statusStrs, String[] logTypes) {
        Pair<Date, Date> betweenTime = this.getBetweenTime(second);
        String[] aggNames = DTSARR_OPTYPE_ENTITY_DESTINATION_REGION;
        StringBuilder where = this.getQueryFilterWithAccount(logTypes, statusStrs, ruleconfig);
        SyncStatistics syncStatistics = new SyncStatistics();
        Map<String, Long> m1 = this.client.searchAgg(aggNames, "dts_count", betweenTime.getLeft(), betweenTime.getRight(), where.toString());
        m1.forEach((k, v) -> {
            if (k.contains(INSERTTAG)) {
                syncStatistics.addInsert(v.intValue());
            } else if (k.contains(UPDATETAG)) {
                syncStatistics.addUpdate(v.intValue());
            } else if (k.contains(DELETETAG)) {
                syncStatistics.addDelete(v.intValue());
            }
        });
        return syncStatistics;
    }

    @Override
    public PageInfo<Map<String, String>> queryStatusExceptionList(String account, String entityNumber, String businessType, Date fromDate, Date toDate, int page, int size) {
        String[] selectfields = DTSARR_ENTITY_DESTINATION_REGION_STATUS_TIMESTAP_EXCEPTION_BUSINESSTYPE_ACCOUNT;
        StringBuilder where = this.getQueryFilter(account, DTSARR_EXCEPTION_EXCEPTIONINIT, null, null);
        this.setEntityNumberFilter(where, entityNumber);
        this.setBusinessTypeFilter(where, businessType);
        PageInfo<Map<String, String>> pageInfo = this.client.searchConditionPage(selectfields, where.toString(), fromDate, toDate, page, size);
        return pageInfo;
    }

    @Override
    public List<Map<String, String>> querySyncLog(String entityNumber, String businessType) {
        StringBuilder where = this.getQueryFilter(this.getAccountId(), null, null, null);
        this.setEntityNumberFilter(where, entityNumber);
        this.setBusinessTypeFilter(where, businessType);
        List<Map<String, String>> result = this.client.searchCondition(SYNC_LOG, null, null, null, where.toString(), 0, 200, "dts_timestap", "desc");
        return result;
    }

    @Override
    public SyncStatusInfo queryLastSyncStatusInfo(String entityNumber, String businessType, String region, String destinationType) {
        String[] selectfields = DTSARR_ENTITY_DESTINATION_REGION_STATUS_TIMESTAP_DELAY;
        DestinationRuleConfig ruleConfig = StoreageHelper.getDestinationConfig(businessType, region, destinationType, entityNumber);
        StringBuilder where = this.getQueryFilterWithAccount(null, null, ruleConfig);
        List<Map<String, String>> result = this.client.searchCondition(selectfields, null, null, null, where.toString(), 0, 1, "dts_timestap", "desc");
        SyncStatusInfo syncStatusInfo = new SyncStatusInfo();
        if (result.isEmpty()) {
            return syncStatusInfo;
        }
        Map<String, String> map = result.get(0);
        syncStatusInfo.setBusinessType(map.get("businesstype"));
        syncStatusInfo.setDestinationType(map.get("destination_type"));
        syncStatusInfo.setEntityNumber(map.get("entity_number"));
        syncStatusInfo.setExceptionInfo(map.get("dts_exception"));
        syncStatusInfo.setRegion(map.get("region"));
        try {
            syncStatusInfo.setSyncDate(map.get(DateUtil.utcDateToString(map.get("dts_timestap"))));
        }
        catch (ParseException e) {
            ExceptionLogger.log(this.getClass(), "parse date error: " + ExceptionLogger.getStack(e));
        }
        syncStatusInfo.setSyncStatus("dts_status");
        return syncStatusInfo;
    }
}

