/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.storage.es;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class ESBatchStorage
implements Closeable {
    private RestHighLevelClient client;
    private static final String RETRY_ON_CONFLICT_KEY = "dts.fulltext.retryonconflict";
    private BulkRequest req = null;
    private BulkItemResponse lastFailureRes = null;
    private List<Object> failureIds = new ArrayList<Object>(0);

    private ESBatchStorage(RestHighLevelClient client) {
        this.client = client;
    }

    public static ESBatchStorage create(RestHighLevelClient client) {
        return new ESBatchStorage(client);
    }

    public void addUpsertBatch(String estype, String index, String id, Map<?, ?> map) {
        this.check();
        IndexRequest indexRequest = new IndexRequest(index, estype, id).source(map);
        UpdateRequest updateRequest = new UpdateRequest(index, estype, id).upsert(indexRequest);
        updateRequest.doc(indexRequest);
        updateRequest.retryOnConflict(Integer.parseInt(System.getProperty(RETRY_ON_CONFLICT_KEY, "5")));
        this.req.add(updateRequest);
    }

    public void addDeleteBatch(String estype, String index, String id) {
        this.check();
        DeleteRequest deleteRequest = new DeleteRequest(index, estype, id);
        this.req.add(deleteRequest);
    }

    public BulkItemResponse executeBatch(List<Object> failureIds) {
        BulkItemResponse fialeRes;
        if (this.req != null && this.req.numberOfActions() > 0 && (fialeRes = this.executeBulk(this.req)) != null) {
            this.lastFailureRes = fialeRes;
        }
        if (failureIds != null) {
            failureIds.addAll(this.failureIds);
        }
        return this.lastFailureRes;
    }

    private void check() {
        if (this.req == null) {
            this.req = this.createBulkRequest();
        }
        if (this.req.estimatedSizeInBytes() > 0x200000L) {
            BulkItemResponse fialeRes = this.executeBulk(this.req);
            if (fialeRes != null) {
                this.lastFailureRes = fialeRes;
            }
            this.req = this.createBulkRequest();
        }
    }

    private BulkRequest createBulkRequest() {
        BulkRequest req = new BulkRequest();
        req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        return req;
    }

    private BulkItemResponse executeBulk(BulkRequest req) {
        BulkItemResponse lastFailureRes = null;
        try {
            BulkResponse res = this.client.bulk(req, RequestOptions.DEFAULT);
            if (res.hasFailures()) {
                for (BulkItemResponse resp : res.getItems()) {
                    if (!resp.isFailed()) continue;
                    lastFailureRes = resp;
                    resp.getFailureMessage();
                    this.failureIds.add(resp.getId());
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.storageIO, new Object[]{"HighLevelAccess.applyRows error"});
        }
        return lastFailureRes;
    }

    @Override
    public void close() {
        this.req = null;
        this.failureIds.clear();
        this.lastFailureRes = null;
    }
}

