/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.codec;

import com.google.gson.Gson;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.serializer.HessianSerializer;

public class BaseCodec {
    private static final Map<String, Codec> codeceres = new ConcurrentHashMap<String, Codec>(2);

    public static <T> Codec<T> getCodecer(String type) {
        return codeceres.computeIfAbsent(type, k -> {
            if ("hex".equals(type)) {
                return new Codec<T>(){

                    @Override
                    public String encode(T object) {
                        return BaseCodec.toHex(HessianSerializer.serialize(object));
                    }

                    @Override
                    public T decode(String str) {
                        return HessianSerializer.deserialize(BaseCodec.fromHex(str));
                    }
                };
            }
            if ("gson".equals(type)) {
                return new Codec<T>(){

                    @Override
                    public String encode(Object object) {
                        return new Gson().toJson(object);
                    }

                    @Override
                    public T decode(String str) {
                        return new Gson().fromJson(str, Object.class);
                    }
                };
            }
            throw new RuntimeException(type + " not supported");
        });
    }

    private static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        return paddingLength > 0 ? String.format("%0" + paddingLength + "d", 0) + hex : hex;
    }

    public static interface Codec<T> {
        public String encode(T var1);

        public T decode(String var1) throws ClassNotFoundException;
    }
}

