/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.codec;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class TypeDefines {

    public static class DataCodecs {
        public static final String JAVAOBJ = "javaobj";
        public static final String JSON = "json";
    }

    public static class TransProtocolTypes {
        public static final String HTTP = "http";
        public static final String RPC = "rpc";
        public static final String TRANSPROTOCOLTYPEKEY = "transProtocolType";
        private static Map<String, String> cachedTransPortocols = new ConcurrentHashMap<String, String>(2);

        public static String getTransProtocolType(String properties) {
            return cachedTransPortocols.computeIfAbsent(properties, k -> {
                Properties p = new Properties();
                try {
                    p.load(new StringReader(properties));
                    String i = (String)p.get(TRANSPROTOCOLTYPEKEY);
                    return i == null ? RPC : i;
                }
                catch (IOException e) {
                    return "";
                }
            });
        }
    }
}

