/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.context;

import kd.bos.mservice.auth.api.AuthContext;
import kd.bos.mservice.auth.intercept.AuthServiceFactory;
import kd.bos.mservice.context.BaseContext;
import kd.bos.mservice.context.KdExternalRequestContext;

public class KdExternalContext
extends BaseContext {
    private static final long serialVersionUID = 7648165338206818236L;
    private static final ThreadLocal<KdExternalContext> current = new ThreadLocal();
    private KdExternalRequestContext externalRequestContext;
    private AuthContext authContext;

    private KdExternalContext() {
        BaseContext.set(this);
    }

    private static KdExternalContext create(boolean setCurrent) {
        KdExternalContext context = new KdExternalContext();
        if (setCurrent) {
            KdExternalContext.set(context);
        }
        return context;
    }

    public static KdExternalContext create(String tenantId, String accountId, String userId) {
        return KdExternalContext.create(tenantId, accountId, userId, true);
    }

    public static KdExternalContext create(String tenantId, String accountId, String userId, boolean isCreateAuthContext) {
        KdExternalContext kdExternalContext = KdExternalContext.create(true);
        KdExternalRequestContext requestContext = KdExternalRequestContext.create(tenantId, accountId, userId);
        kdExternalContext.setExternalRequestContext(requestContext);
        if (isCreateAuthContext) {
            kdExternalContext.setAuthContext(AuthServiceFactory.createAuthContext((String)tenantId, (String)accountId, (String)userId));
        }
        return kdExternalContext;
    }

    public KdExternalRequestContext getExternalRequestContext() {
        return this.externalRequestContext;
    }

    public void setExternalRequestContext(KdExternalRequestContext externalRequestContext) {
        this.externalRequestContext = externalRequestContext;
    }

    public static KdExternalContext get() {
        return current.get();
    }

    public static void set(KdExternalContext rc) {
        BaseContext.set(rc);
        current.set(rc);
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(AuthContext authContext) {
        this.authContext = authContext;
    }

    public static void remove() {
        BaseContext.remove();
        current.remove();
    }
}

