/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.sdk.bundle;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class SdkResources {
    private static final ResourceBundle NONEXISTENT_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        public String toString() {
            return "NONEXISTENT_BUNDLE";
        }
    };
    private static final Map<String, ResourceBundle> bundleMap = new ConcurrentHashMap<String, ResourceBundle>();

    public static String get(String project, String key, String desc, Object ... args) {
        return SdkResources.get(Locale.SIMPLIFIED_CHINESE, project, key, desc, args);
    }

    public static String get(Locale locale, String project, String key, String desc, Object ... args) {
        String resource = project + '_' + locale.toString();
        ResourceBundle bundle = bundleMap.get(resource);
        if (bundle == null) {
            bundle = bundleMap.computeIfAbsent(resource, k -> {
                try {
                    return ResourceBundle.getBundle("resources/" + project, locale);
                }
                catch (MissingResourceException e) {
                    return NONEXISTENT_BUNDLE;
                }
            });
        }
        if (bundle == NONEXISTENT_BUNDLE) {
            if (desc == null) {
                return SdkResources.missBundle(key);
            }
            return SdkResources.format(SdkResources.missBundle(desc), args);
        }
        String s = null;
        try {
            s = bundle.getString(key);
            return SdkResources.format(new String(s.getBytes("ISO8859-1"), "UTF-8"), args);
        }
        catch (UnsupportedEncodingException e) {
            return SdkResources.format(s, args);
        }
        catch (MissingResourceException e) {
            if (desc == null) {
                return SdkResources.missBundleKey(key);
            }
            return SdkResources.format(SdkResources.missBundleKey(desc), args);
        }
    }

    public static String format(String s, Object ... args) {
        if (args != null && args.length > 0) {
            try {
                if (s.contains("%s") || s.contains("%1s") || s.contains("%1$s")) {
                    return String.format(s, args);
                }
                return MessageFormat.format(s, args);
            }
            catch (Exception e) {
                return s + ':' + Arrays.toString(args);
            }
        }
        return s;
    }

    public static String missBundle(String key) {
        return Boolean.getBoolean("lang.miss.mark") ? "!" + key : key;
    }

    public static String missBundleKey(String key) {
        return Boolean.getBoolean("lang.miss.mark") ? "!!" + key : key;
    }
}

