/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.sdk.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import kd.bos.mservice.sdk.util.SdkSystemProperties;

public class SdkNetAddressUtils {
    public static final String OS_NAME = SdkNetAddressUtils.getSystemProperty("os.name");
    public static final boolean IS_OS_WINDOWS = SdkNetAddressUtils.getOsMatchesName("Windows");
    private static final boolean isPreferIPv6 = Boolean.parseBoolean(SdkSystemProperties.getWithEnv("java.net.preferIPv6Addresses"));
    private static volatile String sLocalIP;
    private static String sLocalHostName;
    private static InetAddress inet4Address;
    private static InetAddress inet6Address;

    private static synchronized void init() {
        if (isPreferIPv6 ? inet6Address != null : inet4Address != null) {
            return;
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            if (!IS_OS_WINDOWS) {
                ArrayList<NetworkInterface> netIFs = Collections.list(networkInterfaces);
                Collections.reverse(netIFs);
                networkInterfaces = Collections.enumeration(netIFs);
            }
            block2: while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                if (!SdkNetAddressUtils.isValidNI(ni)) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (isPreferIPv6) {
                        if (!SdkNetAddressUtils.isValidV6Address(address)) continue;
                        inet6Address = address;
                        continue block2;
                    }
                    if (!SdkNetAddressUtils.isValidV4Address(address)) continue;
                    inet4Address = address;
                    continue block2;
                }
            }
            if (isPreferIPv6) {
                int delim;
                if (inet6Address == null) {
                    inet6Address = InetAddress.getLocalHost();
                }
                sLocalIP = (delim = (sLocalIP = inet6Address.getHostAddress()).indexOf(37)) < 0 ? sLocalIP : sLocalIP.substring(0, delim);
                sLocalHostName = inet6Address.getHostName();
            } else {
                if (inet4Address == null) {
                    inet4Address = InetAddress.getLocalHost();
                }
                sLocalIP = inet4Address.getHostAddress();
                sLocalHostName = inet4Address.getHostName();
            }
        }
        catch (IOException e) {
            throw new Error("Can't get ip address.", e);
        }
    }

    public static boolean isPreferIPv6() {
        return isPreferIPv6;
    }

    public static String getLocalIpAddress() {
        if (sLocalIP != null) {
            return sLocalIP;
        }
        SdkNetAddressUtils.init();
        return sLocalIP;
    }

    public static synchronized String getLocalHostName() {
        SdkNetAddressUtils.init();
        return sLocalHostName;
    }

    private static boolean isValidNI(NetworkInterface ni) throws SocketException {
        return !ni.isLoopback() && ni.isUp() && !ni.getName().startsWith("docker");
    }

    private static boolean isValidV4Address(InetAddress address) throws IOException {
        return !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && address instanceof Inet4Address;
    }

    private static boolean isValidV6Address(InetAddress address) throws IOException {
        return !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isMulticastAddress() && address instanceof Inet6Address;
    }

    public static boolean isAvailable(int port) throws UnknownHostException {
        return !SdkNetAddressUtils.isPortUsed(InetAddress.getLocalHost().getHostAddress(), port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortUsed(String host, int port) {
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(host, port), 100);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int getAvailablePort(int startPort) throws IOException {
        for (int i = startPort; i < 65535; ++i) {
            if (!SdkNetAddressUtils.isAvailable(i)) continue;
            return i;
        }
        throw new IOException("Can't not find available port from " + startPort);
    }

    public static String getBindedHostIP() {
        String ip = System.getProperty("server.bind.ip", "0.0.0.0");
        if (ip != null && ip.length() > 0) {
            return ip;
        }
        return SdkNetAddressUtils.getLocalIpAddress();
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return SdkNetAddressUtils.isOSNameMatch(OS_NAME, osNamePrefix);
    }

    private static boolean isOSNameMatch(String osName, String osNamePrefix) {
        return osName != null && osName.startsWith(osNamePrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException var2) {
            return null;
        }
    }
}

