/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.config.impl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kd.bos.ha.config.AbstractJsonParse;
import kd.bos.ha.config.HaConfig;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.server.WatchServer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.core.MetricReporter;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class HaMcConfig
implements HaConfig {
    public static final String FALSE_STR = "false";
    private static boolean enabled = false;
    private static int interval = 15;
    private static List<Alarm> alarmList = null;
    private static Log logger = LogFactory.getLog(HaMcConfig.class);

    public HaMcConfig() {
        try {
            HaMcConfig.initHaWatchMonitorListener();
            HaMcConfig.initHaWatchMonitor();
            HaMcConfig.initAlarmConfigListener();
            HaMcConfig.initAlarmList();
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    @Override
    public boolean isEnable() {
        return enabled;
    }

    @Override
    public int getInterval() {
        return interval;
    }

    @Override
    public List<Alarm> getAlarmList() {
        return alarmList;
    }

    private static void initHaWatchMonitorListener() {
        ConfigurationUtil.observeChange((String)"ha.watch.monitor", (key, newValue) -> {
            if (!AbstractJsonParse.isMCInitialized()) {
                HaMcConfig.initHaWatchMonitor();
                if (enabled) {
                    WatchServer.getInstance().start();
                    MetricReporter.startHAWatch();
                } else {
                    WatchServer.getInstance().stop();
                    MetricReporter.stopHAWatch();
                }
            }
        });
    }

    private static void initHaWatchMonitor() {
        String config = System.getProperty("ha.watch.monitor");
        try {
            if (config == null) {
                return;
            }
            Properties props = new Properties();
            props.load(new StringReader(config));
            interval = Integer.parseInt(props.getProperty("interval", "15"));
            if (interval <= 10) {
                interval = 10;
            }
            enabled = Boolean.parseBoolean(props.getProperty("enable", FALSE_STR));
        }
        catch (Exception ex) {
            logger.error("ha.watch.monitor configure error:" + ex.getMessage());
        }
    }

    private static void initAlarmConfigListener() {
        ConfigurationUtil.observeChange((String)"ha.watch.alarmlist", (key, newValue) -> {
            if (!AbstractJsonParse.isMCInitialized()) {
                HaMcConfig.initAlarmList();
                WatchServer.getInstance().getMetaStore().reloadMetaData();
            }
        });
        ConfigurationUtil.observeChange((String)"ha.watch.actionlist", (key, newValue) -> {
            if (!AbstractJsonParse.isMCInitialized()) {
                HaMcConfig.initAlarmList();
                WatchServer.getInstance().getMetaStore().reloadMetaData();
            }
        });
    }

    static void initAlarmList() {
        String alarmJson = System.getProperty("ha.watch.alarmlist");
        String actionListJson = System.getProperty("ha.watch.actionlist");
        if (StringUtils.isEmpty((String)alarmJson)) {
            alarmList = new ArrayList<Alarm>(0);
        }
        try {
            alarmList = AbstractJsonParse.jsonToAlarmList(alarmJson, actionListJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

