/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.eye.util.ApiResponse;
import kd.bos.ha.http.service.api.ServiceStatusManage;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.util.JSONUtils;

public class CanStopk8sServiceHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(CanStopk8sServiceHandler.class);

    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            List<Map<String, Object>> serviceStatus = ServiceStatusManage.getServiceStatus();
            boolean canStop = true;
            if (serviceStatus != null && serviceStatus.size() > 0) {
                for (Map<String, Object> status : serviceStatus) {
                    Object count = status.get("activeThread");
                    if (count == null || "0".equals(count.toString())) continue;
                    canStop = false;
                    break;
                }
            }
            response.setCode(Integer.valueOf(canStop ? 0 : 1));
        }
        catch (Exception e) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg(e.getMessage());
            logger.error("Get service status error", (Throwable)e);
        }
        response.setData(Collections.emptyMap());
        String ret = JSONUtils.toString((Object)response);
        this.writeJson(ret, exchange);
    }
}

