/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.ha.enterprise.LangRes;
import kd.bos.ha.http.service.api.ServiceStatusManage;
import kd.bos.ha.http.service.api.gracefulrestart.GracefulRestartManager;
import kd.bos.ha.http.service.api.gracefulrestart.vo.GracefulRestartForm;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.EnvUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;

public class GracefulRestartHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(GracefulRestartHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    protected void handle0(HttpExchange exchange) throws IOException {
        HashMap<String, Object> response = new HashMap<String, Object>(2);
        try {
            int customWaitTime;
            String action;
            if (!EnvUtils.isRunningInsideContainer()) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"The service can only be restarted in a container environment!!"});
            }
            GracefulRestartForm gracefulRestartForm = (GracefulRestartForm)ExchangeVueUtils.parseJsonFromPost((HttpExchange)exchange, GracefulRestartForm.class);
            if (gracefulRestartForm == null) {
                Map params = ExchangeVueUtils.parseParameters((HttpExchange)exchange);
                action = (String)params.get("action");
                customWaitTime = 2147483;
            } else {
                action = gracefulRestartForm.getAction();
                customWaitTime = gracefulRestartForm.getCustomWaitTime();
            }
            if ("rollingRestart".equals(action)) {
                CharSequence[] appNameArr = null;
                if (gracefulRestartForm != null) {
                    appNameArr = gracefulRestartForm.getSelectAppNames();
                }
                if (appNameArr == null || appNameArr.length == 0) {
                    throw new KDException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6eda\u52a8\u91cd\u542f\u7684\u670d\u52a1", (String)"GracefulRestartHandler_0", (String)"bos-ha", (Object[])new Object[0]));
                }
                for (String string : appNameArr) {
                    GracefulRestartManager.checkIsWebNode(string);
                }
                log.info("\u6eda\u52a8\u91cd\u542f-\u901a\u8fc7Monitor\u9875\u9762\u624b\u52a8\u5f00\u59cb\u6eda\u52a8\u91cd\u542f,\u91cd\u542f\u7684\u670d\u52a1\u5305\u62ec\uff1a" + String.join((CharSequence)",", appNameArr));
                GracefulRestartManager.toRestart(gracefulRestartForm);
                OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get("GracefulRestartHandler_1", "Rolling Restart", new Object[0]), LangRes.get("GracefulRestartHandler_2", "Calling Rolling Restart Interface to Restart Services, Including: {0}", String.join((CharSequence)",", appNameArr)));
            } else if ("singleRestart".equals(action)) {
                log.info("\u6eda\u52a8\u91cd\u542f-\u5f53\u524d\u8282\u70b9\u63a5\u6536\u5230\u6eda\u52a8\u91cd\u542f\u547d\u4ee4\u5f00\u59cb\u91cd\u542f...");
                String ip = NetAddressUtils.getLocalIpAddress();
                OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get("ServiceHandler_1", "Service Management", new Object[0]), LangRes.get("ServiceHandler_2", "Gracefully Restarted Service on Node [{0}]", ip));
                GracefulRestartManager.singleNodeGracefulRestart(customWaitTime);
            }
            response.put("data", ServiceStatusManage.getServiceStatus());
            response.put("status", Instance.isPausedServiceByMonitor());
            response.put("code", 0);
        }
        catch (Exception e) {
            log.error("\u6eda\u52a8\u91cd\u542f\u5f02\u5e38\uff1a ", (Throwable)e);
            response.put("code", -1);
            response.put("msg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }
}

