/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.http.service.api.gracefulrestart;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.proxy.EyeProxyHandler;
import kd.bos.eye.util.EyeHttpClients;
import kd.bos.ha.http.service.api.GracefulRestartHandler;
import kd.bos.ha.http.service.api.ServiceStatusManage;
import kd.bos.ha.http.service.api.gracefulrestart.enums.ParallelType;
import kd.bos.ha.http.service.api.gracefulrestart.strategy.RestartStrategyFactory;
import kd.bos.ha.http.service.api.gracefulrestart.vo.GracefulRestartForm;
import kd.bos.ha.manager.ServerManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;

public class GracefulRestartManager {
    private static final Log log = LogFactory.getLog(GracefulRestartHandler.class);
    private static final String maxPoolCount = System.getProperty("monitor.graceful.pool.appname.max.count", "10");
    private static final ThreadPool pool = ThreadPools.newCachedThreadPool((String)"MonitorGracefulRestartAppName", (int)0, (int)Integer.parseInt(maxPoolCount));

    public static void toRestart(GracefulRestartForm gracefulRestartForm) {
        String[] tempAppNameArr = null;
        if (gracefulRestartForm != null) {
            tempAppNameArr = gracefulRestartForm.getSelectAppNames();
        }
        if (tempAppNameArr == null || tempAppNameArr.length == 0) {
            throw new KDException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6eda\u52a8\u91cd\u542f\u7684\u670d\u52a1", (String)"GracefulRestartHandler_0", (String)"bos-ha", (Object[])new Object[0]));
        }
        ThreadPools.executeOnce((String)"MonitorScrollRestart-toRestart", () -> {
            String[] appNameArr;
            for (String appName : appNameArr = gracefulRestartForm.getSelectAppNames()) {
                List<ServiceInfo> currentAppNameList = GracefulRestartManager.getAppNameList(appName);
                if (currentAppNameList == null || currentAppNameList.size() == 0) {
                    log.warn("\u6eda\u52a8\u91cd\u542f-\u670d\u52a1{}\u4e0d\u5b58\u5728\u6216\u670d\u52a1\u5df2\u7ecf\u4e0b\u7ebf", (Object)appName);
                    continue;
                }
                if (ServiceStatusManage.isRollingRestarting(appName, true)) {
                    log.warn(ResManager.loadKDString((String)String.format("\u6eda\u52a8\u91cd\u542f-%s :\u6b63\u5728\u6eda\u52a8\u91cd\u542f\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u9009\u62e9...", appName), (String)"GracefulRestartManager_1", (String)"bos-ha", (Object[])new Object[0]));
                    continue;
                }
                GracefulRestartManager.handleRestart(pool, appName, gracefulRestartForm);
            }
        });
    }

    private static void handleRestart(ThreadPool pool, String appName, GracefulRestartForm paramForm) {
        int parallelType = paramForm.getParallelType();
        pool.execute(() -> {
            List<List<ServiceInfo>> batchList = GracefulRestartManager.getBatch(appName, parallelType);
            RestartStrategyFactory.getRestartStrategy(paramForm).restart(batchList, paramForm);
        });
    }

    public static void toRestartAllServer(GracefulRestartForm gracefulRestartForm) {
        ArrayList<String> containsList = new ArrayList<String>();
        ArrayList<String> notContainsList = new ArrayList<String>();
        for (String s : gracefulRestartForm.getSelectAppNames()) {
            if (s.equals(Instance.getAppName())) {
                containsList.add(s);
                continue;
            }
            notContainsList.add(s);
        }
        if (containsList.size() > 0) {
            if (notContainsList.size() > 0) {
                gracefulRestartForm.setSelectAppNames(notContainsList.toArray(new String[0]));
                GracefulRestartManager.toRestart(gracefulRestartForm);
                ThreadPools.executeOnce((String)"ScrollRestart-WebServerRestarting", () -> {
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                        boolean isStop = false;
                        Long lastTime = System.currentTimeMillis();
                        while (!isStop && System.currentTimeMillis() - lastTime < 1200000L) {
                            List<String> list = ServiceStatusManage.getScrollRestartingServers();
                            if (list != null && list.size() > 0) {
                                TimeUnit.SECONDS.sleep(10L);
                                log.info("\u6eda\u52a8\u91cd\u542f-\u5f53\u524dweb\u8282\u70b9: {} \u5728\u7b49\u5f85\u5176\u4ed6\u670d\u52a1\u91cd\u542f....", (Object)Instance.getAppName());
                                continue;
                            }
                            isStop = true;
                            GracefulRestartManager.toRestartWebServer(gracefulRestartForm);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                });
            } else {
                GracefulRestartManager.toRestartWebServer(gracefulRestartForm);
            }
        } else if (notContainsList.size() > 0) {
            GracefulRestartManager.toRestart(gracefulRestartForm);
        }
    }

    private static void toRestartWebServer(GracefulRestartForm gracefulRestartForm) {
        List<ServiceInfo> webList = GracefulRestartManager.getAppNameList(Instance.getAppName());
        if (webList == null || webList.isEmpty()) {
            log.warn("\u6eda\u52a8\u91cd\u542f-\u4e0d\u5b58\u5728\u5f53\u524d\u5e94\u7528\u6216\u5f53\u524d\u5e94\u7528\u5df2\u7ecf\u4e0b\u7ebf");
            return;
        }
        for (ServiceInfo serviceInfo : webList) {
            if (Instance.getInstanceId().equals(serviceInfo.getInstanceId())) continue;
            GracefulRestartManager.toPostRestart(serviceInfo, 0);
        }
        log.info("\u6eda\u52a8\u91cd\u542f-\u5f53\u524dweb\u8282\u70b9: {} \u5f00\u59cb\u91cd\u542f...", (Object)Instance.getAppName());
        GracefulRestartManager.singleNodeGracefulRestart(0);
    }

    private static boolean toPostRestart(ServiceInfo serviceInfo, int getCustomWaitTime) {
        HashMap<String, String> proxyHeader = new HashMap<String, String>(1);
        proxyHeader.put(EyeProxyHandler.PROXY_HEADER_KEY, EyeProxyHandler.PROXY_HEADER_VALUE);
        String gracefulRestartUrl = GracefulRestartManager.getGracefulRestartUrl(serviceInfo.getHostIp(), serviceInfo.getHostMonitorPort());
        try {
            log.info("\u6eda\u52a8\u91cd\u542f-AppName: {} start rollingRestart,the url {}", (Object)serviceInfo.getAppName(), (Object)gracefulRestartUrl);
            GracefulRestartForm gracefulRestartForm = new GracefulRestartForm();
            gracefulRestartForm.setAction("singleRestart");
            gracefulRestartForm.setCustomWaitTime(getCustomWaitTime);
            String param = JSONUtils.toString((Object)gracefulRestartForm);
            EyeHttpClients.postjson((String)gracefulRestartUrl, proxyHeader, (String)param, (int)5000, (int)10000);
            return true;
        }
        catch (Exception e) {
            log.warn("\u6eda\u52a8\u91cd\u542f-Restart web,\u5b9e\u4f8b: {} start rollingRestart exception,the url {}", (Object)serviceInfo.getInstanceId(), (Object)gracefulRestartUrl);
            log.warn("\u6eda\u52a8\u91cd\u542f-Restart web,Start rollingRestart exception", (Throwable)e);
            return false;
        }
    }

    private static String getGracefulRestartUrl(String ip, String port) {
        return "http://" + ip + ":" + port + "/monitor/goldeye/gracefulRestart";
    }

    private static List<List<ServiceInfo>> getBatch(String appName, int parallelType) {
        ArrayList<List<ServiceInfo>> batchList = new ArrayList(1);
        List<ServiceInfo> currentAppNameList = GracefulRestartManager.getAppNameList(appName);
        ParallelType type = ParallelType.codeOfType(parallelType);
        int size = currentAppNameList.size();
        if (ParallelType.ONE == type) {
            batchList = Lists.partition(currentAppNameList, (int)1);
        } else if (ParallelType.HALF == type) {
            if (size == 1) {
                batchList.add(currentAppNameList);
                return batchList;
            }
            int firstBatch = size / 2;
            firstBatch = firstBatch < 1 ? 1 : firstBatch;
            List<ServiceInfo> firstList = currentAppNameList.subList(0, firstBatch);
            List<ServiceInfo> secondList = currentAppNameList.subList(firstBatch, size);
            batchList.add(firstList);
            batchList.add(secondList);
        } else if (ParallelType.ALL == type) {
            batchList.add(currentAppNameList);
        }
        return batchList;
    }

    public static void singleNodeGracefulRestart(int customWaitTime) {
        new Thread(() -> ServerManager.getManager().GracefulStopServer(customWaitTime), "MonitorSingleNodeGracefulRestartService").start();
    }

    public static void checkIsWebNode(String appName) {
        List<ServiceInfo> currentAppNameList = GracefulRestartManager.getAppNameList(appName);
        if (currentAppNameList == null || currentAppNameList.size() == 0) {
            log.warn("\u6eda\u52a8\u91cd\u542f-\u670d\u52a1{}\u4e0d\u5b58\u5728\u6216\u670d\u52a1\u5df2\u7ecf\u4e0b\u7ebf", (Object)appName);
            return;
        }
        if (currentAppNameList.get(0).isWebNode()) {
            throw new KDException(String.format(ResManager.loadKDString((String)"%s\u4e3aweb\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u6eda\u52a8\u91cd\u542f\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9.", (String)"GracefulRestartManager_3", (String)"bos-ha", (Object[])new Object[0]), appName));
        }
    }

    private static List<ServiceInfo> getAppNameList(String appName) {
        List serviceInfoList = ServiceInfoFactory.get().getServiceList();
        return serviceInfoList.stream().filter(serviceInfo -> serviceInfo.getAppName().equals(appName)).collect(Collectors.toList());
    }
}

