/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import kd.bos.eye.api.alarm.db.AlarmRecordDbHelper;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionResultEnum;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.NetAddressUtils;

public class MonitorRecordSpi
implements ActionSpi {
    private static Log logger = LogFactory.getLog(MonitorRecordSpi.class);

    @Override
    public String getType() {
        return "MonitorRecord";
    }

    @Override
    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm) {
        try {
            String ip = NetAddressUtils.getLocalIpAddress();
            String alarmName = alarm.getName();
            String metricName = alarm.getMetricName();
            String state = triggerData.getNewState().toString();
            String alarmMsg = SpiUtil.getAlarmMsgFromTemplate(triggerData, alarm, this.getType());
            AlarmRecordDbHelper.saveAlarmRecord((String)ip, (String)alarmName, (String)metricName, (String)state, (String)alarmMsg);
            return ActionExecResult.WithResult(ActionResultEnum.Success, alarmMsg);
        }
        catch (Exception e) {
            logger.error("MonitorRecordSpi execute error\uff1a", (Throwable)e);
            return ActionExecResult.WithResult(ActionResultEnum.Error, "HaWatch-Error exec MonitorRecord spi:" + e.getMessage());
        }
    }
}

