/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import java.io.IOException;
import kd.bos.ha.manager.ServerManager;
import kd.bos.ha.manager.ServerManagerImpl;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionResultEnum;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.EmailSpi;
import kd.bos.ha.watch.action.spi.ResumeServiceSpiConfig;
import kd.bos.ha.watch.action.spi.SmsSpi;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class ResumeServiceSpi
implements ActionSpi {
    private static Log logger = LogFactory.getLog(ResumeServiceSpi.class);

    @Override
    public String getType() {
        return "ResumeService";
    }

    @Override
    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm) {
        ResumeServiceSpiConfig spiConfig = null;
        try {
            spiConfig = this.getSpiConfig(action.getName(), action.getConfig());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return ActionExecResult.WithResult(ActionResultEnum.Error, e.getMessage());
        }
        try {
            String content = SpiUtil.GetAlarmMsgDesc(triggerData, alarm);
            logger.warn("[==HaWatch-ResumeServiceSpi executed!==] Action: [" + action.getName() + "], AlarmInfo:" + content);
            if (StringUtils.isNotEmpty((String)spiConfig.getPhone())) {
                SmsSpi smsSpi = new SmsSpi();
                smsSpi.execute(action, triggerData, alarm, Resources.getString((String)"ResumeService\uff0c\u539f\u56e0\uff1a", (String)"ResumeServiceSpi_0", (String)"bos-ha", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((String)spiConfig.getMail())) {
                EmailSpi emailSpi = new EmailSpi();
                emailSpi.execute(action, triggerData, alarm, Resources.getString((String)"\u89e6\u53d1StopService\uff0c\u539f\u56e0\uff1a", (String)"StopServiceSpi_0", (String)"bos-ha", (Object[])new Object[0]));
            }
            ServerManagerImpl serverManager = new ServerManagerImpl();
            ((ServerManager)serverManager).resumeServer();
            return ActionExecResult.WithResult(ActionResultEnum.Success, "");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String msg = "Error exec ResumeServiceSpi spi:" + e.getMessage();
            return ActionExecResult.WithResult(ActionResultEnum.Error, msg);
        }
    }

    private ResumeServiceSpiConfig getSpiConfig(String actionName, String configJson) {
        ResumeServiceSpiConfig apiConfig = null;
        if (StringUtils.isEmpty((String)configJson)) {
            throw new RuntimeException(Resources.getString((String)"ResumeServiceSpi-\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a,action is ", (String)"ResumeServiceSpi_1", (String)"bos-ha", (Object[])new Object[0]) + actionName);
        }
        try {
            apiConfig = (ResumeServiceSpiConfig)JSONUtils.cast((String)configJson, ResumeServiceSpiConfig.class, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("ResumeServiceSpi-Error reading json from action config, action is " + actionName, e);
        }
        return apiConfig;
    }
}

