/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import java.io.File;
import java.io.IOException;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionResultEnum;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.EmailSpi;
import kd.bos.ha.watch.action.spi.ShellSpiConfig;
import kd.bos.ha.watch.action.spi.SmsSpi;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.util.SmsUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellSpi
implements ActionSpi {
    private static Logger logger = LoggerFactory.getLogger(ShellSpi.class);

    @Override
    public String getType() {
        return "Shell";
    }

    @Override
    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm) {
        logger.info("Prepare the task execute of shell spi, action is : " + action.getName());
        String msg = "";
        ShellSpiConfig spiConfig = null;
        try {
            spiConfig = this.getShellConfig(action.getName(), action.getConfig());
        }
        catch (Exception e) {
            logger.error("Shell:" + e.getMessage());
            return ActionExecResult.WithResult(ActionResultEnum.Error, e.getMessage());
        }
        try {
            String msgContent = "HaWatch" + System.getProperty("line.separator") + SpiUtil.GetAlarmMsgDesc(triggerData, alarm, true, true);
            logger.warn("[==HaWatch-ShellSpi executed!==] Action: [" + action.getName() + "], AlarmInfo:" + msgContent);
            if (StringUtils.isNotEmpty((String)spiConfig.getPhone())) {
                SmsSpi smsSpi = new SmsSpi();
                smsSpi.execute(action, triggerData, alarm, Resources.getString((String)"PauseService\uff0c\u539f\u56e0\uff1a", (String)"ShellSpi_0", (String)"bos-ha", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((String)spiConfig.getMail())) {
                EmailSpi emailSpi = new EmailSpi();
                emailSpi.execute(action, triggerData, alarm, Resources.getString((String)"\u89e6\u53d1StopService\uff0c\u539f\u56e0\uff1a", (String)"StopServiceSpi_0", (String)"bos-ha", (Object[])new Object[0]));
            }
            String alarmJson = JSONUtils.toString((Object)alarm);
            String triggerDataJson = JSONUtils.toString((Object)triggerData);
            String execResult = SmsUtil.execShell(spiConfig.getShellCmd(), msgContent, alarmJson, triggerDataJson);
            if (execResult.length() > 500) {
                execResult = execResult.substring(0, 500);
            }
            logger.info("exec shell: " + spiConfig.getShellCmd() + ", alarm is : " + action.getAlarmName());
            return ActionExecResult.WithResult(ActionResultEnum.Success, execResult + " | " + msgContent);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            msg = "Error exec shell spi:" + e.getMessage();
            return ActionExecResult.WithResult(ActionResultEnum.Error, msg);
        }
    }

    private ShellSpiConfig getShellConfig(String actionName, String configJson) {
        ShellSpiConfig apiConfig = null;
        if (StringUtils.isEmpty((String)configJson)) {
            throw new RuntimeException(Resources.getString((String)"ShellSpi-\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a,action is ", (String)"ShellSpi_1", (String)"bos-ha", (Object[])new Object[0]) + actionName);
        }
        try {
            apiConfig = (ShellSpiConfig)JSONUtils.cast((String)configJson, ShellSpiConfig.class, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("ShellSpi-Error reading json from action config, action is " + actionName, e);
        }
        String shellCmd = apiConfig.getShellCmd();
        if (StringUtils.isEmpty((String)shellCmd)) {
            throw new RuntimeException("ShellSpi-Error reading from action config -ShellCmd cannot be empty, action is " + actionName);
        }
        File file = new File(shellCmd);
        if (!file.exists()) {
            throw new RuntimeException("Shell not exists:" + shellCmd);
        }
        return apiConfig;
    }
}

