/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.action.spi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.exception.KDException;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionResultEnum;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.action.spi.WebhookActionConfig;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class WebhookSpi
implements ActionSpi {
    public static final String CONTENT = "content";
    public static final String TEXT = "text";
    public static final String ERRCODE = "errcode";
    public static final String ZERO_STR = "0";
    private static final String YZJ_TYPE = "yzj";
    private static final String QYWX_TYPE = "qywx";
    private static final String DD_TYPE = "dd";
    public static final String MSGTYPE = "msgtype";
    private static Log logger = LogFactory.getLog(WebhookSpi.class);

    @Override
    public String getType() {
        return "Webhook";
    }

    @Override
    public ActionExecResult execute(Action action, ActionTriggerData triggerData, Alarm alarm) {
        try {
            WebhookActionConfig wac = this.getWebhookActionConfig(action.getName(), action.getConfig());
            String content = SpiUtil.getAlarmMsgFromTemplate(triggerData, alarm, this.getType());
            String webHookType = wac.getType();
            String webhookUrl = EncrypterFactory.getEncrypter().decode(wac.getUrl());
            if (YZJ_TYPE.equalsIgnoreCase(webHookType)) {
                this.sendMsgByYzj(webhookUrl, content);
            } else if (QYWX_TYPE.equalsIgnoreCase(webHookType)) {
                this.sendMsgByQywx(webhookUrl, content);
            } else if (DD_TYPE.equalsIgnoreCase(webHookType)) {
                this.sendMsgByDd(webhookUrl, content);
            } else {
                throw new KDException("unsupported webhookType " + webHookType + ",only supported yzj/qywx!");
            }
            return ActionExecResult.WithResult(ActionResultEnum.Success, content);
        }
        catch (Exception e) {
            logger.error("MonitorRecordSpi execute error\uff1a", (Throwable)e);
            return ActionExecResult.WithResult(ActionResultEnum.Error, "HaWatch-Error exec MonitorRecord spi:" + e.getMessage());
        }
    }

    private void sendMsgByDd(String webHookUrl, String content) throws IOException {
        JSONObject textObject = new JSONObject();
        textObject.put(CONTENT, (Object)content);
        JSONObject atObject = new JSONObject();
        atObject.put("isAtAll", (Object)true);
        HashMap<String, String> body = new HashMap<String, String>(16);
        body.put(MSGTYPE, TEXT);
        body.put(TEXT, (String)textObject);
        body.put("at", (String)atObject);
        String postJson = HttpClientUtils.postAppJson((String)webHookUrl, new HashMap(0), body);
        Map responseMap = (Map)JSONUtils.cast((String)postJson, Map.class);
        if (!ZERO_STR.equals(String.valueOf(responseMap.get(ERRCODE)))) {
            throw new KDException("SendMsg by dd webhook error!" + postJson);
        }
    }

    private void sendMsgByQywx(String webHookUrl, String content) throws IOException {
        JSONObject object = new JSONObject();
        object.put(CONTENT, (Object)content);
        JSONArray mobileArray = new JSONArray();
        mobileArray.add((Object)"@all");
        object.put("mentioned_mobile_list", (Object)mobileArray);
        HashMap<String, String> body = new HashMap<String, String>(16);
        body.put(MSGTYPE, TEXT);
        body.put(TEXT, (String)object);
        String postJson = HttpClientUtils.postjson((String)webHookUrl, new HashMap(0), (String)JSONUtils.toString(body));
        Map responseMap = (Map)JSONUtils.cast((String)postJson, Map.class);
        if (!ZERO_STR.equals(String.valueOf(responseMap.get(ERRCODE)))) {
            throw new KDException("SendMsg by qywx webhook error!" + postJson);
        }
    }

    private void sendMsgByYzj(String webHookUrl, String content) throws IOException {
        HashMap<String, String> body = new HashMap<String, String>(1);
        body.put(CONTENT, content + "@All");
        String postJson = HttpClientUtils.postjson((String)webHookUrl, new HashMap(0), (String)JSONUtils.toString(body));
        Map responseMap = (Map)JSONUtils.cast((String)postJson, Map.class);
        if (!"true".equals(String.valueOf(responseMap.get("success")))) {
            throw new KDException("SendMsg by yzj webhook error!" + postJson);
        }
    }

    private WebhookActionConfig getWebhookActionConfig(String actionName, String configJson) {
        WebhookActionConfig webhookActionConfig = null;
        if (StringUtils.isEmpty((String)configJson)) {
            throw new RuntimeException("HaWatch-WebhookSpi-config cannot be empty,action is " + actionName);
        }
        try {
            webhookActionConfig = (WebhookActionConfig)JSONUtils.cast((String)configJson, WebhookActionConfig.class, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("HaWatch-WebhookSpi-Error reading json from action config, action is " + actionName, e);
        }
        if (StringUtils.isEmpty((String)webhookActionConfig.getType()) || StringUtils.isEmpty((String)webhookActionConfig.getUrl())) {
            throw new RuntimeException("HaWatch-WebhookSpi-Error reading from action config - webhookType/webhookUrl name cannot be empty, action is " + actionName);
        }
        return webhookActionConfig;
    }
}

