/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.data;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.alarm.MetricData;
import kd.bos.ha.watch.alarm.Statistic;
import kd.bos.ha.watch.alarm.Unit;
import kd.bos.ha.watch.data.Datapoint;
import kd.bos.ha.watch.data.GetAlarmStatisticsRequest;
import kd.bos.ha.watch.data.GetMetricStatisticsRequest;
import kd.bos.ha.watch.data.MetricDataStore;
import kd.bos.ha.watch.server.WatchServer;
import kd.bos.ha.watch.util.CommonUtil;

public class MemMetricDataStore
implements MetricDataStore {
    private Cache<String, LinkedList<Datapoint>> metricDataList = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(600L, TimeUnit.SECONDS).build();
    private static final Map<String, Double> metricLastValueMap = new ConcurrentHashMap<String, Double>(8);

    @Override
    public void putData(MetricData metricData) {
        if (!this.getAlarmEnabled(metricData.getCategory(), metricData.getMetricName())) {
            return;
        }
        String cacheKey = this.getCacheKey(metricData.getCategory(), metricData.getMetricName());
        LinkedList datapoints = (LinkedList)this.metricDataList.getIfPresent((Object)cacheKey);
        if (datapoints == null) {
            datapoints = Lists.newLinkedList();
        }
        this.cleanExpiredMetricData(datapoints);
        Double value = this.convertMetricValueToCount(metricData);
        if (value > 0.0) {
            Map<String, String> dimensionValues = metricData.getDimensionValues();
            dimensionValues.put("metricType", metricData.getMetricType());
            Datapoint datapoint = new Datapoint(metricData.getTimestamp(), value, dimensionValues);
            datapoints.add(datapoint);
            this.metricDataList.put((Object)cacheKey, (Object)datapoints);
        }
    }

    private Double convertMetricValueToCount(MetricData metricData) {
        List<Alarm> alarms = WatchServer.getInstance().getMetaStore().getAlarms();
        if (alarms == null || alarms.size() == 0) {
            return 0.0;
        }
        if (!Gauge.class.getSimpleName().equals(metricData.getMetricType())) {
            for (Alarm alarm : alarms) {
                if (!alarm.getMetricName().equals(metricData.getMetricName()) || alarm.getUnit() != Unit.Count) continue;
                Double lastValue = metricLastValueMap.get(metricData.getMetricName());
                double val = lastValue == null ? 0.0 : lastValue;
                metricLastValueMap.put(metricData.getMetricName(), metricData.getValue());
                return metricData.getValue() - val;
            }
        }
        return metricData.getValue();
    }

    @Override
    public void putDataBatch(MetricData[] metricDatas) {
        for (MetricData item : metricDatas) {
            this.putData(item);
        }
    }

    @Override
    public Datapoint[] getMetricData(GetMetricStatisticsRequest request) {
        return this.getMetricData(request.getCategory(), request.getMetricName(), request.getStatistics(), request.getPeriod(), request.getStartTime(), request.getEndTime());
    }

    @Override
    public Datapoint[] getAlarmData(GetAlarmStatisticsRequest request) {
        return this.getMetricData(request.getCategory(), request.getMetricName(), request.getStatistics(), request.getPeriod(), request.getStartTime(), request.getEndTime());
    }

    private String getCacheKey(String category, String metricName) {
        return category + "." + metricName;
    }

    private void cleanExpiredMetricData(LinkedList<Datapoint> datapoints) {
        Iterator it = datapoints.iterator();
        while (it.hasNext()) {
            Datapoint datapoint = (Datapoint)it.next();
            Date expireDate = CommonUtil.dateAdd(new Date(), -600);
            if (!datapoint.getTimestamp().before(expireDate)) break;
            it.remove();
        }
    }

    private boolean getAlarmEnabled(String category, String metricName) {
        return WatchServer.getInstance().getMetaStore().getAlarmEnabled(category, metricName);
    }

    private Datapoint[] getMetricData(String category, String metricName, Statistic statistic, int period, Date dateFm, Date dateTo) {
        String cacheKey = this.getCacheKey(category, metricName);
        List datapoints = (List)this.metricDataList.getIfPresent((Object)cacheKey);
        if (datapoints == null) {
            return null;
        }
        int periodX = period <= 10 ? 10 : period;
        Map<Long, DoubleSummaryStatistics> map = datapoints.stream().filter(s -> s.getTimestamp().after(dateFm) && (dateTo == null || s.getTimestamp().before(dateTo))).collect(Collectors.groupingBy(p -> p.getTimestamp().getTime() / 1000L / (long)periodX, Collectors.summarizingDouble(Datapoint::getValues)));
        Datapoint[] retVal = new Datapoint[map.size()];
        int i = 0;
        for (Map.Entry<Long, DoubleSummaryStatistics> entry : map.entrySet()) {
            Datapoint datapoint = new Datapoint();
            long timeStick = entry.getKey() * 1000L * (long)periodX;
            datapoint.setTimestamp(new Date(timeStick));
            datapoint.setValues(this.getStatisticsValue(entry.getValue(), statistic, ((Datapoint)datapoints.get(0)).getDimensionValues().get("metricType")));
            if (datapoints.size() > 0) {
                datapoint.setDimensionValues(((Datapoint)datapoints.get(0)).getDimensionValues());
            }
            retVal[i] = datapoint;
            ++i;
        }
        return retVal;
    }

    private Double getStatisticsValue(DoubleSummaryStatistics data, Statistic statistic, String metricType) {
        switch (statistic) {
            case Sum: {
                return data.getSum();
            }
            case Max: {
                return data.getMax();
            }
            case Min: {
                return data.getMin();
            }
            case Count: {
                if (Gauge.class.getSimpleName().equals(metricType)) {
                    return data.getMax();
                }
                if (Counter.class.getSimpleName().equals(metricType) || Timer.class.getSimpleName().equals(metricType) || Histogram.class.getSimpleName().equals(metricType) || Meter.class.getSimpleName().equals(metricType)) {
                    return data.getSum();
                }
                return data.getCount();
            }
        }
        return data.getAverage();
    }
}

