/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.ha.config.HaConfigFactory;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.alarm.AlarmData;
import kd.bos.ha.watch.alarm.AlarmState;
import kd.bos.ha.watch.data.AlarmActionHistory;
import kd.bos.ha.watch.data.AlarmStateHistory;
import kd.bos.ha.watch.data.MetaStore;
import kd.bos.ha.watch.data.MetaStoreListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ZKMetaStore
implements MetaStore {
    private static Log logger = LogFactory.getLog(ZKMetaStore.class);
    private Set<MetaStoreListener> listenerList = new HashSet<MetaStoreListener>();
    private List<Alarm> alarmList = new ArrayList<Alarm>();
    private Cache<String, AlarmData> alarmDataCache = CacheBuilder.newBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS).build();

    public ZKMetaStore() {
        this.loadMetaData();
    }

    @Override
    public void addListener(MetaStoreListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeListener(MetaStoreListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void reloadMetaData() {
        this.loadMetaData();
        for (MetaStoreListener l : this.listenerList) {
            l.afterReloadAlarmList(this.alarmList);
        }
    }

    private void loadMetaData() {
        List<Alarm> alarms = HaConfigFactory.createHaConfig().getAlarmList();
        if (alarms != null) {
            this.alarmList = alarms;
        }
    }

    @Override
    public boolean getAlarmEnabled(String category, String metricName) {
        return this.alarmList.stream().filter(s -> s.getCategory().equals(category) && s.getMetricName().equals(metricName)).count() > 0L;
    }

    @Override
    public List<Alarm> getAlarms() {
        return this.alarmList;
    }

    @Override
    public Alarm getAlarm(String category, String metricName, String alarmName) {
        Optional<Alarm> alarm = this.alarmList.stream().filter(s -> s.getCategory().equals(category) && s.getMetricName().equals(metricName) && s.getName().equals(alarmName)).findFirst();
        if (alarm.isPresent()) {
            return alarm.get();
        }
        return null;
    }

    @Override
    public Action getAlarmAction(Alarm alarm, String actionName) {
        if (alarm == null || alarm.getActions() == null) {
            return null;
        }
        Optional<Action> action = alarm.getActions().stream().filter(s -> s.getName().equals(actionName)).findFirst();
        if (action.isPresent()) {
            return action.get();
        }
        return null;
    }

    @Override
    public List<Action> getAlarmActions(Alarm alarm) {
        if (alarm == null || alarm.getActions() == null) {
            return null;
        }
        return alarm.getActions();
    }

    @Override
    public List<Action> getAlarmActionsByState(Alarm alarm, AlarmState state) {
        List<Action> lstActions = this.getAlarmActions(alarm);
        if (lstActions != null) {
            lstActions = lstActions.stream().filter(s -> s.getState() == state || s.isSysDefault()).collect(Collectors.toList());
        }
        return lstActions;
    }

    @Override
    public boolean updateAlarmState(String category, String metricName, String name, AlarmState state, Date stateUpdatedTimestamp) {
        Alarm alarm = this.getAlarm(category, metricName, name);
        if (alarm != null) {
            alarm.setState(state);
            alarm.setStateUpdatedTimestamp(stateUpdatedTimestamp);
            return true;
        }
        return false;
    }

    @Override
    public AlarmData getAlarmData(String category, String metricName, String alarmName) {
        String cacheKey = AlarmData.GetCacheKey(category, metricName, alarmName);
        AlarmData alarmData = (AlarmData)this.alarmDataCache.getIfPresent((Object)cacheKey);
        if (alarmData == null) {
            alarmData = new AlarmData(category, metricName, alarmName);
        }
        return alarmData;
    }

    @Override
    public void saveAlarmActionTime(AlarmData alarmData) {
        this.putAlarmDataToCache(alarmData);
    }

    @Override
    public void saveAlarmStateTime(AlarmData alarmData) {
        this.putAlarmDataToCache(alarmData);
    }

    @Override
    public void addAlarmStateHistory(String category, String metricName, String name, String state, String reason, Date timestamp, String currData) {
        logger.info("HaWatch--Add AlarmStateHistory-category:" + category + ",metric:" + metricName + ",alarmName:" + name + ",state:" + state + ",currData:" + currData);
    }

    @Override
    public void addAlarmActionHistory(String category, String metricName, String alarmName, String actionName, String actionType, String actionResult, String actionDesc, Date timestamp, String currData) {
        logger.info("HaWatch--Add AlarmActionHistory-category:" + category + ",metric:" + metricName + ",alarmName:" + alarmName + ",actionName:" + actionName + ",actionType:" + actionType + ",currData:" + currData + ",actionDesc:" + actionDesc);
    }

    @Override
    public List<AlarmStateHistory> getAlarmStateAllHistory(String category, String metricName, String alarmName, String state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AlarmActionHistory> getAlarmActionAllHistory(String category, String metricName, String alarmName, String actionResult, String actionType) {
        throw new UnsupportedOperationException();
    }

    private void putAlarmDataToCache(AlarmData alarmData) {
        String cacheKey = AlarmData.GetCacheKey(alarmData.getCategory(), alarmData.getMetricName(), alarmData.getAlarmName());
        this.alarmDataCache.put((Object)cacheKey, (Object)alarmData);
    }
}

