/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.reporter;

import java.util.Collection;
import java.util.Date;
import kd.bos.ha.watch.alarm.MetricData;
import kd.bos.ha.watch.server.WatchServer;
import kd.bos.metric.reporter.cloudmetric.measurements.Measure;
import kd.bos.metric.reporter.cloudmetric.measurements.QueueableSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaWatchSender
extends QueueableSender {
    private static Logger logger = LoggerFactory.getLogger(HaWatchSender.class);
    private static int MAX_MEASURES_IN_SINGLE_POST = 50;

    public HaWatchSender() {
        super(MAX_MEASURES_IN_SINGLE_POST);
    }

    public HaWatchSender(int queueSize) {
        super(queueSize);
    }

    public HaWatchSender(int queueSize, int maxCacheTime) {
        super(queueSize, maxCacheTime);
    }

    protected boolean doSend(Collection<Measure> measuresToSend) {
        if (!WatchServer.getInstance().getActionMonitor().isStarted()) {
            return false;
        }
        try {
            for (Measure item : measuresToSend) {
                MetricData metricData = this.getMetricDataFromMeasure(item);
                WatchServer.getInstance().getMetricDataStore().putData(metricData);
            }
            return true;
        }
        catch (Exception ex) {
            logger.warn(String.format("couldn't send metrics to HAWatch, reason: %s", ex.getMessage(), ex));
            return false;
        }
    }

    private MetricData getMetricDataFromMeasure(Measure m) {
        MetricData metricData = new MetricData();
        metricData.setCategory(m.getCategory());
        metricData.setMetricName(m.getName());
        metricData.setDimensionValues(m.getTags());
        metricData.setTimestamp(new Date(m.getTimestamp()));
        metricData.setValue(m.getValue().doubleValue());
        metricData.setMetricType(m.getMetricType());
        return metricData;
    }
}

