/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.server;

import kd.bos.ha.watch.action.ActionSpiFactory;
import kd.bos.ha.watch.data.MemMetricDataStore;
import kd.bos.ha.watch.data.MetaStore;
import kd.bos.ha.watch.data.MetricDataStore;
import kd.bos.ha.watch.data.ZKMetaStore;
import kd.bos.ha.watch.server.monitor.AlarmMonitor;

public class WatchServer {
    private static WatchServer instance = null;
    private ActionSpiFactory actionSpiFactory;
    private AlarmMonitor actionMonitor;
    private MetaStore metaStore;
    private MetricDataStore metricDataStore;

    private static synchronized void syncInit() {
        if (instance == null) {
            instance = new WatchServer();
        }
    }

    public static WatchServer getInstance() {
        if (instance == null) {
            WatchServer.syncInit();
        }
        return instance;
    }

    public WatchServer() {
        this.initDataStore();
        this.initActionMonitor();
    }

    private void initDataStore() {
        this.metaStore = new ZKMetaStore();
        this.metricDataStore = new MemMetricDataStore();
    }

    private void initActionMonitor() {
        this.actionSpiFactory = new ActionSpiFactory();
        this.actionMonitor = new AlarmMonitor(this);
    }

    public MetaStore getMetaStore() {
        return this.metaStore;
    }

    public MetricDataStore getMetricDataStore() {
        return this.metricDataStore;
    }

    public ActionSpiFactory getActionSpiFactory() {
        return this.actionSpiFactory;
    }

    public AlarmMonitor getActionMonitor() {
        return this.actionMonitor;
    }

    public void stop() {
        this.actionMonitor.stop();
    }

    public void start() {
        this.actionMonitor.start();
    }
}

