/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.server.monitor;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.OperationContextCreator;
import kd.bos.ha.config.HaConfigFactory;
import kd.bos.ha.watch.action.Action;
import kd.bos.ha.watch.action.ActionExecResult;
import kd.bos.ha.watch.action.ActionSpi;
import kd.bos.ha.watch.action.ActionTriggerData;
import kd.bos.ha.watch.action.spi.SpiUtil;
import kd.bos.ha.watch.alarm.Alarm;
import kd.bos.ha.watch.alarm.AlarmData;
import kd.bos.ha.watch.alarm.AlarmState;
import kd.bos.ha.watch.alarm.ComparisonOperator;
import kd.bos.ha.watch.alarm.Unit;
import kd.bos.ha.watch.data.Datapoint;
import kd.bos.ha.watch.data.GetAlarmStatisticsRequest;
import kd.bos.ha.watch.data.MetaStoreListener;
import kd.bos.ha.watch.server.Monitor;
import kd.bos.ha.watch.server.WatchServer;
import kd.bos.ha.watch.server.monitor.AlarmMonitorItem;
import kd.bos.ha.watch.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AlarmMonitor
implements Monitor<AlarmMonitorItem> {
    private static Log logger = LogFactory.getLog(AlarmMonitor.class);
    private WatchServer server;
    private volatile boolean isStop = true;
    private ConcurrentHashMap<AlarmMonitorItem, ActionMonitorWorker> workers = new ConcurrentHashMap();

    public AlarmMonitor(WatchServer server) {
        this.server = server;
        this.loadAlarmsData();
        this.init();
    }

    private void init() {
        this.server.getMetaStore().addListener(new MetaStoreListener(){

            @Override
            public void afterReloadAlarmList(List<Alarm> alarm) {
                AlarmMonitor.this.reloadAllMonitorItem();
            }
        });
    }

    private void loadAlarmsData() {
        List<Alarm> alarms = this.server.getMetaStore().getAlarms();
        for (Alarm alarm : alarms) {
            AlarmMonitorItem item = new AlarmMonitorItem();
            item.setAlarm(alarm);
            this.addMonitorItem(item);
        }
    }

    @Override
    public void addMonitorItem(AlarmMonitorItem item) {
        this.initMonitorItem(item);
    }

    private void initMonitorItem(AlarmMonitorItem item) {
        ActionMonitorWorker worker = new ActionMonitorWorker(item);
        this.workers.put(item, worker);
    }

    @Override
    public void removeMonitorItem(AlarmMonitorItem item) {
        this.workers.remove(item);
    }

    @Override
    public void removeAllMonitorItem() {
        this.workers.clear();
    }

    @Override
    public void reloadAllMonitorItem() {
        HashSet<AlarmMonitorItem> newAlarmMonitorItems = new HashSet<AlarmMonitorItem>(10);
        Set oldAlarmMonitorItems = this.workers.keySet();
        List<Alarm> alarms = this.server.getMetaStore().getAlarms();
        for (Alarm alarm : alarms) {
            AlarmMonitorItem item = new AlarmMonitorItem();
            item.setAlarm(alarm);
            for (AlarmMonitorItem oldAlarmMonitorItem : oldAlarmMonitorItems) {
                if (!oldAlarmMonitorItem.equals(item) || AlarmState.ALARM != oldAlarmMonitorItem.getAlarm().getState()) continue;
                item.getAlarm().setState(AlarmState.ALARM);
            }
            newAlarmMonitorItems.add(item);
        }
        this.removeAllMonitorItem();
        for (AlarmMonitorItem item : newAlarmMonitorItems) {
            this.addMonitorItem(item);
        }
    }

    @Override
    public boolean isStarted() {
        return !this.isStop;
    }

    @Override
    public void start() {
        if (!this.isStop) {
            return;
        }
        this.isStop = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                OperationContextCreator.getOrCreateForBos();
                logger.info("HaWatch: start AlarmMonitor thread ...");
                while (!AlarmMonitor.this.isStop) {
                    AlarmMonitor.this.loop();
                }
                logger.info("HaWatch: exit AlarmMonitor thread ...");
            }
        }, "ActionMonitor").start();
    }

    @Override
    public void stop() {
        this.isStop = true;
    }

    private void loop() {
        try {
            Thread.sleep(HaConfigFactory.createHaConfig().getInterval() * 1000);
            if (!HaConfigFactory.createHaConfig().isEnable()) {
                return;
            }
            CommonUtil.DebugLog("====HaWatch.AlarmMonitor-loop====");
        }
        catch (InterruptedException e) {
            logger.error("HaWatch: InterruptedException ", (Throwable)e);
        }
        for (ActionMonitorWorker worker : this.workers.values()) {
            try {
                worker.work();
            }
            catch (Exception t) {
                logger.error("HaWatch: ActionMonitorWorker.worker exception", (Throwable)t);
            }
        }
    }

    private static class Window {
        private Alarm alarm;
        private int size;
        private AlarmState state;
        private GroupFrame groupFrame = null;
        private Date lastDataPointDate = null;
        private Date nextDataPointDate = null;

        public Window(Alarm alarm, int size) {
            this.alarm = alarm;
            this.size = size;
            this.state = alarm.getState();
            if (this.state == null) {
                this.state = AlarmState.INSUFFICIENT_DATA;
            }
        }

        public void addFrame(Map<String, String> groupKeyValue, Date timestamp, Double value) {
            if (this.groupFrame == null) {
                this.groupFrame = new GroupFrame(this.alarm, this.size, this.state, groupKeyValue);
            }
            this.groupFrame.addFrame(timestamp, value);
        }

        public void setLastDataPointDate(Date date) {
            this.lastDataPointDate = date;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(13, this.alarm.getPeriod());
            this.nextDataPointDate = cal.getTime();
        }

        public boolean shouldQueryNow() {
            if (this.nextDataPointDate == null) {
                return true;
            }
            return this.nextDataPointDate.getTime() < System.currentTimeMillis();
        }
    }

    private static class GroupFrame {
        private Map<String, String> groupKeyValue;
        private Alarm alarm;
        private LinkedList<Frame> frameList = new LinkedList();
        private AlarmState state;
        private int size = 0;

        GroupFrame(Alarm alarm, int size, AlarmState state, Map<String, String> groupKeyValue) {
            this.state = state;
            this.size = size;
            this.alarm = alarm;
            this.groupKeyValue = groupKeyValue == null ? new HashMap() : groupKeyValue;
        }

        public void addFrame(Date timestamp, Double value) {
            if (this.frameList.size() == this.size) {
                this.frameList.remove(0);
            }
            Frame frame = new Frame();
            frame.value = value;
            this.frameList.add(frame);
            if (value == null) {
                frame.state = AlarmState.INSUFFICIENT_DATA;
            } else if (ComparisonOperator.eval(this.alarm.getComparisonOperator(), value, this.alarm.getThreshold(), this.alarm.getUnit())) {
                frame.state = AlarmState.ALARM;
            } else {
                frame.state = AlarmState.OK;
            }
        }

        public Frame lastFrame() {
            if (this.frameList != null && this.frameList.size() > 0) {
                return this.frameList.getLast();
            }
            return null;
        }

        public AlarmState allSameState() {
            if (this.frameList.size() < this.size) {
                return null;
            }
            AlarmState state = this.frameList.get(0).state;
            for (int i = 1; i < this.frameList.size(); ++i) {
                if (this.frameList.get(i).state == state) continue;
                return null;
            }
            return state;
        }

        public Double[] getValues() {
            Double[] values = new Double[this.frameList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.frameList.get(i).value;
            }
            return values;
        }
    }

    private static class Frame {
        private AlarmState state;
        private Double value;

        private Frame() {
        }
    }

    private class ActionMonitorWorker {
        private AlarmMonitorItem item;
        private Window window;

        ActionMonitorWorker(AlarmMonitorItem item) {
            this.item = item;
            this.init();
        }

        public final void init() {
            this.window = new Window(this.item.getAlarm(), this.item.getAlarm().getEvaluationPeriods());
        }

        public void work() {
            long ts;
            if (!this.window.shouldQueryNow()) {
                return;
            }
            Alarm alarm = this.item.getAlarm();
            Date from = null;
            if (this.window.lastDataPointDate == null) {
                from = new Date();
                ts = from.getTime();
                from.setTime(ts -= (long)(alarm.getPeriod() * alarm.getEvaluationPeriods() * 1000));
            } else {
                ts = this.window.lastDataPointDate.getTime();
                from = new Date(ts += (long)(alarm.getPeriod() * 1000));
            }
            GetAlarmStatisticsRequest request = new GetAlarmStatisticsRequest();
            request.setCategory(alarm.getCategory());
            request.setMetricName(alarm.getMetricName());
            request.setAlarmName(alarm.getName());
            request.setPeriod(alarm.getPeriod());
            request.setStatistics(alarm.getStatistic());
            request.setStartTime(from);
            request.setAlarm(alarm);
            Datapoint[] response = AlarmMonitor.this.server.getMetricDataStore().getAlarmData(request);
            boolean hasData = false;
            Date returnTimestamp = null;
            if (response != null && response.length > 0) {
                Datapoint[] points = response;
                if (points != null && points.length > 0) {
                    hasData = true;
                    for (int i = 0; i < points.length; ++i) {
                        this.window.addFrame(points[i].getDimensionValues(), points[i].getTimestamp(), points[i].getValues());
                        returnTimestamp = points[i].getTimestamp();
                    }
                }
                if (hasData) {
                    Date date = returnTimestamp;
                    this.window.setLastDataPointDate(date);
                    this.checkAlarmState();
                }
            }
        }

        private void checkAlarmState() {
            if (this.window.groupFrame == null) {
                return;
            }
            GroupFrame groupFrame = this.window.groupFrame;
            AlarmState newState = groupFrame.allSameState();
            if (newState == null) {
                return;
            }
            AlarmState oldState = groupFrame.state;
            groupFrame.state = newState;
            this.changeAlarmState(groupFrame, oldState, newState);
            this.setLastAlarmStateTimeSum();
        }

        private void changeAlarmState(GroupFrame groupFrame, AlarmState oldState, AlarmState newState) {
            Alarm alarm = this.item.getAlarm();
            Date timestamp = new Date();
            this.triggerAction(groupFrame, alarm, oldState, newState, timestamp);
        }

        private void triggerAction(GroupFrame groupFrame, Alarm alarm, AlarmState oldState, AlarmState newState, Date timestamp) {
            if (!alarm.isActionEnabled()) {
                return;
            }
            if (oldState != AlarmState.ALARM && newState == AlarmState.OK) {
                return;
            }
            Date now = new Date();
            String time = new SimpleDateFormat("HH:mm").format(now);
            if (alarm.getTimeFm().compareTo(time) > 0 || time.compareTo(alarm.getTimeTo()) > 0) {
                return;
            }
            AlarmData lastAlarmData = AlarmMonitor.this.server.getMetaStore().getAlarmData(alarm.getCategory(), alarm.getMetricName(), alarm.getName());
            if (!this.checkLastAlarmActionTimeByDimesion(lastAlarmData, oldState, newState, alarm.getSilentPeriod())) {
                return;
            }
            if (newState == AlarmState.INSUFFICIENT_DATA && lastAlarmData.getLastAlarmStateTime() == null) {
                return;
            }
            List<Action> actions = this.getActions(alarm, newState);
            if (actions == null || actions.isEmpty()) {
                return;
            }
            ActionTriggerData actionTriggerData = new ActionTriggerData();
            actionTriggerData.setOldState(oldState);
            actionTriggerData.setNewState(newState);
            actionTriggerData.setTimestamp(timestamp);
            actionTriggerData.setValues(groupFrame.getValues());
            actionTriggerData.setDimensionMap(groupFrame.groupKeyValue);
            String currDataDesc = SpiUtil.getValuesWithHumanDesc(groupFrame.getValues(), alarm.getUnit());
            String msg = SpiUtil.GetAlarmMsgDesc(actionTriggerData, alarm);
            this.recordAlarmHistory(alarm, newState, msg, currDataDesc);
            for (Action action : actions) {
                try {
                    ActionSpi actionSpi = AlarmMonitor.this.server.getActionSpiFactory().get(action.getActionType());
                    if (actionSpi == null || !this.checkActionSpiBySysData(actionSpi)) continue;
                    ActionExecResult result = actionSpi.execute(action, actionTriggerData, alarm);
                    this.recordActionHistory(action, result, currDataDesc);
                }
                catch (Throwable e) {
                    logger.error("AlarmMonitor excute action error,action = " + action.getActionType(), e);
                }
            }
            this.setLastAlarmActionTimeByDimesion(lastAlarmData);
        }

        private boolean checkActionSpiBySysData(ActionSpi actionSpi) {
            return true;
        }

        private void recordActionHistory(Action action, ActionExecResult actionExecResult, String currData) {
            try {
                Date timestamp = new Date();
                AlarmMonitor.this.server.getMetaStore().addAlarmActionHistory(action.getCategory(), action.getMetricName(), action.getAlarmName(), action.getName(), action.getActionType(), actionExecResult.getActionResult().toString(), actionExecResult.getActionDesc(), timestamp, currData);
            }
            catch (Exception e) {
                logger.error("record action history failed.", (Throwable)e);
            }
        }

        private boolean checkLastAlarmActionTimeByDimesion(AlarmData alarmData, AlarmState oldState, AlarmState newState, int silientPeriod) {
            Date now;
            if (alarmData.getLastAlarmActionTime() == null) {
                return true;
            }
            Date nextActionDate = now = new Date();
            nextActionDate = alarmData.getLastAlarmActionTime();
            Calendar c = Calendar.getInstance();
            c.setTime(nextActionDate);
            c.add(13, silientPeriod);
            nextActionDate = c.getTime();
            return oldState != newState || now.compareTo(nextActionDate) >= 0;
        }

        private void setLastAlarmActionTimeByDimesion(AlarmData alarmData) {
            try {
                alarmData.setLastAlarmActionTime(new Date());
                AlarmMonitor.this.server.getMetaStore().saveAlarmActionTime(alarmData);
            }
            catch (Exception e) {
                logger.error("save LastAlarmActionTime failed.", (Throwable)e);
            }
        }

        private void setLastAlarmStateTimeByDimesion(AlarmData alarmData, AlarmState alarmState, GroupFrame groupFrame, Unit unit) {
            try {
                alarmData.setAlarmState(alarmState);
                alarmData.setLastAlarmStateTime(new Date());
                String triggerDataDesc = SpiUtil.getValuesWithHumanDesc(groupFrame.getValues(), unit);
                alarmData.setCurrData(triggerDataDesc);
                AlarmMonitor.this.server.getMetaStore().saveAlarmStateTime(alarmData);
            }
            catch (Exception e) {
                logger.error("save LastAlarmActionTime failed.", (Throwable)e);
            }
        }

        private void setLastAlarmStateTimeSum() {
            AlarmState alarmState = AlarmState.INSUFFICIENT_DATA;
            GroupFrame gf = this.window.groupFrame;
            if (gf != null) {
                alarmState = gf.state;
            }
            Alarm alarm = this.item.getAlarm();
            Date timestamp = new Date();
            AlarmMonitor.this.server.getMetaStore().updateAlarmState(alarm.getCategory(), alarm.getMetricName(), alarm.getName(), alarmState, timestamp);
            alarm.setState(alarmState);
            alarm.setStateUpdatedTimestamp(timestamp);
        }

        private void recordAlarmHistory(Alarm alarm, AlarmState newState, String msg, String currData) {
            try {
                Date timestamp = new Date();
                AlarmMonitor.this.server.getMetaStore().addAlarmStateHistory(alarm.getCategory(), alarm.getMetricName(), alarm.getName(), newState.toString(), msg, timestamp, currData);
            }
            catch (Exception e) {
                logger.error("recordAlarmHistory failed.", (Throwable)e);
            }
        }

        private List<Action> getActions(Alarm alarm, AlarmState newState) {
            return AlarmMonitor.this.server.getMetaStore().getAlarmActionsByState(alarm, newState);
        }
    }
}

