/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.util;

import java.util.Calendar;
import java.util.Date;
import kd.bos.ha.watch.alarm.Unit;

public class CommonUtil {
    public static String getSizeWithHumanDesc(double size, Unit unit) {
        String desc = "";
        if (unit.ordinal() >= Unit.Bytes.ordinal() && unit.ordinal() <= Unit.Terabytes.ordinal()) {
            if (size >= 1.073741824E9) {
                double i = size / 1.073741824E9;
                desc = String.format("%.2fGB", i);
            } else if (size >= 1048576.0) {
                double i = size / 1048576.0;
                desc = String.format("%.1fMB", i);
            } else if (size >= 1024.0) {
                double i = size / 1024.0;
                desc = String.format("%.1fKB", i);
            } else if (size < 1024.0) {
                desc = size <= 0.0 ? "0Byte" : String.format("%.0fBytes", size);
            }
        } else {
            desc = unit == Unit.Percent ? String.format("%.1f%s", size * 100.0, unit.getDesc()) : String.format("%.1f%s", size, unit.getDesc());
        }
        return desc;
    }

    public static double getNumberFromHumanSize(double size, Unit unit) {
        double retVal;
        switch (unit) {
            case Bytes: 
            case BytesPerSecond: {
                retVal = size;
                break;
            }
            case Kilobytes: 
            case KilobytesPerSecond: {
                retVal = size * 1024.0;
                break;
            }
            case Megabytes: 
            case MegabytesToSecond: {
                retVal = size * 1024.0 * 1024.0;
                break;
            }
            case Gigabytes: 
            case GigabytesPerSecond: {
                retVal = size * 1024.0 * 1024.0 * 1024.0;
                break;
            }
            case Terabytes: 
            case TerabytesPerSecond: {
                retVal = size * 1024.0 * 1024.0 * 1024.0 * 1024.0;
                break;
            }
            case Percent: {
                retVal = size / 100.0;
                break;
            }
            default: {
                retVal = size;
            }
        }
        return retVal;
    }

    public static Date dateAdd(Date date, int addSeconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, addSeconds);
        return calendar.getTime();
    }

    public static long getTimeStampPeriod(Date timestamp, int period) {
        if (period <= 1) {
            period = 1;
        }
        return timestamp.getTime() / 1000L / (long)period;
    }

    public static void DebugLog(String msg) {
    }
}

