/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.util;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import kd.bos.ha.watch.action.spi.EmailConfig;
import kd.bos.util.StringUtils;

public class EmailUtil {
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMail(String receiver, String subject, String context, EmailConfig emailConfig) throws MessagingException, AddressException {
        if (StringUtils.isEmpty((String)receiver) || receiver.length() < 8) {
            return;
        }
        int timeout = emailConfig.getTimeout() <= 0 ? 3000 : emailConfig.getTimeout();
        String timeoutStr = String.valueOf(timeout);
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", emailConfig.getMailHost());
        props.setProperty("mail.smtp.port", emailConfig.getPort().toString());
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.connectiontimeout", timeoutStr);
        props.setProperty("mail.smtp.timeout", timeoutStr);
        props.setProperty("mail.smtp.writetimeout", timeoutStr);
        if (emailConfig.isUseSSL()) {
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", emailConfig.getPort().toString());
        }
        Session session = Session.getInstance((Properties)props);
        try (Transport transport = null;){
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(emailConfig.getSender()));
            message.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternetAddress.parse((String)receiver));
            message.setSubject(subject, "UTF-8");
            message.setContent((Object)context, "text/html;charset=UTF-8");
            message.setSentDate(new Date());
            message.saveChanges();
            transport = session.getTransport();
            transport.connect(emailConfig.getUserName(), emailConfig.getPassword());
            transport.sendMessage((Message)message, message.getAllRecipients());
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

