/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.watch.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.api.Probe;
import kd.bos.ha.watch.action.spi.SmsApiConfig;
import kd.bos.ha.watch.alarm.AlarmState;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class SmsUtil {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 3000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;

    public static void sendSmsMessage(String phone, String message, AlarmState alarmState, SmsApiConfig smsConfig) throws IOException {
        String portString;
        if (StringUtils.isEmpty((String)phone) || phone.length() < 11) {
            return;
        }
        int connectTimeout = smsConfig.getConnectTimeout() <= 0 ? 3000 : smsConfig.getConnectTimeout();
        int socketTimeout = smsConfig.getSocketTimeout() <= 0 ? 5000 : smsConfig.getSocketTimeout();
        String smsApiUrl = smsConfig.getApiUrl();
        String clientID = smsConfig.getClientID();
        String clientSecret = smsConfig.getClientSecret();
        String smsCode = smsConfig.getSmsCode();
        String signature = smsConfig.getSignature();
        String countryCode = smsConfig.getCountryCode();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientID);
        params.put("client_secret", clientSecret);
        params.put("phone", phone);
        params.put("smscode", smsCode);
        params.put("content", message);
        params.put("signature", signature);
        params.put("country_code", countryCode);
        String encoding = "UTF-8";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(smsApiUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        post.setConfig(requestConfig);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(10);
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = "";
            }
            BasicNameValuePair pair = new BasicNameValuePair(name, value);
            parameters.add(pair);
        }
        UrlEncodedFormEntity encodedFormEntity = new UrlEncodedFormEntity(parameters, encoding);
        post.setEntity((HttpEntity)encodedFormEntity);
        String host = System.getProperty("cq.http.proxyHost");
        if (StringUtils.isNotEmpty((String)host) && StringUtils.isNumericString((String)(portString = System.getProperty("cq.http.proxyPort")))) {
            HttpHost proxy = new HttpHost(host, Integer.parseInt(portString), "http");
            RequestConfig defaultRequestConfig = RequestConfig.custom().setProxy(proxy).build();
            post.setConfig(defaultRequestConfig);
        }
        Probe.touch((String)"http");
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(Resources.getString((String)"\u53d1\u9001\u77ed\u4fe1\u8fd4\u56de\u9519\u8bef", (String)"SmsUtil_0", (String)"bos-ha", (Object[])new Object[0]) + "\uff1a" + response.toString());
        }
    }

    public static String execShell(String scriptPath, String para1) {
        return SmsUtil.execShell(scriptPath, para1, "", "");
    }

    public static String execShell(String scriptPath, String para1, String para2, String para3) {
        throw new UnsupportedOperationException();
    }
}

