/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.exception;

import kd.bos.mservice.common.exception.RpcErrorInfo;
import kd.bos.mservice.sdk.bundle.SdkResources;

public enum RpcErrorCode {
    consumerClusterDestory(1000),
    consumerClusterNoProvider(4),
    consumerInvokerNotFound(1001),
    consumerProviderNetworkClose(1002),
    consumerSendChannelClose(1004),
    consumerWebRequestTimeout(1006),
    consumerNetwork(1007),
    consumerTimeOut(1008),
    providerExecute(2000),
    providerTimeOut(2004),
    providerSendChanelClose(2006),
    providerNotResponse(2008);

    public static final String PROJECT_NAME = "bos-mservice-sdk-common";
    public static final String PREFIX_ERROR_CODE = "RpcErrorCode_";
    public final int code;

    public static String getMsgByCode(RpcErrorInfo rpcErrorInfo) {
        String msg;
        String instanceId = rpcErrorInfo.getInstanceId();
        String timeout = rpcErrorInfo.getTimeout();
        String remoteIp = rpcErrorInfo.getRemoteIp();
        String apiName = rpcErrorInfo.getApiName();
        String appIdName = rpcErrorInfo.getAppIdName();
        String logId = rpcErrorInfo.getLogId();
        switch (rpcErrorInfo.getErrorCode()) {
            case 1000: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerClusterDestory.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 4: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerClusterNoProvider.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 1001: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerInvokerNotFound.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 1002: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerProviderNetworkClose.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, logId});
                break;
            }
            case 1004: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerSendChannelClose.getCode()), (String)"", (Object[])new Object[]{apiName, remoteIp, logId});
                break;
            }
            case 1006: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerWebRequestTimeout.getCode()), (String)"", (Object[])new Object[]{apiName, rpcErrorInfo.getCostTime(), timeout, logId});
                break;
            }
            case 1007: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerNetwork.getCode()), (String)"", (Object[])new Object[]{apiName, logId});
                break;
            }
            case 1008: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + consumerTimeOut.getCode()), (String)"", (Object[])new Object[]{apiName, timeout, logId});
                break;
            }
            case 2000: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerExecute.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, instanceId, logId});
                break;
            }
            case 2004: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerTimeOut.getCode()), (String)"", (Object[])new Object[]{apiName, appIdName, remoteIp, timeout, logId});
                break;
            }
            case 2006: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerSendChanelClose.getCode()), (String)"", (Object[])new Object[]{apiName, remoteIp, logId});
                break;
            }
            case 2008: {
                msg = SdkResources.get((String)PROJECT_NAME, (String)(PREFIX_ERROR_CODE + providerNotResponse.getCode()), (String)"", (Object[])new Object[]{apiName, timeout, appIdName, instanceId, logId});
                break;
            }
            default: {
                msg = null;
            }
        }
        return msg;
    }

    private RpcErrorCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }
}

