/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.VerifyVisitor;
import kd.bos.formula.functions.UDFunctions;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormulaEngine {
    public static Expr parseFormula(String formula) {
        return ExprParser.parse(formula);
    }

    public static Object execExcelFormula(String formula) {
        return FormulaEngine.execExcelFormula(formula, Collections.emptyMap());
    }

    public static Object execExcelFormula(String formula, Map<String, Object> variableMap) {
        return FormulaEngine.execExcelFormula(formula, variableMap, null);
    }

    public static Object execExcelFormula(String formula, Map<String, Object> variableMap, UDFunction[] userDefinedFunctions) {
        Expr expr = ExprParser.parse(formula);
        return FormulaEngine.execExcelFormula(expr, variableMap, userDefinedFunctions);
    }

    public static Object execExcelFormula(Expr expr) {
        return FormulaEngine.execExcelFormula(expr, Collections.emptyMap());
    }

    public static Object execExcelFormula(Expr expr, Map<String, Object> variableMap) {
        return FormulaEngine.execExcelFormula(expr, variableMap, null);
    }

    public static Object execExcelFormula(Expr expr, Map<String, Object> variableMap, UDFunction[] userDefinedFunctions) {
        MapExecuteContext context = new MapExecuteContext(variableMap);
        for (UDFunction func : UDFunctions.all) {
            context.addUDFunction(func);
        }
        if (userDefinedFunctions != null) {
            for (UDFunction func : userDefinedFunctions) {
                context.addUDFunction(func);
            }
        }
        return expr.execute(context);
    }

    public static String[] extractVariables(String formula) {
        Expr expr = ExprParser.parse(formula);
        VerifyVisitor visitor = new VerifyVisitor(new MapExecuteContext());
        expr.accept(visitor);
        List<String> list = visitor.getInvalidSymboList();
        return list.toArray(new String[list.size()]);
    }
}

