/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.util.ArrayList;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.ExprBase;
import kd.bos.formula.excel.Visitor;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CompoundId
extends ExprBase {
    private ArrayList<NamePart> names = new ArrayList();
    private String fullName;

    public CompoundId(String name, boolean isKey) {
        this.fullName = name;
        this.names.add(new NamePart(name, isKey));
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public void append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
        this.fullName = this.fullName + "." + name;
    }

    public void append(String name) {
        this.names.add(new NamePart(name, false));
        this.fullName = this.fullName + "." + name;
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        for (NamePart np : this.names) {
            ret[i++] = np.name;
        }
        return ret;
    }

    private CompoundId() {
    }

    public Object clone() {
        CompoundId cloned = new CompoundId();
        for (NamePart np : this.names) {
            cloned.append(np.name, np.isKey);
        }
        return cloned;
    }

    public String toString() {
        return this.fullName;
    }

    public String toString(int end) {
        StringBuilder str = new StringBuilder();
        boolean isFollow = false;
        for (int i = 0; i < end; ++i) {
            NamePart np = this.names.get(i);
            if (isFollow) {
                str.append(".");
            }
            isFollow = true;
            str.append("[").append(np.name).append("]");
        }
        return str.toString();
    }

    @Override
    public Object execute(ExecuteContext context) {
        Object v = context.getValue(this.fullName);
        return v;
    }

    @Override
    public void accept(Visitor vistor) {
        vistor.visit(this);
    }

    private static class NamePart {
        private String name;
        private boolean isKey;

        protected NamePart(String name, boolean isKey) {
            this.name = name.startsWith("[") ? name.substring(1, name.length() - 1) : name;
            this.isKey = isKey;
        }
    }
}

