/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprBase;
import kd.bos.formula.excel.FormulaException;
import kd.bos.formula.excel.FunDef;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.bos.util.resource.Resources;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FunCall
extends ExprBase {
    public static final int FUNCTION = 0;
    public static final int METHOD = 1;
    public static final int PROPERTY = 2;
    private String name;
    private Expr[] params;
    private int type;

    FunCall(String name, Expr[] params) {
        this.name = name;
        this.params = params;
        this.type = 0;
    }

    FunCall(String name, Expr[] params, int type) {
        this.name = name;
        this.params = params;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Expr[] getParams() {
        return this.params;
    }

    public static boolean isFunCall(String name) {
        return FunDef.contains(name.toUpperCase());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 0: {
                sb.append(this.name).append("(");
                for (int i = 0; i < this.params.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.params[i].toString());
                }
                sb.append(")");
                break;
            }
            case 1: {
                sb.append(this.params[0].toString()).append(".").append(this.name).append("(");
                for (int i = 1; i < this.params.length; ++i) {
                    if (i > 1) {
                        sb.append(",");
                    }
                    sb.append(this.params[i].toString());
                }
                sb.append(")");
                break;
            }
            case 2: {
                sb.append(this.params[0].toString()).append(".").append(this.name);
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public Object execute(ExecuteContext context) {
        UDFunction udf = context.getUDFunction(this.name);
        if (udf != null) {
            Object[] paramValues = new Object[this.params.length];
            for (int i = 0; i < this.params.length; ++i) {
                paramValues[i] = this.params[i].execute(context);
            }
            return udf.call(paramValues);
        }
        FunDef funDef = FunDef.getFunDef(this.name);
        if (funDef == null) {
            throw new FormulaException(Resources.getString((String)"\u51fd\u6570", (String)"FunCall_0", (String)"bos-formula", (Object[])new Object[0]) + this.name + Resources.getString((String)"\u4e0d\u5b58\u5728.", (String)"FunCall_1", (String)"bos-formula", (Object[])new Object[0]));
        }
        return FunDef.getFunDef(this.name).execute(this, context);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].accept(visitor);
        }
    }
}

